<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;


// Verify for Payout ID
if ( empty( $_GET['payout_id'] ) ) {
	exit;
}

// Get the payment information
$payout = slicewp_get_payout( absint( $_GET['payout_id'] ) );

if ( is_null( $payout ) ) {
	return;
}

// Get the admin that generated the payout
$originator_user = get_user_by( 'id', $payout->get( 'originator_user_id' ) );

// Get the Payout Payments Count
$args = array(
	'payout_id' => $payout->get( 'id' )
);

$payments_count = slicewp_get_payments( $args, true );

// Get the Payout Payments Count for paid Payments
$args = array(
	'number'	=> -1,
	'payout_id' => $payout->get( 'id' ),
	'status'	=> 'paid'
);

$payments_paid 		 = slicewp_get_payments( $args );
$payments_paid_count = count( $payments_paid );

// Get the Payout Payments Count for unpaid Payments
$args = array(
	'number'	=> -1,
	'payout_id' => $payout->get( 'id' ),
	'status'	=> array_diff( array_keys( slicewp_get_payment_available_statuses() ), array( 'paid' ) )
);

$payments_unpaid 	   = slicewp_get_payments( $args );
$payments_unpaid_count = count( $payments_unpaid );

// Compute the Paid percentage.
$paid_percentage = ( $payments_count != 0 ? round( $payments_paid_count / $payments_count * 100 ) : INF );

?>

<div class="wrap slicewp-wrap slicewp-wrap-view-payout">

	<!-- Page Heading -->
	<h1 class="wp-heading-inline"><?php echo sprintf( __( 'Payout #%s', 'slicewp' ), $payout->get('id') ); ?></h1>
	<a href="<?php echo add_query_arg( array( 'subpage' => 'create-payout' ), $this->admin_url ); ?>" class="page-title-action"><?php echo __( 'Create Payout', 'slicewp' ); ?></a>
	<a href="<?php echo add_query_arg( array( 'subpage' => 'view-payments' ), $this->admin_url ); ?>" class="page-title-action"><?php echo __( 'View All Payments', 'slicewp' ); ?></a>
	<hr class="wp-header-end" />
	
	<div id="slicewp-content-wrapper">
			
		<!-- Primary Content -->
		<div id="slicewp-primary">

			<!-- Payout Details -->
			<div class="slicewp-card slicewp-first">

				<div class="slicewp-card-header">
					<span class="slicewp-card-title"><?php echo __( 'Payout Details', 'slicewp' ); ?></span>
				</div>

				<!-- Form Fields -->
				<div class="slicewp-card-inner">

					<!-- Payout ID -->
					<div class="slicewp-field-wrapper slicewp-field-wrapper-inline">

						<div class="slicewp-field-label-wrapper">
							<label for="slicewp-payout-id"><?php echo __( 'Payout ID', 'slicewp' ); ?></label>
						</div>
						
						<input id="slicewp-payout-id" name="payout_id" disabled type="text" value="<?php echo esc_attr( $payout->get( 'id' ) ); ?>" />

					</div>

					<!-- Amount -->
					<div class="slicewp-field-wrapper slicewp-field-wrapper-inline">

						<div class="slicewp-field-label-wrapper">
							<label for="slicewp-payout-amount"><?php echo __( 'Amount', 'slicewp' ); ?></label>
						</div>

						<input id="slicewp-payout-amount" name="amount" disabled type="text" value="<?php echo esc_attr( slicewp_format_amount( $payout->get( 'amount' ), slicewp_get_setting( 'active_currency', 'USD' ) ) ); ?>" />

					</div>
					
		            <!-- Payments Count -->
					<div class="slicewp-field-wrapper slicewp-field-wrapper-inline">

						<div class="slicewp-field-label-wrapper">
							<label for="slicewp-payments-count"><?php echo __( 'Payments', 'slicewp' ); ?></label>
						</div>
						
						<input id="slicewp-payments-count" name="payments_count" disabled type="text" value="<?php echo esc_attr( $payments_count ); ?>" />

					</div>
					
		            <!-- Payout Date -->
					<div class="slicewp-field-wrapper slicewp-field-wrapper-inline">

						<div class="slicewp-field-label-wrapper">
							<label for="slicewp-payout-date"><?php echo __( 'Date Created', 'slicewp' ); ?></label>
						</div>
						
						<input id="slicewp-payout-date" name="date_created" disabled type="text" value="<?php echo slicewp_date_i18n( esc_attr( $payout->get( 'date_created' ) ) ); ?>" />

					</div>

					<!-- Generated By -->
					<div class="slicewp-field-wrapper slicewp-field-wrapper-inline slicewp-last">

						<div class="slicewp-field-label-wrapper">
							<label for="slicewp-generated-by"><?php echo __( 'Generated By', 'slicewp' ); ?></label>
						</div>

						<div class="slicewp-field-link-disabled">
							<?php if ( ! $originator_user ): ?>
								<span><?php echo __( '(inexistent admin)', 'slicewp' ); ?></span>
							<?php else: ?>
								<a href="<?php echo add_query_arg( array( 'user_id' => $payout->get( 'originator_user_id' ) ), admin_url( 'user-edit.php' ) ); ?>"><?php echo esc_html( $originator_user->first_name . ' ' . $originator_user->last_name . ' ('. $originator_user->user_login . ')' ); ?></a>
							<?php endif; ?>
						</div>

					</div>

				</div>

			</div><!-- / Payout Details -->

			<!-- Payout Progress -->
			<?php if ( ! is_infinite( $paid_percentage ) ): ?>

				<form method="POST">

					<div id="slicewp-card-payout-progress" class="slicewp-card slicewp-first">

						<div class="slicewp-card-header">
							<span class="slicewp-card-title"><?php echo __( 'Payout Progress', 'slicewp' ); ?></span>
						</div>

						<div class="slicewp-card-inner">

							<div class="slicewp-grid slicewp-grid-columns-2 slicewp-no-collapse">

								<div class="slicew-grid-item">
									
									<span style="font-size: 14px;"><?php echo __( 'Paid', 'slicewp' ); ?></span>
									<div style="font-size: 28px; line-height: 1; margin-top: 20px; margin-bottom: 5px;"><?php echo slicewp_format_amount( array_sum( array_column( array_map( 'slicewp_object_to_array', $payments_paid ), 'amount' ) ), slicewp_get_setting( 'active_currency', 'USD' ) ); ?></div>
									<div style="margin-bottom: 25px;"><?php echo ( $payments_paid_count != 1 ? sprintf( __( '%d payments', 'slicewp' ), $payments_paid_count ) : sprintf( __( '%d payment', 'slicewp' ), $payments_paid_count ) ); ?></div>

								</div>

								<div class="slicew-grid-item" style="text-align: right;">
									
									<span style="font-size: 14px;"><?php echo __( 'Still to be paid', 'slicewp' ); ?></span>
									<div style="font-size: 28px; line-height: 1; margin-top: 20px; margin-bottom: 5px;"><?php echo slicewp_format_amount( array_sum( array_column( array_map( 'slicewp_object_to_array', $payments_unpaid ), 'amount' ) ), slicewp_get_setting( 'active_currency', 'USD' ) ); ?></div>
									<div style="margin-bottom: 25px;"><?php echo ( $payments_unpaid_count != 1 ? sprintf( __( '%d payments', 'slicewp' ), $payments_unpaid_count ) : sprintf( __( '%d payment', 'slicewp' ), $payments_unpaid_count ) ); ?></div>

								</div>

							</div>

							<!-- Progress -->
							<div class="slicewp-field-wrapper slicewp-last">
								
								<?php slicewp_output_progressbar( $paid_percentage ); ?>

							</div>

						</div>

						<?php

							$payout_methods = slicewp_get_payout_methods();

							foreach ( $payout_methods as $slug => $payout_method ) {

								// Make sure bulk payouts are supported by the payout method.
								if ( empty( $payout_method['supports'] ) || ! in_array( 'bulk_payments', $payout_method['supports'] ) ) {
									unset( $payout_methods[$slug] );
									continue;
								}
								
								// Make sure the payout method can do bulk payments for this payout.
								if ( ! slicewp_can_do_bulk_payments( $payout->get( 'id' ), $slug ) ) {
									unset( $payout_methods[$slug] );
									continue;
								}

							}
						
						?>

						<?php if ( ! empty( $payout_methods ) ): ?>

							<div class="slicewp-card-footer">

								<div class="slicewp-field-wrapper slicewp-field-wrapper-payout-method slicewp-last">

									<div class="slicewp-field-label-wrapper">
										<label for="slicewp-payment-payout-method"><?php echo __( 'Bulk process...', 'slicewp' ); ?></label>
									</div>

									<select class="slicewp-select2" name="payout_method" data-has-template-selection="true">

										<option value=""><?php echo __( 'Select payments...', 'slicewp' ); ?></option>

										<?php foreach( $payout_methods as $payout_method_slug => $payout_method ): ?>

											<option value="<?php echo esc_attr( $payout_method_slug ); ?>"><?php echo sprintf( __( '%s payments', 'slicewp' ), $payout_method['label'] ); ?></option>

										<?php endforeach; ?>

									</select>

									<?php
									
										/**
										 * Action to add extra HTML.
										 * 
										 * @param int $payout_id
										 * 
										 */
										do_action( 'slicewp_form_do_bulk_payments_payout_method_bottom', $payout->get( 'id' ) );

									?>

								</div>

								<button class="slicewp-button-primary" disabled>
									<span class="slicewp-button-label slicewp-button-label-manual"><?php echo __( 'Mark as Paid', 'slicewp' ); ?></span>
									<span class="slicewp-button-label slicewp-button-label-other"><?php echo __( 'Pay Affiliates', 'slicewp' ); ?></span>
								</button>

								<input type="hidden" name="payout_id" value="<?php echo absint( $payout->get('id') ); ?>" />
								<input type="hidden" name="slicewp_action" value="do_bulk_payments" />
								<?php wp_nonce_field( 'slicewp_do_bulk_payments', 'slicewp_token', false ); ?>

							</div>

						<?php endif; ?>

					</div>

				</form>
			
			<?php endif; ?>
			<!-- / Payout Progress -->

			<div class="slicewp-card slicewp-has-list-table">

				<div class="slicewp-card-header">

					<span class="slicewp-card-title"><?php echo __( 'Payments', 'slicewp' ); ?></span>

					<div class="slicewp-card-actions">
						<a href="<?php echo wp_nonce_url( add_query_arg( array( 'slicewp_action' => 'generate_payouts_csv', 'payout_id' => absint( $payout->get( 'id' ) ) ), slicewp_get_filtered_admin_url() ), 'slicewp_generate_payouts_csv', 'slicewp_token' ); ?>" class="slicewp-button-secondary"><?php echo __( 'Generate CSV', 'slicewp' ); ?></a>
					</div>

				</div>

				<div class="slicewp-card-inner">
					<form method="GET">

						<!-- Payouts List Table -->
						<?php
							$table = new SliceWP_WP_List_Table_Payout_Payments();
							$table->views();
							$table->display();
						?>

						<!-- Hidden fields needed for the search query -->
						<input type="hidden" name="page" value="slicewp-payouts">

					</form>
				</div>
			</div>

		</div><!-- / Primary Content -->

		<!-- Sidebar Content -->
		<div id="slicewp-secondary">

			<?php 

				/**
				 * Hook to add extra cards if needed in the sidebar
				 *
				 */
				do_action( 'slicewp_view_payouts_view_payout_secondary' );

			?>

		</div><!-- / Sidebar Content -->

	</div>

</div>