<?php
/*
 * Widget Name: Advanced Pricing With Toggle
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Advanced_Pricing_With_Toggle_i09ulu24
 */
class Wdkit_Advanced_Pricing_With_Toggle_i09ulu24 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-i09ulu24';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Advanced Pricing With Toggle', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-menu-toggle';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Yearly and Lifetime Options','Pricing Strategy','Subscription Control','Flexible Pricing','Yearly Pricing','Lifetime Subscription');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_wq46ay25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Advanced-Pricing-With-Toggle_i09ulu24/Advanced_Pricing_With_Toggle_i09ulu24.js', array(), '1.2.17.551861', true );

        return [ 'wkit_child_script_wq46ay25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_ycuv3g25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Advanced-Pricing-With-Toggle_i09ulu24/Advanced_Pricing_With_Toggle_i09ulu24.css', false, '1.2.17.13192', 'all' );

        return [ 'wkit_css_1_ycuv3g25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Plan Switcher 1_tab_content',
            [
                'label' => esc_html__( 'Plan Switcher 1', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_uhkivr24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Monthly', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925 = new \Elementor\Repeater();

                $repeater_x1lbx925->add_control('text_trexaf24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Starter', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('text_p52ygo24',
                array(
            
            'label' => esc_html__( 'Subtitle', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '1 Website', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('text_opwcns24',
                array(
            
            'label' => esc_html__( 'Price Sign', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '$', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('text_2zs01624',
                array(
            
            'label' => esc_html__( 'Pricing Number', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '39', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('text_1m8wpv24',
                array(
            
            'label' => esc_html__( 'Price Month', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '/Month', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('switcher_om7hu524',
                array(
            
            'label' => esc_html__( 'Discount', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            'separator' => 'before',
            
            
        )
            );
$repeater_x1lbx925->add_control('text_vawr5x24',
                array(
            
            'label' => esc_html__( 'Discount Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Discounted From', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_om7hu524', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_x1lbx925->add_control('text_bgf3z624',
                array(
            
            'label' => esc_html__( 'Discount Pricing', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '$49', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_om7hu524', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_x1lbx925->add_control('switcher_5agrzs24',
                array(
            
            'label' => esc_html__( 'Banner', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            'separator' => 'before',
            
            
        )
            );
$repeater_x1lbx925->add_control('text_istnij24',
                array(
            
            'label' => esc_html__( 'Banner Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Banner', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_5agrzs24', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_x1lbx925->add_control('switcher_dikng724',
                array(
            
            'label' => esc_html__( 'Discount Badge ', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            'separator' => 'before',
            
            
        )
            );
$repeater_x1lbx925->add_control('text_rsamjf24',
                array(
            
            'label' => esc_html__( 'Offer Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Most Popular', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_dikng724', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_x1lbx925->add_control('text_i5rb0924',
                array(
            
            'label' => esc_html__( 'Button Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Buy Now', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            'separator' => 'before',
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('text_43o9i224',
                array(
            
            'label' => esc_html__( 'Button Description', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '60 Days Money Back Gaurantee', 'wdesignkit' ),
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('url_0z8apw24',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_x1lbx925->add_control('heading_l0825r24',
                array(
            
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_x1lbx925->add_control('color_5n5wj824',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .pricing-switch-main-inner .content-title,{{WRAPPER}} {{CURRENT_ITEM}} .content-Subtitle,{{WRAPPER}} {{CURRENT_ITEM}} .pricing-number,{{WRAPPER}} {{CURRENT_ITEM}} .pricing-month,{{WRAPPER}} {{CURRENT_ITEM}} .pricing-dollar' => 'color: {{VALUE}}',),
        )
            );
$repeater_x1lbx925->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_978by124',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .pricing-switch-main-inner',
        )
            );
$repeater_x1lbx925->add_control('heading_8mrb6f24',
                array(
            
            'label' => esc_html__( 'Button', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$repeater_x1lbx925->add_control('color_hfu9iw24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .content-button-link-title, {{CURRENT_ITEM}} .content-button-link-desc' => 'color: {{VALUE}}',),
        )
            );
$repeater_x1lbx925->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_fvoosg24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .content-button-link',
        )
            );
$repeater_x1lbx925->add_control('heading_58lij824',
                array(
            
            'label' => esc_html__( 'Bottom Line', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_x1lbx925->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_xiomag24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .pricing-switch-main-inner .middle-content-data-line',
        )
            );

                
                $this->add_control('repeater_sovbkg24',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Plans', 'wdesignkit' ),
                
                
                
                
                
				'fields' => $repeater_x1lbx925->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-611atc25'),
'text_trexaf24' => esc_html__('Starter', 'wdesignkit'), 
'text_p52ygo24' => esc_html__('1 Website', 'wdesignkit'), 
'text_opwcns24' => esc_html__('$', 'wdesignkit'), 
'text_2zs01624' => esc_html__('39', 'wdesignkit'), 
'text_1m8wpv24' => esc_html__('/Month', 'wdesignkit'), 
'switcher_om7hu524' => false,
'text_vawr5x24' => esc_html__('Discounted From', 'wdesignkit'), 
'text_bgf3z624' => esc_html__('$49', 'wdesignkit'), 
'switcher_5agrzs24' => false,
'text_istnij24' => esc_html__('Banner', 'wdesignkit'), 
'switcher_dikng724' => false,
'text_rsamjf24' => esc_html__('Most Popular', 'wdesignkit'), 
'text_i5rb0924' => esc_html__('Buy Now', 'wdesignkit'), 
'text_43o9i224' => esc_html__('60 Days Money Back Gaurantee', 'wdesignkit'), 
'url_0z8apw24' => '#', 
'heading_l0825r24' => esc_html__('', 'wdesignkit'), 
'color_5n5wj824' => '', 
'background_978by124' => '', 
'heading_8mrb6f24' => esc_html__('', 'wdesignkit'), 
'color_hfu9iw24' => '', 
'background_fvoosg24' => '', 
'heading_58lij824' => esc_html__('', 'wdesignkit'), 
'border_xiomag24' => '', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Plan Switcher 2_tab_content',
            [
                'label' => esc_html__( 'Plan Switcher 2', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_0l6jcy24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Lifetime', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25 = new \Elementor\Repeater();

                $repeater_tp8xkc25->add_control('text_7s0mff24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Starter', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('text_4icb1c24',
                array(
            
            'label' => esc_html__( 'Subtitle', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '1 Website', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('text_n5amcd24',
                array(
            
            'label' => esc_html__( 'Price Sign', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '$', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('text_srx0ln24',
                array(
            
            'label' => esc_html__( 'Pricing Number', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '59', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('text_4ystyg24',
                array(
            
            'label' => esc_html__( 'Pricing Month', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '/Month', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('switcher_anmlim24',
                array(
            
            'label' => esc_html__( 'Discount', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            'separator' => 'before',
            
            
        )
            );
$repeater_tp8xkc25->add_control('text_h37mzm24',
                array(
            
            'label' => esc_html__( 'Discount Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'discounted from', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_anmlim24', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_tp8xkc25->add_control('text_msytnd24',
                array(
            
            'label' => esc_html__( 'Discount Pricing', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '$69', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_anmlim24', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_tp8xkc25->add_control('switcher_n0mm5124',
                array(
            
            'label' => esc_html__( 'Banner', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            'separator' => 'before',
            
            
        )
            );
$repeater_tp8xkc25->add_control('text_1ifvhp24',
                array(
            
            'label' => esc_html__( 'Banner Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Banner', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_n0mm5124', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_tp8xkc25->add_control('switcher_y5uldx24',
                array(
            
            'label' => esc_html__( 'Discount Badge ', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            'separator' => 'before',
            
            
        )
            );
$repeater_tp8xkc25->add_control('text_l0thhi24',
                array(
            
            'label' => esc_html__( 'Offer Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Most Bought', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_y5uldx24', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_tp8xkc25->add_control('text_me3ac824',
                array(
            
            'label' => esc_html__( 'Button Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Buy Now', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            'separator' => 'before',
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('text_itimag24',
                array(
            
            'label' => esc_html__( 'Button Description', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '60 Days Money Back Gaurantee', 'wdesignkit' ),
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('url_lxkr4c24',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_tp8xkc25->add_control('heading_0z16ez24',
                array(
            
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_tp8xkc25->add_control('color_ldum6y24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .pricing-switch-main-inner .content-title,{{WRAPPER}} {{CURRENT_ITEM}} .content-Subtitle,{{WRAPPER}} {{CURRENT_ITEM}} .pricing-number,{{WRAPPER}} {{CURRENT_ITEM}} .pricing-month,{{WRAPPER}} {{CURRENT_ITEM}} .pricing-dollar' => 'color: {{VALUE}}',),
        )
            );
$repeater_tp8xkc25->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_tdk7kz24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .pricing-switch-main-inner',
        )
            );
$repeater_tp8xkc25->add_control('heading_4dyrj924',
                array(
            
            'label' => esc_html__( 'Button', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$repeater_tp8xkc25->add_control('color_cwqu6b24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .content-button-link-title, {{CURRENT_ITEM}} .content-button-link-desc' => 'color: {{VALUE}}',),
        )
            );
$repeater_tp8xkc25->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_xbowih24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .content-button-link',
        )
            );
$repeater_tp8xkc25->add_control('heading_w8gbcs24',
                array(
            
            'label' => esc_html__( 'Bottom Line', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_tp8xkc25->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_nhhj6v24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .pricing-switch-main-inner .middle-content-data-line',
        )
            );

                
                $this->add_control('repeater_niow9s24',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Plans', 'wdesignkit' ),
                
                
                
                
                
				'fields' => $repeater_tp8xkc25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-ewtxtf25'),
'text_7s0mff24' => esc_html__('Starter', 'wdesignkit'), 
'text_4icb1c24' => esc_html__('1 Website', 'wdesignkit'), 
'text_n5amcd24' => esc_html__('$', 'wdesignkit'), 
'text_srx0ln24' => esc_html__('59', 'wdesignkit'), 
'text_4ystyg24' => esc_html__('/Month', 'wdesignkit'), 
'switcher_anmlim24' => false,
'text_h37mzm24' => esc_html__('discounted from', 'wdesignkit'), 
'text_msytnd24' => esc_html__('$69', 'wdesignkit'), 
'switcher_n0mm5124' => false,
'text_1ifvhp24' => esc_html__('Banner', 'wdesignkit'), 
'switcher_y5uldx24' => false,
'text_l0thhi24' => esc_html__('Most Bought', 'wdesignkit'), 
'text_me3ac824' => esc_html__('Buy Now', 'wdesignkit'), 
'text_itimag24' => esc_html__('60 Days Money Back Gaurantee', 'wdesignkit'), 
'url_lxkr4c24' => '#', 
'heading_0z16ez24' => esc_html__('', 'wdesignkit'), 
'color_ldum6y24' => '', 
'background_tdk7kz24' => '', 
'heading_4dyrj924' => esc_html__('', 'wdesignkit'), 
'color_cwqu6b24' => '', 
'background_xbowih24' => '', 
'heading_w8gbcs24' => esc_html__('', 'wdesignkit'), 
'border_nhhj6v24' => '', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Tooltip_tab_content',
            [
                'label' => esc_html__( 'Tooltip', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('switcher_iz9mwv24',
                array(
            
            'label' => esc_html__( 'Tooltip', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('text_h705gm24',
                array(
            
            'label' => esc_html__( 'Tooltip Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Pay Once', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_iz9mwv24', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Connection_tab_content',
            [
                'label' => esc_html__( 'Connection', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_aldyay24',
                array(
            
            'label' => esc_html__( 'Connection ID', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('rawhtml_to176u25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Please enter the Connection ID for the Toggle Pricing Features Table.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('switcher_0hc59c24',
                array(
            
            'label' => esc_html__( 'Extra Shape', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_9cgicw24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_0hc59c24', 'operator' => '==', 'value' => 'yes'),
],
                ),
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner:before,  {{WRAPPER}} .pricing-switch-main-inner:after',
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_2kxiy725',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/advanced-pricing-with-toggle/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Background_style_secdddtion',
            [
                'label' => esc_html__( 'Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_g8ri1z24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-main-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->start_controls_tabs('normalhover_9gxa6524',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_9gxa6524_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_2m4g8h24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_9xqeby24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner',
        )
            );
$this->add_responsive_control('dimension_lyyaug24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-main-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_4uuphf24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_9gxa6524_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_0f20po24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_nx2fdt24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_gqwmr424',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-main-inner:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_265euy25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Plan Switches_style_secdddtion',
            [
                'label' => esc_html__( 'Plan Switches', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_oe5swy24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_ox1lcw24',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner .pricing-switch1-btn, {{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner .pricing-switch2-btn',
			)
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_ue4fa824',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_oh4lvx24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner',
        )
            );
$this->add_responsive_control('dimension_w1l7bn24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_la0ih424',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-advance-pricing-top .wkit-advance-pricing-inner', 
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Plan Switch Buttons_style_secdddtion',
            [
                'label' => esc_html__( 'Plan Switch Buttons', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->start_controls_tabs('normalhover_qaeh2e24',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_qaeh2e24_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_kvxt5s24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-button' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_skahhw24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_3zejfd24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button',
        )
            );
$this->add_responsive_control('dimension_wpszl924',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_x6xyta24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qaeh2e24_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_z015zn24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-button:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_qz91st24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button:hover',
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qaeh2e24_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_uxop1s24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-button.active' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_1ua1z624',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button.active',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_u88b0b24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button.active',
        )
            );
$this->add_responsive_control('dimension_m3ljiu24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-button.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_g3dhy124',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button.active', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Tooltip_style_secdddtion',
            [
                'label' => esc_html__( 'Tooltip', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'switcher_iz9mwv24', 'operator' => '==', 'value' => 'yes'],
],
                ),
            ]
        );
$this->add_responsive_control('dimension_mfv3vu24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-button-tooltip' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_aic8m924',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-button-tooltip',
			)
            );
$this->add_control('color_mtevdy24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-button-tooltip' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_4nnnzn24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button-tooltip',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_2c46en24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button-tooltip',
        )
            );
$this->add_responsive_control('dimension_m6x57j24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-button-tooltip' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_foprq224',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button-tooltip', 
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Tooltip Shape_style_secdddtion',
            [
                'label' => esc_html__( 'Tooltip Shape', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'switcher_iz9mwv24', 'operator' => '==', 'value' => 'yes'],
],
                ),
            ]
        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_ahw6e024',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-button-tooltip:before',
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Banner_style_secdddtion',
            [
                'label' => esc_html__( 'Banner', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_8s8ne524',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('dimension_wd84fa24',
                array(
            
            'label' => esc_html__( 'Margin', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_control('slider_360so124',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_2v7u8224',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner',
			)
            );
$this->add_control('color_9a3cgz24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_pd74wz24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_tjjfif24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner',
        )
            );
$this->add_responsive_control('dimension_ykm94p24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_1afhrr24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .pricing-switch-banner .pricing-switch-banner-inner', 
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Title_style_secdddtion',
            [
                'label' => esc_html__( 'Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_j4d1s524',
                
                
                
                'selector' => '{{WRAPPER}} .content-title',
			)
            );
$this->add_control('color_jt78lo24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .content-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_4w9e3l25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Subtitle_style_secdddtion',
            [
                'label' => esc_html__( 'Subtitle', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_n8ltfd24',
                
                
                
                'selector' => '{{WRAPPER}} .content-Subtitle',
			)
            );
$this->add_control('color_b9j09l24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .content-Subtitle' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_ajhr7y25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Pricing Number_style_secdddtion',
            [
                'label' => esc_html__( 'Pricing Number', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_o5ompr24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-number',
			)
            );
$this->add_control('color_1mk1dq24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-number' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_2ej3x925',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Pricing Sign_style_secdddtion',
            [
                'label' => esc_html__( 'Pricing Sign', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_i5uexh24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-dollar',
			)
            );
$this->add_control('color_d18k7d24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-dollar' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_42pyl825',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Pricing Month_style_secdddtion',
            [
                'label' => esc_html__( 'Pricing Month', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_xase5w24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-month',
			)
            );
$this->add_control('color_o5144r24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-month' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_s750r025',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Discount Text_style_secdddtion',
            [
                'label' => esc_html__( 'Discount Text', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_2clx5p24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-detail',
			)
            );
$this->add_control('color_iarurf24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-detail' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Discount Pricing_style_secdddtion',
            [
                'label' => esc_html__( 'Discount Pricing', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_z5gvn324',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-discount',
			)
            );
$this->add_control('color_ig083224',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-discount' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Discount Badge _style_secdddtion',
            [
                'label' => esc_html__( 'Discount Badge ', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_6f5qji24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer.display-yes' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('slider_ofm8b424',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 99,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer.display-yes' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_thcpxm24',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer.display-yes' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_0si8f924',
                
                
                
                'selector' => '{{WRAPPER}} .toggle-pricing-offer.display-yes',
			)
            );
$this->add_control('color_46sehj24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer.display-yes' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_m25vew25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-offer.display-yes',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_aowsqx24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-offer.display-yes',
        )
            );
$this->add_responsive_control('dimension_y017p124',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer.display-yes' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Button_style_secdddtion',
            [
                'label' => esc_html__( 'Button', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_htuc7824',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .content-button-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->start_controls_tabs('normalhover_xtn0hr24',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_xtn0hr24_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_av6e8j24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .content-button-link',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_qc2fjp24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .content-button-link',
        )
            );
$this->add_responsive_control('dimension_tb30h924',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .content-button-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_214zr624',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .content-button-link', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_xtn0hr24_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_hl9o3k24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .content-button-link:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_995ekz24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .content-button-link:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_yr4jb524',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .content-button-link:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_i5usb625',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Button Title_style_secdddtion',
            [
                'label' => esc_html__( 'Button Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_5djqlk24',
                
                
                
                'selector' => '{{WRAPPER}} .content-button-link-title',
			)
            );
$this->start_controls_tabs('normalhover_7jm4ox25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_7jm4ox25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_zuub0q25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .content-button-link-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_7jm4ox25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_rsiumn25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .content-button-link:hover .content-button-link-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_x3ivsr25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Button Description_style_secdddtion',
            [
                'label' => esc_html__( 'Button Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_anlbq124',
                
                
                
                'selector' => '{{WRAPPER}} .content-button-link-desc',
			)
            );
$this->start_controls_tabs('normalhover_7pumkc25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_7pumkc25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_flemxu25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .content-button-link-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_7pumkc25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_rdsvun25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .content-button-link:hover .content-button-link-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_x7jli525',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: If the property has already been applied to the main card, then the property from here will not be applied.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $text_uhkivr24 = !empty($settings['text_uhkivr24']) ? $this->wdk_senitize_js($settings['text_uhkivr24']) : '';
$text_0l6jcy24 = !empty($settings['text_0l6jcy24']) ? $this->wdk_senitize_js($settings['text_0l6jcy24']) : '';
$switcher_iz9mwv24 = !empty($settings['switcher_iz9mwv24']) ? $settings['switcher_iz9mwv24'] : '';
$text_h705gm24 = !empty($settings['text_h705gm24']) ? $this->wdk_senitize_js($settings['text_h705gm24']) : '';
$text_aldyay24 = !empty($settings['text_aldyay24']) ? $this->wdk_senitize_js($settings['text_aldyay24']) : '';
$rawhtml_to176u25 = !empty($settings['rawhtml_to176u25']) ? $this->wdk_senitize_js($settings['rawhtml_to176u25']) : '';
$switcher_0hc59c24 = !empty($settings['switcher_0hc59c24']) ? $settings['switcher_0hc59c24'] : '';
$background_9cgicw24 = !empty($settings['background_9cgicw24']) ? $settings['background_9cgicw24'] : '';
$rawhtml_2kxiy725 = !empty($settings['rawhtml_2kxiy725']) ? $this->wdk_senitize_js($settings['rawhtml_2kxiy725']) : '';

        $repeater_sovbkg24_p725 = '';
                            if ( $settings['repeater_sovbkg24'] ) {
                                foreach ( $settings['repeater_sovbkg24'] as $key => $r_item ) {
                                    $url_0z8apw24_is_external = !empty($r_item['url_0z8apw24']) && !empty($r_item['url_0z8apw24']['is_external']) ? '_blank' : '';
$url_0z8apw24_url = !empty($r_item['url_0z8apw24']) && !empty($r_item['url_0z8apw24']['url'])? $this->wdk_senitize_js($r_item['url_0z8apw24']['url']) : '';
$url_0z8apw24_nofollow = !empty($r_item['url_0z8apw24']) && !empty($r_item['url_0z8apw24']['nofollow'])? 'nofollow' : '';

                                    $repeater_sovbkg24_p725 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' pricing-switch-main" data-repeater_sovbkg24="{repeater_sovbkg24}">
                <div class="pricing-switch-main-inner show-'.$switcher_0hc59c24.'">
                   <div class="pricing-switch-banner show-' . $r_item['switcher_5agrzs24'] . '">                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
                         <div class="pricing-switch-banner-inner">' . $this->wdk_senitize_js($r_item['text_istnij24']) . '</div>
                   </div>
                   <div class="top-content-data">
                      <div class="top-content-data-inner">   
                        <div class="content-title">' . $this->wdk_senitize_js($r_item['text_trexaf24']) . '</div>
                        <div class="content-Subtitle">' . $this->wdk_senitize_js($r_item['text_p52ygo24']) . '</div>
                      </div>
                      <div class="toggle-pricing-offer display-' . $r_item['switcher_dikng724'] . '">' . $this->wdk_senitize_js($r_item['text_rsamjf24']) . '</div>
                   </div> 
                   <div class="middle-content-data">
                       <div class="middle-content-left">
                            <span class="pricing-dollar">' . $this->wdk_senitize_js($r_item['text_opwcns24']) . '</span>
                            <span class="pricing-number">' . $this->wdk_senitize_js($r_item['text_2zs01624']) . '</span>
                            <span class="pricing-month">' . $this->wdk_senitize_js($r_item['text_1m8wpv24']) . '</span>
                        </div>
                        <div class="middle-content-right display-' . $r_item['switcher_om7hu524'] . '">
                            <div class="pricing-detail">' . $this->wdk_senitize_js($r_item['text_vawr5x24']) . '</div>
                            <div class="pricing-discount">' . $this->wdk_senitize_js($r_item['text_bgf3z624']) . '</div>
                        </div>
                   </div>
                   <div class="middle-content-data-line"></div>
                   <div class="end-content-data">
                        <a href="'.$url_0z8apw24_url.'" target="'.$url_0z8apw24_is_external.'" rel="'.$url_0z8apw24_nofollow.'" class="content-button-link">
                            <span class="content-button-link-title">' . $this->wdk_senitize_js($r_item['text_i5rb0924']) . '</span>
                            <span class="content-button-link-desc">' . $this->wdk_senitize_js($r_item['text_43o9i224']) . '</span>
                        </a>
                   </div>
                </div>
          </div>';
                                }
                            }$repeater_niow9s24_3425 = '';
                            if ( $settings['repeater_niow9s24'] ) {
                                foreach ( $settings['repeater_niow9s24'] as $key => $r_item ) {
                                    $url_lxkr4c24_is_external = !empty($r_item['url_lxkr4c24']) && !empty($r_item['url_lxkr4c24']['is_external']) ? '_blank' : '';
$url_lxkr4c24_url = !empty($r_item['url_lxkr4c24']) && !empty($r_item['url_lxkr4c24']['url'])? $this->wdk_senitize_js($r_item['url_lxkr4c24']['url']) : '';
$url_lxkr4c24_nofollow = !empty($r_item['url_lxkr4c24']) && !empty($r_item['url_lxkr4c24']['nofollow'])? 'nofollow' : '';

                                    $repeater_niow9s24_3425 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' pricing-switch-main" data-repeater_niow9s24="{repeater_niow9s24}">
                <div class="pricing-switch-main-inner show-'.$switcher_0hc59c24.'">
                        <div class="pricing-switch-banner show-' . $r_item['switcher_n0mm5124'] . '">                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
                             <div class="pricing-switch-banner-inner">' . $this->wdk_senitize_js($r_item['text_1ifvhp24']) . '</div>
                        </div>
                       <div class="top-content-data">   
                          <div class="top-content-data-inner">   
                            <div class="content-title">' . $this->wdk_senitize_js($r_item['text_7s0mff24']) . '</div>
                            <div class="content-Subtitle">' . $this->wdk_senitize_js($r_item['text_4icb1c24']) . '</div>
                          </div>
                          <div class="toggle-pricing-offer display-' . $r_item['switcher_y5uldx24'] . '">' . $this->wdk_senitize_js($r_item['text_l0thhi24']) . '</div>
                       </div> 
                       <div class="middle-content-data">
                           <div class="middle-content-left">
                                <span class="pricing-dollar">' . $this->wdk_senitize_js($r_item['text_n5amcd24']) . '</span>
                                <span class="pricing-number">' . $this->wdk_senitize_js($r_item['text_srx0ln24']) . '</span>
                                <span class="pricing-month">' . $this->wdk_senitize_js($r_item['text_4ystyg24']) . '</span>
                            </div>
                            <div class="middle-content-right display-' . $r_item['switcher_anmlim24'] . '">
                                <div class="pricing-detail">' . $this->wdk_senitize_js($r_item['text_h37mzm24']) . '</div>
                                <div class="pricing-discount">' . $this->wdk_senitize_js($r_item['text_msytnd24']) . '</div>
                            </div>
                       </div>
                        <div class="middle-content-data-line"></div>
                       <div class="end-content-data">
                            <a href="'.$url_lxkr4c24_url.'" target="'.$url_lxkr4c24_is_external.'" rel="'.$url_lxkr4c24_nofollow.'" class="content-button-link">
                                <span class="content-button-link-title">' . $this->wdk_senitize_js($r_item['text_me3ac824']) . '</span>
                                <span class="content-button-link-desc">' . $this->wdk_senitize_js($r_item['text_itimag24']) . '</span>
                            </a>
                       </div>
                   </div>
             </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_i09ulu24" data-wdkitunique="i09ulu24">';
            $output .= '<div class="wkit-advanced-pricing-with-toggle advanced-'.$text_aldyay24.'" data-connection-id="'.$text_aldyay24.'">
    <div class="wkit-advance-pricing-top">
        <div class="wkit-advance-pricing-inner">
            <button class="wkit-button pricing-switch1-btn">'.$text_uhkivr24.'</button>
            <button class="wkit-button pricing-switch2-btn">'.$text_0l6jcy24.'</button>
            <span class="wkit-button-tooltip tooltip-'.$switcher_iz9mwv24.'">
                <span class="button-tooltip-text">'.$text_h705gm24.'</span>
            </span>
        </div>
    </div>
     <div class="wkit-pricing-content wkit-pricing-switch1">
          '.$repeater_sovbkg24_p725.'
     </div>
     <div class="wkit-pricing-content wkit-pricing-switch2">
            '.$repeater_niow9s24_3425.'
      </div></div>';
        $output .= '</div>';
        
        echo $output;
    }
}