<?php
/*
 * Widget Name: CTA with Connected Background
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_CTA_with_Connected_Background_265ax123
 */
class Wdkit_CTA_with_Connected_Background_265ax123 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-265ax123';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('CTA with Connected Background', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-background';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('CTA','Background','Hover Animation','Image Animation');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_etm12c25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/CTA-with-Connected-Background_265ax123/CTA_with_Connected_Background_265ax123.js', array(), '1.2.17.737915', true );

        return [ 'wkit_child_script_etm12c25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_3y7y4a25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/CTA-with-Connected-Background_265ax123/CTA_with_Connected_Background_265ax123.css', false, '1.2.17.776259', 'all' );

        return [ 'wkit_css_1_3y7y4a25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_j13meb23',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'horizontal',
            
            'options' => array( 'horizontal'  => esc_html__( 'Style 1', 'wdesignkit' ),'vertical'  => esc_html__( 'Style 2', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_07xjjk25 = new \Elementor\Repeater();

                $repeater_07xjjk25->add_control('text_bqwp3l23',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Join Our Community', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_07xjjk25->add_control('textarea_o2vj9h23',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            'label' => esc_html__( 'Description', 'wdesignkit' ),
            
            
            'label_block' => true,
            
            'rows' => '5',
            
            'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod tempor labore.', 'wdesignkit' ),
            
            
            
        )
            );
$repeater_07xjjk25->add_control('text_memb1g23',
                array(
            
            'label' => esc_html__( 'Button Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Read More', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_07xjjk25->add_control('iconscontrol_xzwn0y25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-arrow-right',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_07xjjk25->add_control('url_3hvh9k23',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_07xjjk25->add_control('media_uy9yec23',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ),
            
            'label_block' => true,
            
            'media_types' => array(),
           'dynamic' => array(
                'active' => true,
            ),
            
            
        )
            );

                
                $this->add_control('repeater_lcaihe23',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Slides', 'wdesignkit' ),
                
                
                
                
                
				'fields' => $repeater_07xjjk25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-024z5725'),
'text_bqwp3l23' => esc_html__('Join Our Community', 'wdesignkit'), 
'textarea_o2vj9h23' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod tempor labore.', 'wdesignkit'), 
'text_memb1g23' => esc_html__('Read More', 'wdesignkit'), 
'iconscontrol_xzwn0y25' => 'fas fa-arrow-right', 
'url_3hvh9k23' => '#', 
'media_uy9yec23' => '', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_responsive_control('choose_ahous925',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .con-image-item .con-item-content' => 'text-align: {{VALUE}}',),
        )
            );
$this->add_control('switcher_xuuqzy23',
                array(
            
            'label' => esc_html__( 'Vertical on Mobile', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_j13meb23', 'operator' => '==', 'value' => 'horizontal'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_37cwbw25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/cta-with-connected-background/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Title_style_secdddtion',
            [
                'label' => esc_html__( 'Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_x47myl23',
                array(
            
            'label' => esc_html__( 'Offset', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .con-image-item .con-item-content' => '--titleoffset: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_htjkbt23',
                
                
                
                'selector' => '{{WRAPPER}} .con-item-content .con-i-title',
			)
            );
$this->add_control('color_wzqdjg23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Description_style_secdddtion',
            [
                'label' => esc_html__( 'Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_b78ag323',
                array(
            
            'label' => esc_html__( 'Top Space', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-desc' => 'margin-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_sgeyni23',
                array(
            
            'label' => esc_html__( 'Bottom Space', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_2ukchn23',
                
                
                
                'selector' => '{{WRAPPER}} .con-item-content .con-i-desc',
			)
            );
$this->add_control('color_eb55o323',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Button_style_secdddtion',
            [
                'label' => esc_html__( 'Button', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_xgiapc23',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','em','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_nrxkq123',
                
                
                
                'selector' => '{{WRAPPER}} .con-item-content .con-i-btn',
			)
            );
$this->add_control('color_gu26ox23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn' => 'color: {{VALUE}}',),
        )
            );
$this->start_controls_tabs('normalhover_qaaugl23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_qaaugl23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_s96nkm23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .con-item-content .con-i-btn',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_imnep823',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .con-item-content .con-i-btn',
        )
            );
$this->add_responsive_control('dimension_s6ajgn23',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_h63ojg23',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .con-item-content .con-i-btn', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qaaugl23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_yfdhom23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .con-item-content .con-i-btn:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_1cjwo623',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .con-item-content .con-i-btn:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_y1gqz223',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .con-item-content .con-i-btn:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Button Icon_style_secdddtion',
            [
                'label' => esc_html__( 'Button Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_j0xrpe25',
                array(
            
            'label' => esc_html__( 'Icon Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_qz6fb825',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn .tp-title-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_no8fem25',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_am0jl025',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_am0jl025_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_14r2li25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_v6fs8225',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_am0jl025_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_nudwmh25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn:hover .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_hfafqm25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-item-content .con-i-btn:hover .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Slides_style_secdddtion',
            [
                'label' => esc_html__( 'Slides', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_mczafc23',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .cta-with-bg-inner .con-image-item' => '--bgheight: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_rc7mqv23',
                array(
            
            'label' => esc_html__( 'Overlay Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .con-image-item' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_control('heading_3mo6nr25',
                array(
            
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_responsive_control('slider_mqqn4p23',
                array(
            
            'label' => esc_html__( 'Border Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .cta-with-bg-inner .con-image-item:not(:last-child)' => '--bdwidth: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_d1zd0g23',
                array(
            
            'label' => esc_html__( 'Border Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .cta-with-bg-inner .con-image-item:not(:last-child)' => '--bdcolor: {{VALUE}}',),
        )
            );
$this->add_responsive_control('dimension_0xtgn424',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .cta-with-bg-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
			\Elementor\Group_Control_Css_Filter::get_type(),
			array(
				'name' => 'cssfilter_anjuwm23',
                
                
				'selector' => '{{WRAPPER}} .con-image-background',
			)
            );
$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_j13meb23 = !empty($settings['select_j13meb23']) ? $this->wdk_senitize_js($settings['select_j13meb23']) : '';
$choose_ahous925 = !empty($settings['choose_ahous925']) ? $this->wdk_senitize_js($settings['choose_ahous925']) : '';
$switcher_xuuqzy23 = !empty($settings['switcher_xuuqzy23']) ? $settings['switcher_xuuqzy23'] : '';
$rawhtml_37cwbw25 = !empty($settings['rawhtml_37cwbw25']) ? $this->wdk_senitize_js($settings['rawhtml_37cwbw25']) : '';

        $repeater_lcaihe23_nh25 = '';
                            if ( $settings['repeater_lcaihe23'] ) {
                                foreach ( $settings['repeater_lcaihe23'] as $key => $r_item ) {
                                    $iconscontrol_xzwn0y25 = "";
                        if(!empty($r_item['iconscontrol_xzwn0y25']) && !empty($r_item['iconscontrol_xzwn0y25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_xzwn0y25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_xzwn0y25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_3hvh9k23_is_external = !empty($r_item['url_3hvh9k23']) && !empty($r_item['url_3hvh9k23']['is_external']) ? '_blank' : '';
$url_3hvh9k23_url = !empty($r_item['url_3hvh9k23']) && !empty($r_item['url_3hvh9k23']['url'])? $this->wdk_senitize_js($r_item['url_3hvh9k23']['url']) : '';
$url_3hvh9k23_nofollow = !empty($r_item['url_3hvh9k23']) && !empty($r_item['url_3hvh9k23']['nofollow'])? 'nofollow' : '';
$media_uy9yec23 = !empty($r_item['media_uy9yec23']['url']) ? $this->wdk_senitize_js($r_item['media_uy9yec23']['url']) : '';

                                    $repeater_lcaihe23_nh25 .= '<img class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' bg-image" data-repeater_lcaihe23="{repeater_lcaihe23}" src="'.$media_uy9yec23.'" data-index="'.$key.'">';
                                }
                            }$repeater_lcaihe23_3n25 = '';
                            if ( $settings['repeater_lcaihe23'] ) {
                                foreach ( $settings['repeater_lcaihe23'] as $key => $r_item ) {
                                    $iconscontrol_xzwn0y25 = "";
                        if(!empty($r_item['iconscontrol_xzwn0y25']) && !empty($r_item['iconscontrol_xzwn0y25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_xzwn0y25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_xzwn0y25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_3hvh9k23_is_external = !empty($r_item['url_3hvh9k23']) && !empty($r_item['url_3hvh9k23']['is_external']) ? '_blank' : '';
$url_3hvh9k23_url = !empty($r_item['url_3hvh9k23']) && !empty($r_item['url_3hvh9k23']['url'])? $this->wdk_senitize_js($r_item['url_3hvh9k23']['url']) : '';
$url_3hvh9k23_nofollow = !empty($r_item['url_3hvh9k23']) && !empty($r_item['url_3hvh9k23']['nofollow'])? 'nofollow' : '';
$media_uy9yec23 = !empty($r_item['media_uy9yec23']['url']) ? $this->wdk_senitize_js($r_item['media_uy9yec23']['url']) : '';

                                    $repeater_lcaihe23_3n25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' con-image-item" data-repeater_lcaihe23="{repeater_lcaihe23}" data-index="'.$key.'">
            <div class="con-item-content">
                <span class="con-i-title" data-title="' . $this->wdk_senitize_js($r_item['text_bqwp3l23']) . '">' . $this->wdk_senitize_js($r_item['text_bqwp3l23']) . '</span>
                <p class="con-i-desc" data-desc="' . $this->wdk_senitize_js($r_item['textarea_o2vj9h23']) . '">' . $this->wdk_senitize_js($r_item['textarea_o2vj9h23']) . '</p>
                <a class="con-i-btn" href="'.$url_3hvh9k23_url.'" data-btext="' . $this->wdk_senitize_js($r_item['text_memb1g23']) . '" target="'.$url_3hvh9k23_is_external.'" rel="'.$url_3hvh9k23_nofollow.'">' . $this->wdk_senitize_js($r_item['text_memb1g23']) . ''.$iconscontrol_xzwn0y25.'</a>
            </div>
        </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_265ax123" data-wdkitunique="265ax123">';
            $output .= '<div class="wkit-cta-with-con-bg">
    <div class="cta-with-bg-inner layout-con-'.$select_j13meb23.' vertical-on-mobile-'.$switcher_xuuqzy23.'">
        <div class="con-image-background">
            '.$repeater_lcaihe23_nh25.'
                
            
        </div>
        '.$repeater_lcaihe23_3n25.'
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}