(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let ajaxSeach = $scope[0].querySelector('.wkit-inline-ajax-search');
let getCid = ajaxSeach.getAttribute('data-cid');
let targetc = ajaxSeach.getAttribute('data-target');
let result = ajaxSeach.getAttribute('data-result');

let getInput = ajaxSeach.querySelector('input');
let getBtn = ajaxSeach.querySelector('.ajax-search-btn');

if(getCid && targetc){
    let getContainer = document.querySelector('#'+getCid);
    if(getContainer){
        
        let splitTarget = targetc.split(" ");
        splitTarget.forEach((tar)=>{
            if(tar){
                let targetClass = getContainer.querySelectorAll('.'+tar);
                if(targetClass){
                    
                    if(result=='button' && getBtn){
                        getBtn.addEventListener('click', (e) => {
                            let searchTerm = getInput.value.toLowerCase();
                            resultFun(searchTerm, targetClass)
                        }); 
                        getInput.addEventListener('keypress', (e) => {
                            if(e.keyCode == 13){
                                let searchTerm = e.currentTarget.value.toLowerCase();
                                resultFun(searchTerm, targetClass)
                            }
                        });
                        
                    }else{
                        getInput.addEventListener('input', (e) => {
                            let searchTerm = e.currentTarget.value.toLowerCase();
                            resultFun(searchTerm, targetClass)
                        });    
                    }
                }
            }
        })
    }
}

function resultFun(searchTerm, targetClass){
    targetClass.forEach(word => {
        let wordText = word.innerText.toLowerCase();
        if (wordText.includes(searchTerm)) {
            word.style.filter = '';
            word.style.userSelect = '';
        } else {
            word.style.filter = 'blur(5px)';
            word.style.userSelect = 'none';
        }
    });
}  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-uvsoe924.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);