(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let interactivemain = $scope[0].querySelector(".wkit-interactive-links-wrap");

if (interactivemain) {
    let mainItems = interactivemain.querySelectorAll(".wkit-interactive-list");
    let imagegroup = interactivemain.querySelectorAll(".wkit-interactive-img");

    let defaultItem = mainItems[0];
    let defaultImage = imagegroup[0];

    // Set default active state
    if (defaultItem) {
        defaultItem.classList.add("active");
        if (defaultImage) {
            defaultImage.style.opacity = '1';
        }
    }

    // Handle each item
    mainItems.forEach((item, index) => {
        const image = imagegroup[index];

        // Add mobile class
        if (window.innerWidth <= 767) {
            item.classList.add('wdk-mobile-version');
        }

        // Prevent link click on tablet/mobile if disabled
        const link = item.querySelector('.wkit-interactive-text');
        if (link) {
            link.addEventListener('click', (e) => {
                const isTablet = window.innerWidth >= 768 && window.innerWidth <= 1024;
                const isMobile = window.innerWidth <= 767;

                if (
                    (isMobile && !item.classList.contains('disable-mobile-link')) ||
                    (isTablet && !item.classList.contains('disable-tablet-link'))
                ) {
                    e.preventDefault();
                    e.stopPropagation();
                }
            });
        }

        // Hover in
        item.addEventListener('mouseenter', () => {
            mainItems.forEach((el) => el.classList.remove("active"));
            imagegroup.forEach((img) => {
                img.style.opacity = '0';
                img.style.transition = 'opacity 0.5s';
            });

            item.classList.add("active");
            if (image) {
                image.style.opacity = '1';
            }
        });

        // Hover out
        item.addEventListener('mouseleave', () => {
            if (image) {
                image.style.opacity = '0';
            }

            if (defaultItem) {
                defaultItem.classList.add("active");
            }
            if (defaultImage) {
                defaultImage.style.opacity = '1';
            }
        });
    });

    // Responsive resize check
    window.addEventListener('resize', () => {
        mainItems.forEach((item) => {
            if (window.innerWidth <= 767) {
                item.classList.add('wdk-mobile-version');
            } else {
                item.classList.remove('wdk-mobile-version');
            }
        });
    });
}
  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-tsgip424.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);