<?php
/*
 * Widget Name: Interactive Links
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Interactive_Links_tsgip424
 */
class Wdkit_Interactive_Links_tsgip424 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-tsgip424';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Interactive Links', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-link';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Interactive Links','Link','Interactive','Animated Link','hover effects','dynamic backgrounds','animated links','interactive navigation','WordPress effects','Elementor widget');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_hsnj3w25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Interactive-Links_tsgip424/Interactive_Links_tsgip424.js', array(), '1.2.17.289591', true );

        return [ 'wkit_child_script_hsnj3w25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_qdh1ig25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Interactive-Links_tsgip424/Interactive_Links_tsgip424.css', false, '1.2.17.539059', 'all' );

        return [ 'wkit_css_1_qdh1ig25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_kcl1rt24',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'style-1',
            
            'options' => array( 'style-1'  => esc_html__( 'Style 1', 'wdesignkit' ),'style-2'  => esc_html__( 'Style 2', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_jfccw025 = new \Elementor\Repeater();

                $repeater_jfccw025->add_control('iconscontrol_lkjtqw25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-arrow-right',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_jfccw025->add_control('text_hiu6rd24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Title 1', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_jfccw025->add_control('switcher_1ek47w25',
                array(
            
            'label' => esc_html__( 'Description', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$repeater_jfccw025->add_control('textarea_0kj77u25',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            
            
            'show_label' => false,
            'label_block' => true,
            
            'rows' => '2',
            
            'default' => esc_html__( 'Complete 120+ Elementor widgets & extensions for Elementor page ', 'wdesignkit' ),
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_1ek47w25', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$repeater_jfccw025->add_control('media_7jj7k124',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array(),
           
            
            
        )
            );
$repeater_jfccw025->add_control('url_emunfl24',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => false,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );

                
                $this->add_control('repeater_nbv4ga24',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Links', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_jfccw025->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-ph1ky625'),
'iconscontrol_lkjtqw25' => 'fas fa-arrow-right', 
'text_hiu6rd24' => esc_html__('Title 1', 'wdesignkit'), 
'switcher_1ek47w25' => false,
'textarea_0kj77u25' => esc_html__('Complete 120+ Elementor widgets & extensions for Elementor page ', 'wdesignkit'), 
'media_7jj7k124' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'url_emunfl24' => '#', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('switcher_7fz4ng25',
                array(
            
            'label' => esc_html__( 'Bottom Underline', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('select_kyqth225',
                array(
            
            'label' => esc_html__( 'Icon Position', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'before',
            
            'options' => array( 'before'  => esc_html__( 'Before', 'wdesignkit' ),'after'  => esc_html__( 'After', 'wdesignkit' ), ),
        )
            );
$this->add_responsive_control('choose_fa2zxt24',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            'default' => 'center',
            'toggle' => true,
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kcl1rt24', 'operator' => '==', 'value' => 'style-1'),
array('name' => 'select_kcl1rt24', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list' => 'justify-content: {{VALUE}}',),
        )
            );
$this->add_responsive_control('choose_g6aisy24',
                array(
            
            'label' => esc_html__( 'Direction', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'flex-start' => array(
                        'title' => esc_html__( 'Top', 'wdesignkit' ),
                        'icon' => 'eicon-arrow-up',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'flex-end' => array(
                        'title' => esc_html__( 'Bottom', 'wdesignkit' ),
                        'icon' => 'eicon-arrow-down',
                    ),
                ),
            'default' => 'center',
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-list-left-side' => 'justify-content: {{VALUE}}',),
        )
            );
$this->add_control('switcher_fqtwtk25',
                array(
            
            'label' => esc_html__( 'Tablet Link', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'disable-tablet-link',
            'default' => 'disable-tablet-link',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('switcher_cwpvy525',
                array(
            
            'label' => esc_html__( 'Mobile Link', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'disable-mobile-link',
            'default' => 'disable-mobile-link',
            
            'label_block' => false,
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_t3v9mt25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/interactive-links/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_89gxc324',
                array(
            
            'label' => esc_html__( 'Item Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-list-left-side' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_0drekm25',
                array(
            
            'label' => esc_html__( 'Left Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kcl1rt24', 'operator' => '==', 'value' => 'style-1'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-list-left-side' => 'padding-left: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_p8klpc25',
                array(
            
            'label' => esc_html__( 'Animated border Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            'separator' => 'before',
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kcl1rt24', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap.style-2 .wkit-interactive-list::after' => 'border-color: {{VALUE}}',),
        )
            );
$this->add_responsive_control('slider_lw9l5l25',
                array(
            
            'label' => esc_html__( 'Animated border width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kcl1rt24', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap.style-2 .wkit-interactive-list::after' => 'border-top-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Icon_style_secdddtion',
            [
                'label' => esc_html__( 'Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_4s5ls625',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-links-icon .tp-title-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_9zcmi725',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_9zcmi725_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_sjaa6o25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-links-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_pb99ho25',
                array(
            
            'label' => esc_html__( 'Mobile Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-links-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_9ls2xt25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_9zcmi725_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_awiqic25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list .wkit-interactive-text:hover .wkit-links-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_4w5iec25',
                array(
            
            'label' => esc_html__( 'Mobile Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-interactive-list .wkit-interactive-text:hover .wkit-links-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_eshr7x25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_9zcmi725_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_59cwx125',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.active .wkit-links-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_3kjot925',
                array(
            
            'label' => esc_html__( 'Mobile Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version.active .wkit-links-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_olsad225',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_responsive_control('slider_nqyhtt25',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            'separator' => 'before',
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-links-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_ti9jhk25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_ti9jhk25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_477dsw25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-links-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_uyqu4925',
                array(
            
            'label' => esc_html__( 'Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-links-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->add_control('color_80v28o25',
                array(
            
            'label' => esc_html__( 'Mobile SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-links-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_nkson225',
                array(
            
            'label' => esc_html__( 'Mobile Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-links-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_63c9qb25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_ti9jhk25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_32xyxt25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list .wkit-interactive-text:hover .wkit-links-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_w1mtx025',
                array(
            
            'label' => esc_html__( 'Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list .wkit-interactive-text:hover .wkit-links-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->add_control('color_pn9ma725',
                array(
            
            'label' => esc_html__( 'Mobile SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version .wkit-interactive-text:hover .wkit-links-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_x3nd3l25',
                array(
            
            'label' => esc_html__( 'Mobile Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version .wkit-interactive-text:hover .wkit-links-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_amk11r25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_ti9jhk25_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_b5eplt25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.active .wkit-links-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_aqpugr25',
                array(
            
            'label' => esc_html__( 'Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.active .wkit-links-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->add_control('color_df7ohm25',
                array(
            
            'label' => esc_html__( 'Mobile SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version.active .wkit-links-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_qqpn9525',
                array(
            
            'label' => esc_html__( 'Mobile Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version.active .wkit-links-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_icp3j225',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Title_style_secdddtion',
            [
                'label' => esc_html__( 'Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('choose_cnq6nz25',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'flex-start' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'flex-end' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kcl1rt24', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-list' => 'align-items: {{VALUE}}',),
        )
            );
$this->add_responsive_control('dimension_xzbfs225',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_5jgun924',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-text',
			)
            );
$this->start_controls_tabs('normalhover_qdeg2525',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_qdeg2525_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_5ospuz25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-text .wkit-links-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_fpn7we25',
                array(
            
            'label' => esc_html__( 'Mobile Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-links-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_r5w27825',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_jd5f0s25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-interactive-text',
        )
            );
$this->add_responsive_control('dimension_h3gtkk25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qdeg2525_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_yc429o25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list .wkit-interactive-text:hover .wkit-links-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_diazuo25',
                array(
            
            'label' => esc_html__( 'Mobile Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-links-title:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_v1n80t25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_x6gtcu25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-interactive-text:hover',
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qdeg2525_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_b5d3ss25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.active .wkit-links-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_9k1rrk25',
                array(
            
            'label' => esc_html__( 'Mobile Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version.active .wkit-links-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_zsx4uw25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_7x8dtt25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-interactive-list.active .wkit-interactive-text',
        )
            );
$this->add_responsive_control('dimension_vrzed525',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.active .wkit-interactive-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Description_style_secdddtion',
            [
                'label' => esc_html__( 'Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_h33jx925',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-interactive-desc',
			)
            );
$this->start_controls_tabs('normalhover_jlvao125',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_jlvao125_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_ic00yt25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-desc' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_ndw78525',
                array(
            
            'label' => esc_html__( 'Mobile Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-interactive-desc' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_9nu03z25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_jlvao125_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_prfh7625',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list:hover .wkit-interactive-desc' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_1vhk8i25',
                array(
            
            'label' => esc_html__( 'Mobile Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wdk-mobile-version .wkit-interactive-desc:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_vzv8yj25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_jlvao125_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_xn5qk125',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.active .wkit-interactive-desc' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_fk5czn25',
                array(
            
            'label' => esc_html__( 'Mobile Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-list.wdk-mobile-version.active  .wkit-interactive-desc' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_44d0kr25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: This color setting applies only to mobile devices.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Images_style_secdddtion',
            [
                'label' => esc_html__( 'Images', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_77qohy24',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => '%',
                                    'size' => 100,
                                ),
            'tablet_default' => array(
                                    'unit' => '%',
                                    'size' => 100,
                                ),
                'mobile_default' => array(
                                    'unit' => '%',
                                    'size' => 100,
                                ),
                'widescreen_default' => array(
                                    'unit' => '%',
                                    'size' => 100,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-wrapper .wkit-interactive-img' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_y2gy5r24',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 520,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 520,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 520,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 520,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap,{{WRAPPER}} .wkit-interactive-wrapper .wkit-interactive-img' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('dimension_hbzluj24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-interactive-links-wrap .wkit-interactive-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_kcl1rt24 = !empty($settings['select_kcl1rt24']) ? $this->wdk_senitize_js($settings['select_kcl1rt24']) : '';
$switcher_7fz4ng25 = !empty($settings['switcher_7fz4ng25']) ? $settings['switcher_7fz4ng25'] : '';
$select_kyqth225 = !empty($settings['select_kyqth225']) ? $this->wdk_senitize_js($settings['select_kyqth225']) : '';
$choose_fa2zxt24 = !empty($settings['choose_fa2zxt24']) ? $this->wdk_senitize_js($settings['choose_fa2zxt24']) : '';
$choose_g6aisy24 = !empty($settings['choose_g6aisy24']) ? $this->wdk_senitize_js($settings['choose_g6aisy24']) : '';
$switcher_fqtwtk25 = !empty($settings['switcher_fqtwtk25']) ? $settings['switcher_fqtwtk25'] : '';
$switcher_cwpvy525 = !empty($settings['switcher_cwpvy525']) ? $settings['switcher_cwpvy525'] : '';
$rawhtml_t3v9mt25 = !empty($settings['rawhtml_t3v9mt25']) ? $this->wdk_senitize_js($settings['rawhtml_t3v9mt25']) : '';

        $repeater_nbv4ga24_vj25 = '';
                            if ( $settings['repeater_nbv4ga24'] ) {
                                foreach ( $settings['repeater_nbv4ga24'] as $key => $r_item ) {
                                    $iconscontrol_lkjtqw25 = "";
                        if(!empty($r_item['iconscontrol_lkjtqw25']) && !empty($r_item['iconscontrol_lkjtqw25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_lkjtqw25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_lkjtqw25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$media_7jj7k124 = !empty($r_item['media_7jj7k124']['url']) ? $this->wdk_senitize_js($r_item['media_7jj7k124']['url']) : '';
$url_emunfl24_is_external = !empty($r_item['url_emunfl24']) && !empty($r_item['url_emunfl24']['is_external']) ? '_blank' : '';
$url_emunfl24_url = !empty($r_item['url_emunfl24']) && !empty($r_item['url_emunfl24']['url'])? $this->wdk_senitize_js($r_item['url_emunfl24']['url']) : '';
$url_emunfl24_nofollow = !empty($r_item['url_emunfl24']) && !empty($r_item['url_emunfl24']['nofollow'])? 'nofollow' : '';

                                    $repeater_nbv4ga24_vj25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-interactive-list '.$switcher_7fz4ng25.' '.$switcher_fqtwtk25.' '.$switcher_cwpvy525.'" data-repeater_nbv4ga24="{repeater_nbv4ga24}">
        <a class="wkit-interactive-text '.$select_kyqth225.'" href="'.$url_emunfl24_url.'" target="'.$url_emunfl24_is_external.'" rel="'.$url_emunfl24_nofollow.'"><span class="wkit-links-icon">'.$iconscontrol_lkjtqw25.'</span><span class="wkit-links-title">' . $this->wdk_senitize_js($r_item['text_hiu6rd24']) . '</span></a>
        <p class="wkit-interactive-desc ' . $r_item['switcher_1ek47w25'] . '">' . $this->wdk_senitize_js($r_item['textarea_0kj77u25']) . '</p>
        </div>';
                                }
                            }$repeater_nbv4ga24_ce25 = '';
                            if ( $settings['repeater_nbv4ga24'] ) {
                                foreach ( $settings['repeater_nbv4ga24'] as $key => $r_item ) {
                                    $iconscontrol_lkjtqw25 = "";
                        if(!empty($r_item['iconscontrol_lkjtqw25']) && !empty($r_item['iconscontrol_lkjtqw25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_lkjtqw25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_lkjtqw25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$media_7jj7k124 = !empty($r_item['media_7jj7k124']['url']) ? $this->wdk_senitize_js($r_item['media_7jj7k124']['url']) : '';
$url_emunfl24_is_external = !empty($r_item['url_emunfl24']) && !empty($r_item['url_emunfl24']['is_external']) ? '_blank' : '';
$url_emunfl24_url = !empty($r_item['url_emunfl24']) && !empty($r_item['url_emunfl24']['url'])? $this->wdk_senitize_js($r_item['url_emunfl24']['url']) : '';
$url_emunfl24_nofollow = !empty($r_item['url_emunfl24']) && !empty($r_item['url_emunfl24']['nofollow'])? 'nofollow' : '';

                                    $repeater_nbv4ga24_ce25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-image-wrapper" data-repeater_nbv4ga24="{repeater_nbv4ga24}">
             <div class="wkit-interactive-wrapper">
                <img class="wkit-interactive-img" src="'.$media_7jj7k124.'">
            </div>
        </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_tsgip424" data-wdkitunique="tsgip424">';
            $output .= '<div class="wkit-interactive-links-wrap '.$select_kcl1rt24.'">
        
     <div class="wkit-interactive-list-left-side">
       '.$repeater_nbv4ga24_vj25.'  
    </div>
    
      
     <div class="wkit-interactive-list-right-side">
        '.$repeater_nbv4ga24_ce25.'
    </div>
</div>

 


';
        $output .= '</div>';
        
        echo $output;
    }
}