(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let TeamMain = $scope[0].querySelector(".wkit-team-wrapper");
let SingleTeam = TeamMain.querySelectorAll(".wkit-team-item-inner");
let popup = TeamMain.querySelector(".wkit-team-popup-content");

SingleTeam.forEach((team, index) => {
  let fbicon = team.querySelector(".select-fb-icon");
  let gpicon = team.querySelector(".select-gp-icon");
  let twittericon = team.querySelector(".select-twitter-icon");

  team.addEventListener("click", (e) => {
    let isActive = team.classList.contains("addactive");
    SingleTeam.forEach((el) => el.classList.remove("addactive"));

    document.querySelectorAll(".wkit-team-popup-content").forEach((popup) => {
      popup.style.maxHeight = "0";
      popup.style.opacity = "0";
      setTimeout(() => (popup.style.display = "none"), 300);
    });

    if (isActive) return;
    team.classList.add("addactive");
    let selectedPopup = team.querySelector(".wkit-team-popup-content");
    if (!selectedPopup) {
      console.warn("No popup found inside the clicked team item.");
      return;
    }

    let name = selectedPopup.getAttribute("data-name") || "";
    let desg = selectedPopup.getAttribute("data-degination") || "";
    let details = selectedPopup.getAttribute("data-details") || "";
    let tel = selectedPopup.getAttribute("data-tel") || "";
    let mail = selectedPopup.getAttribute("data-mail") || "";
    let fbUrl = selectedPopup.getAttribute("data-fb") || "";
    let fbtarget = selectedPopup.getAttribute("data-fb-target") || "";
    let fbrel = selectedPopup.getAttribute("data-fb-rel") || "";
    let Gpurl = selectedPopup.getAttribute("data-gp") || "";
    let Gptarget = selectedPopup.getAttribute("data-gp-target") || "";
    let Gprel = selectedPopup.getAttribute("gp-rel") || "";
    let Turl = selectedPopup.getAttribute("data-twitter") || "";
    let Ttarget = selectedPopup.getAttribute("data-twitter-target") || "";
    let Trel = selectedPopup.getAttribute("data-twitter-rel") || "";
    let Dpos = selectedPopup.getAttribute("data-position") || "";
    let existingPopup = team.nextElementSibling;
    if (
      existingPopup &&
      existingPopup.classList.contains("wkit-team-popup-content")
    ) {
      existingPopup.remove();
    }

    let fb =
      fbicon.innerHTML && fbUrl
        ? `<a href="${fbUrl}" class="wkit-team-social-icon" target="${fbtarget}" rel="${fbrel}">${fbicon.innerHTML}</a>`
        : ``;
    let google =
      gpicon.innerHTML && Gpurl
        ? `<a href="${Gpurl}" class="wkit-team-social-icon" target="${Gptarget}" rel="${Gprel}">${gpicon.innerHTML}</a>`
        : ``;
    let twitter =
      twittericon.innerHTML && Turl
        ? `<a href="${Turl}" class="wkit-team-social-icon" target="${Ttarget}" rel="${Trel}">${twittericon.innerHTML}</a>`
        : "";
    let contentDiv = document.createElement("div");
    contentDiv.className = "wkit-team-popup-content";
    contentDiv.style.maxHeight = "0";
    contentDiv.style.opacity = "0";
    contentDiv.style.overflow = "hidden";
    contentDiv.style.transition =
      "max-height 0.3s ease-out, opacity 0.3s ease-out";
    contentDiv.innerHTML = `
        <i class="wkit-close"> <svg class="wkit-close-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg></i>
        <div class="wkit-contet-group">
            <div class="wkit-contact-details">
                <h4 class="wkit-team-name">${name}</h4>
                <h3 class="wkit-desgition">${desg}</h3>
                <p class="wkit-team-details">${details}</p>
            </div>
            <div class="wkit-social-icons">
                <p class="wkit-team ${Dpos}" data-tel="${tel}"><span class="wkit-custom-team-tel">Tel:</span> <a class="wkit-tel" href="tel:${tel}">${tel}</a></p>
                <p class="wkit-em ${Dpos}" data-email="${mail}"><span class="wkit-custom-team-mail" >Email:</span> <a class="wkit-mail" href="mailto:${mail}">${mail}</a></p>
                <div class="wkit-social-group ${Dpos}">
                    <span class="wkit-social-heading">Get Social :</span>
                    <span class="wkit-social-icons-group">
                    ${fb}
                    ${google}
                    ${twitter}
                    </span>
                </div>
            </div>
        </div>
        `;

    team.parentNode.insertBefore(contentDiv, team.nextSibling);
    let borderWidth = selectedPopup.getAttribute("data-border");
    contentDiv.style.border = `${borderWidth} solid #000`;

    team.parentNode.insertBefore(contentDiv, team.nextSibling);

    requestAnimationFrame(() => {
      const extraSpace = 15;
      const numericBorder = parseInt(borderWidth) || 0;
      const totalBorderHeight = numericBorder * 2;
      const totalHeight =
        contentDiv.scrollHeight + totalBorderHeight + extraSpace;
      contentDiv.style.display = "block";
      contentDiv.style.maxHeight = `${totalHeight}px`;
      contentDiv.style.opacity = "1";
    });

    let closeButton = contentDiv.querySelector(".wkit-close");
    closeButton.addEventListener("click", () => {
      contentDiv.style.maxHeight = "0";
      contentDiv.style.opacity = "0";
      setTimeout(() => contentDiv.remove(), 300);
      team.classList.remove("addactive");
    });
  });
});
  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-f5p7zn25.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);