<?php
/**
 * Customizer section options.
 *
 * @package Meme Token
 *
 */

function meme_token_customizer_theme_settings( $wp_customize ){
	
	$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';	
		
		$wp_customize->add_setting('cryptoairdrop_footer_copyright_text',array(
			'sanitize_callback'	=> 'meme_token_sanitize_text',
			'default'			=> __('Powered by <a href="//wordpress.org/">WordPress</a> <span class="sep"> | </span> Meme Token theme by WP Frank', 'meme-token'),
			'transport'			=> $selective_refresh,
		));
		
		$wp_customize->add_control('cryptoairdrop_footer_copyright_text', array(
			'label'			=> esc_html__('Footer Copyright','meme-token'),
			'section'		=> 'cryptoairdrop_footer_copyright',
			'priority'		=> 10,
			'type'			=> 'textarea'
		));

}
add_action( 'customize_register', 'meme_token_customizer_theme_settings' );

function meme_token_sanitize_text( $input ) {
		return wp_kses_post( force_balance_tags( $input ) );
}