<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
(function () {
  // Sélecteurs ciblés : liens, boutons, éléments role=button, inputs bouton
  const SELECTOR = 'a[href]:not([data-mm-focus="off"]), button:not([disabled]):not([data-mm-focus="off"]), [role="button"]:not([data-mm-focus="off"]), input[type="button"]:not([disabled]):not([data-mm-focus="off"]), input[type="submit"]:not([disabled]):not([data-mm-focus="off"]), .wp-block-button__link:not([data-mm-focus="off"])';

  const PADDING = 16; // marge autour de l'élément mis en avant
  const hole = document.getElementById('mm-focus-hole');
  if (!hole) return;

  let activeEl = null;
  let rafId = 0;

  function update() {
    if (!activeEl || !document.body.classList.contains('mm-focus--visible')) return;

    const rect = activeEl.getBoundingClientRect();
    const left = rect.left + window.scrollX - PADDING;
    const top = rect.top + window.scrollY - PADDING;
    const width = rect.width + PADDING * 2;
    const height = rect.height + PADDING * 2;

    // Récupère le border-radius de l'élément pour un trou visuellement cohérent
    const cs = window.getComputedStyle(activeEl);
    const br = cs.borderRadius && cs.borderRadius !== '0px' ? cs.borderRadius : '12px';

    hole.style.left = left + 'px';
    hole.style.top = top + 'px';
    hole.style.width = width + 'px';
    hole.style.height = height + 'px';
    hole.style.borderRadius = br;
  }

  function syncLoop() {
    update();
    rafId = window.requestAnimationFrame(syncLoop);
  }

  function show(el) {
    // Ne pas agir sur la barre admin WP
    if (el.closest && el.closest('#wpadminbar')) return;

    activeEl = el;
    if (!document.body.classList.contains('mm-focus--visible')){
      document.body.classList.add('mm-focus--visible');
    }
    cancelAnimationFrame(rafId);
    syncLoop();
  }

  function hide() {
    activeEl = null;
    document.body.classList.remove('mm-focus--visible');
    cancelAnimationFrame(rafId);
  }

  // Survol souris
  document.addEventListener('mouseover', (e) => {
    const el = e.target && e.target.closest ? e.target.closest(SELECTOR) : null;
    if (el) show(el);
  }, {passive: true});

  document.addEventListener('mouseout', (e) => {
    const toEl = e.relatedTarget && e.relatedTarget.closest ? e.relatedTarget.closest(SELECTOR) : null;
    if (!toEl) hide();
  }, {passive: true});

  // Focus clavier (tab)
  document.addEventListener('focusin', (e) => {
    const el = e.target && e.target.closest ? e.target.closest(SELECTOR) : null;
    if (el) show(el);
  });

  document.addEventListener('focusout', () => {
    // Si le focus part vers un autre élément ciblé, mouseover/focusin gèrera
    setTimeout(() => {
      const el = document.activeElement && document.activeElement.closest ? document.activeElement.closest(SELECTOR) : null;
      if (!el) hide();
    }, 0);
  });

  // Recalcule sur scroll/resize (sécurité, en plus du RAF)
  window.addEventListener('scroll', () => { if (activeEl) update(); }, {passive:true});
  window.addEventListener('resize', () => { if (activeEl) update(); });

  // Échappe pour fermer
  document.addEventListener('keydown', (e) => { if (e.key === 'Escape') hide(); });

  // API simple pour activer/désactiver globalement si besoin
  window.mmFocus = {
    enable(){ document.body.dataset.mmFocus = 'on'; },
    disable(){ document.body.dataset.mmFocus = 'off'; hide(); }
  };
})();</script>
<!-- end Simple Custom CSS and JS -->
