<?php
/*
 * Widget Name: Review Testimonial Carousal
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Review_Testimonial_Carousal_vogv8v23
 */
class Wdkit_Review_Testimonial_Carousal_vogv8v23 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-vogv8v23';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Review Testimonial Carousal', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-review';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'Wkit Builder', $GG_Databash ) ){

                return array('Wkit Builder');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Testimonials Carousel Sliders','Testimonials Carousel','Client Reviews','Video Integration','User Testimonials','Website Reviews');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        wp_enqueue_script( 'wd_ex_script_158px525', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', array(), '1.2.17.763111', true );


        wp_enqueue_script( 'wkit_child_script_81d5zr25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Review-Testimonial-Carousal_vogv8v23/Review_Testimonial_Carousal_vogv8v23.js', array(), '1.2.17.946952', true );

        return [ 'wkit_child_script_81d5zr25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        wp_enqueue_style( 'wd_css_ex_1_svhnuv25', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css', false, '1.2.17.572419', 'all' );


        wp_enqueue_style( 'wkit_css_1_4daxyg25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Review-Testimonial-Carousal_vogv8v23/Review_Testimonial_Carousal_vogv8v23.css', false, '1.2.17.505508', 'all' );

        return [ 'wkit_css_1_4daxyg25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_inrre525 = new \Elementor\Repeater();

                $repeater_inrre525->add_control('media_uap5s923',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array("image"),
           
            
            
        )
            );
$repeater_inrre525->add_control('text_i2ivq223',
                array(
            
            'label' => esc_html__( 'Author Name', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Robert L. West 1', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            'classes' => 'video_title_custom',
            
            
        )
            );
$repeater_inrre525->add_control('text_6wr8ug23',
                array(
            
            'label' => esc_html__( 'Location', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '101 Fraggle Drive1', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_inrre525->add_control('iconscontrol_wcu1m123',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-map-marker-alt',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_inrre525->add_control('url_j01w8n23',
                array(
            
            'label' => esc_html__( 'iFrame Link', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => 'https://www.youtube.com/embed/c--TtuEWuCo?si=HUT4UTmfk8_9aK0I',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$repeater_inrre525->add_control('number_wsago623',
                array(
            
            'label' => esc_html__( 'Star Rating', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => "",
            'max' => 5,
            'step' => 1,
            'default' => 3,
            
            
            
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} undefined' => 'undefined: {{VALUE}}',),
        )
            );
$repeater_inrre525->add_control('rawhtml_gcsqxf25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Refresh is required after making changes.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$repeater_inrre525->add_control('heading_6cs98024',
                array(
            
            'label' => esc_html__( 'Description 1', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_inrre525->add_control('textarea_amocs023',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            
            
            
            'label_block' => true,
            
            'rows' => '5',
            
            'default' => esc_html__( 'Abnormal Eye Movement,Changes in speech1', 'wdesignkit' ),
            
            
            
        )
            );
$repeater_inrre525->add_control('heading_eerfmi24',
                array(
            
            'label' => esc_html__( 'Description 2', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_inrre525->add_control('textarea_zrabun23',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            
            
            
            'label_block' => true,
            
            'rows' => '5',
            
            'default' => esc_html__( 'Aneurysms1', 'wdesignkit' ),
            
            
            
        )
            );
$repeater_inrre525->add_control('heading_jtg8ml24',
                array(
            
            'label' => esc_html__( 'Description 3', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_inrre525->add_control('textarea_9qwb3i23',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            
            
            
            'label_block' => true,
            
            'rows' => '5',
            
            'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum.Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'wdesignkit' ),
            
            
            
        )
            );

                
                $this->add_control('repeater_l66j5q23',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Slides', 'wdesignkit' ),
                
                
                
                
                
				'fields' => $repeater_inrre525->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-s0341825'),
'media_uap5s923' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_i2ivq223' => esc_html__('Robert L. West 1', 'wdesignkit'), 
'text_6wr8ug23' => esc_html__('101 Fraggle Drive1', 'wdesignkit'), 
'iconscontrol_wcu1m123' => 'fas fa-map-marker-alt', 
'url_j01w8n23' => 'https://www.youtube.com/embed/c--TtuEWuCo?si=HUT4UTmfk8_9aK0I', 
'number_wsago623' => esc_html__('3', 'wdesignkit'), 
'rawhtml_gcsqxf25' => '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Refresh is required after making changes.
</div>', 
'heading_6cs98024' => esc_html__('', 'wdesignkit'), 
'textarea_amocs023' => esc_html__('Abnormal Eye Movement,Changes in speech1', 'wdesignkit'), 
'heading_eerfmi24' => esc_html__('', 'wdesignkit'), 
'textarea_zrabun23' => esc_html__('Aneurysms1', 'wdesignkit'), 
'heading_jtg8ml24' => esc_html__('', 'wdesignkit'), 
'textarea_9qwb3i23' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum.Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'wdesignkit'), 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Meta data_tab_content',
            [
                'label' => esc_html__( 'Meta data', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('heading_dsuj5l24',
                array(
            
            'label' => esc_html__( 'Heading 1', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_control('iconscontrol_ilmid323',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-medkit',
                'library' => 'fa-solid',
            ),
            
        )
            );
$this->add_control('text_jv489t23',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Symptoms', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->add_control('heading_sfmxij24',
                array(
            
            'label' => esc_html__( 'Heading 2', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('iconscontrol_4epu9723',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-stethoscope',
                'library' => 'fa-solid',
            ),
            
        )
            );
$this->add_control('text_gj27ex23',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Condition', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->add_control('heading_w7copv24',
                array(
            
            'label' => esc_html__( 'Heading 3', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('iconscontrol_r9rwzj23',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-user',
                'library' => 'fa-solid',
            ),
            
        )
            );
$this->add_control('text_kbfyuq23',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'What patients say', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Separator_tab_content',
            [
                'label' => esc_html__( 'Separator', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_39cc1223',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'More Videos', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Option_tab_content',
            [
                'label' => esc_html__( 'Extra Option', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_ivn4by23',
                array(
            
            'label' => esc_html__( 'Desktop Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => '3',
            
            'options' => array( '1'  => esc_html__( '1', 'wdesignkit' ),'2'  => esc_html__( '2', 'wdesignkit' ),'3'  => esc_html__( '3', 'wdesignkit' ),'4'  => esc_html__( '4', 'wdesignkit' ),'5'  => esc_html__( '5', 'wdesignkit' ),'6'  => esc_html__( '6', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_co2s3r23',
                array(
            
            'label' => esc_html__( 'Tablet Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => '2',
            
            'options' => array( '1'  => esc_html__( '1', 'wdesignkit' ),'2'  => esc_html__( '2', 'wdesignkit' ),'3'  => esc_html__( '3', 'wdesignkit' ),'4'  => esc_html__( '4', 'wdesignkit' ),'5'  => esc_html__( '5', 'wdesignkit' ),'6'  => esc_html__( '6', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_pks6jr23',
                array(
            
            'label' => esc_html__( 'Mobile Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => '1',
            
            'options' => array( '1'  => esc_html__( '1', 'wdesignkit' ),'2'  => esc_html__( '2', 'wdesignkit' ),'3'  => esc_html__( '3', 'wdesignkit' ),'4'  => esc_html__( '4', 'wdesignkit' ),'5'  => esc_html__( '5', 'wdesignkit' ),'6'  => esc_html__( '6', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_9oysk525',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/review-testimonial-carousel/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Location_style_secdddtion',
            [
                'label' => esc_html__( 'Location', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_re54sa25',
                array(
            
            'label' => esc_html__( 'Icon Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .author-location-main .author-left' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_a5kssr23',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patient-row .author-location-main .author-icon-wrapper .tp-title-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_kb4tx324',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patient-row .author-location-main .author-icon-wrapper .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_qxexmb23',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-test-review .patients-column-right .author-location-main .author-location-title',
			)
            );
$this->add_control('color_vurzlz23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patients-column-right .author-location-main .author-location-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_0lu8jf23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patient-row .author-location-main .author-icon-wrapper .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_vljzwg24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patient-row .author-location-main .author-icon-wrapper .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Star_style_secdddtion',
            [
                'label' => esc_html__( 'Star', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_rm7k6g23',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 50,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-video-rate .wkit-star-rating' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_41dusb23',
                array(
            
            'label' => esc_html__( 'Normal Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-rate .wkit-star-rating' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_44vnkp23',
                array(
            
            'label' => esc_html__( 'Active Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-rate .wkit-star-rating.active' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Author Name_style_secdddtion',
            [
                'label' => esc_html__( 'Author Name', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_3rsspq23',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-test-review .patients-column-right .author-wrap .author-name',
			)
            );
$this->add_control('color_2cx8lw23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patients-column-right .author-wrap .author-name' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Heading_style_secdddtion',
            [
                'label' => esc_html__( 'Heading', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_yxep8k25',
                array(
            
            'label' => esc_html__( 'Icon Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .details-info-box .details-inner-top-part' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_8d4dwx25',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .details-icon .tp-title-icon ' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_xky5fy25',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .details-icon .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_9p6go023',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-test-review .patients-column-right .details-info-box .details-top-heading',
			)
            );
$this->add_control('color_pig93q23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .patients-column-right .details-info-box .details-top-heading' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_cl1ujq25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .details-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_dgodg325',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .details-icon .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Description_style_secdddtion',
            [
                'label' => esc_html__( 'Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_j8q9v923',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-test-review  .patients-column-right .desc',
			)
            );
$this->add_control('color_liz29z23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review  .patients-column-right .desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Profile Title_style_secdddtion',
            [
                'label' => esc_html__( 'Profile Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_y2mtm123',
                array(
            
            'label' => esc_html__( 'Top Spacing', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-video-test-title' => 'margin-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_1wskv223',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-video-wrap .wkit-video-test-title',
			)
            );
$this->start_controls_tabs('normalhover_5m4elx23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_5m4elx23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_3kyteh23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .wkit-video-test-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_5m4elx23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_yuimih23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide:hover .wkit-video-test-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_5m4elx23_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_2c2r8923',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide.box-active .wkit-video-test-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Profile Location_style_secdddtion',
            [
                'label' => esc_html__( 'Profile Location', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_gd2q9c25',
                array(
            
            'label' => esc_html__( 'Icon Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide .title-wrap' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_qtwl7t23',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 50,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .video-info-inner .title-wrap .wkit-video-icon i' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_28opeh24',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 50,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .video-info-inner .title-wrap .wkit-video-icon .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_egm50a25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide .wkit-video-location',
			)
            );
$this->start_controls_tabs('normalhover_vxe73i25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_vxe73i25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_9e1xps23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .wkit-video-location' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_8k4fud23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .video-info-inner .title-wrap .wkit-video-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_8txu4t24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .video-info-inner .title-wrap .wkit-video-icon .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_vxe73i25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_f2v28023',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide:hover .wkit-video-location' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_spxxds23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .video-info-slide:hover .wkit-video-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_yxjg3e24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .video-info-slide:hover .wkit-video-icon .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_vxe73i25_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_fxpjmu23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide.box-active .wkit-video-location' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_hkv7wh23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .video-info-slide.box-active .wkit-video-icon .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_hjyhp324',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .video-info-slide.box-active .wkit-video-icon .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Box Background_style_secdddtion',
            [
                'label' => esc_html__( 'Box Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_tg59gy23',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->start_controls_tabs('normalhover_npw5v023',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_npw5v023_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_chv4gb23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_2qio2j23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide',
        )
            );
$this->add_responsive_control('dimension_52f8j423',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_ceylys23',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_npw5v023_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_3v2rf923',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_sfl7ym23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_57fx1223',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide:hover', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_npw5v023_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_u0tsfn23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide.box-active',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_s7nfha23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide.box-active',
        )
            );
$this->add_responsive_control('dimension_m2olif23',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-video-wrap .video-info-slide.box-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_ridgdj23',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-video-wrap .video-info-slide.box-active', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Separator_style_secdddtion',
            [
                'label' => esc_html__( 'Separator', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_dkxlxk23',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-test-review .video-separator .more-video-title',
			)
            );
$this->add_control('color_v5zf3523',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-test-review .video-separator .more-video-title' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_waavtu23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-test-review .video-border-heading',
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Arrow_style_secdddtion',
            [
                'label' => esc_html__( 'Arrow', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->start_controls_tabs('normalhover_o5n11923',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_o5n11923_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_e3hq4l23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-review-slider .slick-prev::before, {{WRAPPER}} .wkit-review-slider .slick-next::before' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_23wmwl23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-review-slider .slick-prev, {{WRAPPER}} .wkit-review-slider .slick-next' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_o5n11923_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_h41nwo23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-review-slider .slick-prev:hover::before, {{WRAPPER}} .wkit-review-slider .slick-next:hover::before' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_god2yw23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-review-slider .slick-prev:hover, {{WRAPPER}} .wkit-review-slider .slick-next:hover' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $heading_dsuj5l24 = !empty($settings['heading_dsuj5l24']) ? $settings['heading_dsuj5l24'] : '';
$iconscontrol_ilmid323 = "";
                        if(!empty($settings['iconscontrol_ilmid323']) && !empty($settings['iconscontrol_ilmid323']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($settings['iconscontrol_ilmid323'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_ilmid323 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$text_jv489t23 = !empty($settings['text_jv489t23']) ? $this->wdk_senitize_js($settings['text_jv489t23']) : '';
$heading_sfmxij24 = !empty($settings['heading_sfmxij24']) ? $settings['heading_sfmxij24'] : '';
$iconscontrol_4epu9723 = "";
                        if(!empty($settings['iconscontrol_4epu9723']) && !empty($settings['iconscontrol_4epu9723']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($settings['iconscontrol_4epu9723'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_4epu9723 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$text_gj27ex23 = !empty($settings['text_gj27ex23']) ? $this->wdk_senitize_js($settings['text_gj27ex23']) : '';
$heading_w7copv24 = !empty($settings['heading_w7copv24']) ? $settings['heading_w7copv24'] : '';
$iconscontrol_r9rwzj23 = "";
                        if(!empty($settings['iconscontrol_r9rwzj23']) && !empty($settings['iconscontrol_r9rwzj23']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($settings['iconscontrol_r9rwzj23'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_r9rwzj23 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$text_kbfyuq23 = !empty($settings['text_kbfyuq23']) ? $this->wdk_senitize_js($settings['text_kbfyuq23']) : '';
$text_39cc1223 = !empty($settings['text_39cc1223']) ? $this->wdk_senitize_js($settings['text_39cc1223']) : '';
$select_ivn4by23 = !empty($settings['select_ivn4by23']) ? $this->wdk_senitize_js($settings['select_ivn4by23']) : '';
$select_co2s3r23 = !empty($settings['select_co2s3r23']) ? $this->wdk_senitize_js($settings['select_co2s3r23']) : '';
$select_pks6jr23 = !empty($settings['select_pks6jr23']) ? $this->wdk_senitize_js($settings['select_pks6jr23']) : '';
$rawhtml_9oysk525 = !empty($settings['rawhtml_9oysk525']) ? $this->wdk_senitize_js($settings['rawhtml_9oysk525']) : '';

        $repeater_l66j5q23_6f25 = '';
                            if ( $settings['repeater_l66j5q23'] ) {
                                foreach ( $settings['repeater_l66j5q23'] as $key => $r_item ) {
                                    $media_uap5s923 = !empty($r_item['media_uap5s923']['url']) ? $this->wdk_senitize_js($r_item['media_uap5s923']['url']) : '';
$iconscontrol_wcu1m123 = "";
                        if(!empty($r_item['iconscontrol_wcu1m123']) && !empty($r_item['iconscontrol_wcu1m123']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_wcu1m123'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_wcu1m123 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_j01w8n23_is_external = !empty($r_item['url_j01w8n23']) && !empty($r_item['url_j01w8n23']['is_external']) ? '_blank' : '';
$url_j01w8n23_url = !empty($r_item['url_j01w8n23']) && !empty($r_item['url_j01w8n23']['url'])? $this->wdk_senitize_js($r_item['url_j01w8n23']['url']) : '';
$url_j01w8n23_nofollow = !empty($r_item['url_j01w8n23']) && !empty($r_item['url_j01w8n23']['nofollow'])? 'nofollow' : '';
$number_wsago623 = isset($r_item['number_wsago623']) ? $this->wdk_senitize_js($r_item['number_wsago623']) : '';

                                    $repeater_l66j5q23_6f25 .= '<div data-videol="'.$url_j01w8n23_url.'" data-rating="'.$number_wsago623.'" data-location="' . $this->wdk_senitize_js($r_item['text_6wr8ug23']) . '" class="{loop-class} video-info-slide" data-tsymptoms="'.$text_jv489t23.'" data-tcondition="'.$text_gj27ex23.'" data-twpatient="'.$text_kbfyuq23.'" data-what-patisn="' . $this->wdk_senitize_js($r_item['textarea_9qwb3i23']) . '" data-condition="' . $this->wdk_senitize_js($r_item['textarea_zrabun23']) . '" data-symptoms="' . $this->wdk_senitize_js($r_item['textarea_amocs023']) . '" data-title="' . $this->wdk_senitize_js($r_item['text_i2ivq223']) . '" data-repeater_l66j5q23="{repeater_l66j5q23}">
               <div class="video-info-inner">
                        <div class="banner-img-inner">
                           <div class="banner-img"><img src="'.$media_uap5s923.'"></div>
                        </div>
                        <div><h3 class="wkit-video-test-title">' . $this->wdk_senitize_js($r_item['text_i2ivq223']) . '</h3><div>
                        <div class="title-wrap">
                            <div class="wkit-video-icon">'.$iconscontrol_wcu1m123.'</div>
                            <div class="condition-icon">'.$iconscontrol_4epu9723.'</div>
                             <div class="review-icon">'.$iconscontrol_r9rwzj23.'</div>
                             <div class="symptoms-icon">'.$iconscontrol_ilmid323.'</div>
                             <p class="wkit-video-location">' . $this->wdk_senitize_js($r_item['text_6wr8ug23']) . '</p>
                        </div>
                </div>
           </div>
        </div>
    </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_vogv8v23" data-wdkitunique="vogv8v23">';
            $output .= '<div class="wkit-test-review">
    <div class="patient-row"></div>
    <div class="video-separator">
        <div class="video-border-heading"></div>
        <div> <h3 class="more-video-title">'.$text_39cc1223.'</h3></div>
        <div class="video-border-heading"></div>
    </div>
    <div class="wkit-review-slider">
           <div class="wkit-video-wrap slick-slider" data-desk="'.$select_ivn4by23.'" data-tab="'.$select_co2s3r23.'" data-mob="'.$select_pks6jr23.'">
            '.$repeater_l66j5q23_6f25.'
</div></div></div>';
        $output .= '</div>';
        
        echo $output;
    }
}