(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let container = $scope[0].querySelector('.wkit-swap-logo-grid');
let logos = Array.from(container.querySelectorAll('.logo-item'));

let getSpeed = (container.getAttribute('data-swapspeed')) ? Number(container.getAttribute('data-swapspeed')) : 3000;
const totalLogos = logos.length;

function isMobileDevice() {
    return window.innerWidth <= 768; 
}

function swapLogos() {
    if (isMobileDevice() || logos.length < 2) {
        return;
    }

    const randIndex1 = Math.floor(Math.random() * totalLogos);
    let randIndex2;
    do {
        randIndex2 = Math.floor(Math.random() * totalLogos);
    } while (randIndex1 === randIndex2);

    const logo1 = logos[randIndex1];
    const logo2 = logos[randIndex2];

    const logo1Rect = logo1.getBoundingClientRect();
    const logo2Rect = logo2.getBoundingClientRect();
    const deltaX = logo2Rect.left - logo1Rect.left;
    const deltaY = logo2Rect.top - logo1Rect.top;

    gsap.to(logo1, { duration: 1, x: deltaX, y: deltaY });
    gsap.to(logo2, { duration: 1, x: -deltaX, y: -deltaY, onComplete: () => {
        const logo1NextSibling = logo1.nextSibling;
        const logo2NextSibling = logo2.nextSibling;

        container.insertBefore(logo2, logo1NextSibling);
        container.insertBefore(logo1, logo2NextSibling);

        gsap.set(logo1, { x: 0, y: 0 });
        gsap.set(logo2, { x: 0, y: 0 });

        logos.splice(randIndex1, 1, logo2);
        logos.splice(randIndex2, 1, logo1);
    }});
}

let lastSwapTime = 0;

function animate(time) {
    if (time - lastSwapTime >= getSpeed) {
        swapLogos();
        lastSwapTime = time;
    }

    requestAnimationFrame(animate);
}

if(!elementorFrontend.isEditMode()){
    requestAnimationFrame(animate);
    // setInterval(swapLogos, 3000);
}  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-wy24w124.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);