<?php
/*
 * Widget Name: Text Shimmer
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Text_Shimmer_yfj7y525
 */
class Wdkit_Text_Shimmer_yfj7y525 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-yfj7y525';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Text Shimmer', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-font';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Text Animation','Shimmer Effect','CTA Highlight');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        wp_enqueue_script( 'wd_ex_script_6p8pnw25', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js', array(), '1.2.17.191751', true );
wp_enqueue_script( 'wd_ex_script_ne8n9r25', 'https://cdn.jsdelivr.net/npm/tweakpane@3.1.8/dist/tweakpane.min.js', array(), '1.2.17.409365', true );


        wp_enqueue_script( 'wkit_child_script_rlehyk25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Text-Shimmer_yfj7y525/Text_Shimmer_yfj7y525.js', array(), '1.2.17.80494', true );

        return [ 'wkit_child_script_rlehyk25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_r2ys1z25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Text-Shimmer_yfj7y525/Text_Shimmer_yfj7y525.css', false, '1.2.17.385033', 'all' );

        return [ 'wkit_css_1_r2ys1z25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_pjjxqi25',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'classic',
            
            'options' => array( 'classic'  => esc_html__( 'Style 1', 'wdesignkit' ),'flame'  => esc_html__( 'Style 2', 'wdesignkit' ),'aurora'  => esc_html__( 'Style 3', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_rs3stp25 = new \Elementor\Repeater();

                $repeater_rs3stp25->add_control('text_za2ebf25',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Hang tight! Magic is loading...', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_rs3stp25->add_control('url_n66tj125',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );

                
                $this->add_control('repeater_dpoo4g25',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Items', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_rs3stp25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-j0lws525'),
'text_za2ebf25' => esc_html__('Hang tight! Magic is loading...', 'wdesignkit'), 
'url_n66tj125' => '#', 
),
array('_id'=>uniqid('Wkit-tcni1x25'),
'text_za2ebf25' => esc_html__('Hang tight! Magic is loading...', 'wdesignkit'), 
'url_n66tj125' => '#', 
),
array('_id'=>uniqid('Wkit-0l64t625'),
'text_za2ebf25' => esc_html__('Hang tight! Magic is loading...', 'wdesignkit'), 
'url_n66tj125' => '#', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('number_95u10525',
                array(
            
            'label' => esc_html__( 'Speed', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1,
            'step' => 0.01,
            'default' => 0.2,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_u2ru5025',
                array(
            
            'label' => esc_html__( 'Spread (character)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 10,
            'step' => 1,
            'default' => 3,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_2m2ukr25',
                array(
            
            'label' => esc_html__( 'Angle (deg)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 360,
            'step' => 1,
            'default' => 135,
            
            
            
            
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_yfxg2z25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/text-shimmer/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('choose_ptwpvs25',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'flex-start' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'flex-end' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-content' => 'align-items: {{VALUE}}',),
        )
            );
$this->add_responsive_control('dimension_cjg5gt25',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%','rem',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('slider_x044ca25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%","rem", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 98,
						'step' => 1,
					),'rem' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-content' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_iurchn25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-shimmer-container  .wkit-text',
			)
            );
$this->start_controls_tabs('normalhover_lcl86725',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_lcl86725_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_wmj0sf25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container .wkit-text' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_9ajbbe25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Use transparent color for proper effect.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                    
        Group_Control_Text_Shadow::get_type(),
            array(
				'name' => 'textshadow_bqxepl25',
                'label' => esc_html__( 'Text Shadow', 'wdesignkit' ),
                
                
                
				'selector' => '{{WRAPPER}} .wkit-shimmer-container .wkit-text',
			)
                );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_lcl86725_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_4udbyd25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container .wkit-text:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_lod33q25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Use transparent color for proper effect.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                    
        Group_Control_Text_Shadow::get_type(),
            array(
				'name' => 'textshadow_oxqp0h25',
                'label' => esc_html__( 'Text Shadow', 'wdesignkit' ),
                
                
                
				'selector' => '{{WRAPPER}} .wkit-shimmer-container .wkit-text:hover',
			)
                );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Effects Color_style_secdddtion',
            [
                'label' => esc_html__( 'Effects Color', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('color_k9cyij25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'classic'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container.classic .wkit-text' => '--shimmer-color: {{VALUE}}',),
        )
            );
$this->add_control('color_t6qcp325',
                array(
            
            'label' => esc_html__( 'Color 1', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'flame'),
array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'aurora'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container.flame .wkit-text, {{WRAPPER}} .wkit-shimmer-container.aurora .wkit-text' => '--shimmer-color-1: {{VALUE}}',),
        )
            );
$this->add_control('color_vtw8ja25',
                array(
            
            'label' => esc_html__( 'Color 2', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'flame'),
array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'aurora'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container.flame .wkit-text, {{WRAPPER}} .wkit-shimmer-container.aurora .wkit-text' => '--shimmer-color-2: {{VALUE}}',),
        )
            );
$this->add_control('color_8wsrxp25',
                array(
            
            'label' => esc_html__( 'Color 3', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'aurora'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container.aurora .wkit-text' => '--shimmer-color-3: {{VALUE}}',),
        )
            );
$this->add_control('color_gfti7n25',
                array(
            
            'label' => esc_html__( 'Color 4', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_pjjxqi25', 'operator' => '==', 'value' => 'aurora'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container.aurora .wkit-text' => '--shimmer-color-4: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Background_style_secdddtion',
            [
                'label' => esc_html__( 'Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('dimension_7tkaxk25',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-shimmer-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_s8fa7o25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-shimmer-container',
        )
            );
$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_pjjxqi25 = !empty($settings['select_pjjxqi25']) ? $settings['select_pjjxqi25'] : '';
$number_95u10525 = isset($settings['number_95u10525']) ? $settings['number_95u10525'] : '';
$number_u2ru5025 = isset($settings['number_u2ru5025']) ? $settings['number_u2ru5025'] : '';
$number_2m2ukr25 = isset($settings['number_2m2ukr25']) ? $settings['number_2m2ukr25'] : '';
$rawhtml_yfxg2z25 = !empty($settings['rawhtml_yfxg2z25']) ? $this->wdk_senitize_js($settings['rawhtml_yfxg2z25']) : '';

        $repeater_dpoo4g25_3u25 = '';
                            if ( $settings['repeater_dpoo4g25'] ) {
                                foreach ( $settings['repeater_dpoo4g25'] as $key => $r_item ) {
                                    $url_n66tj125_is_external = !empty($r_item['url_n66tj125']) && !empty($r_item['url_n66tj125']['is_external']) ? '_blank' : '';
$url_n66tj125_url = !empty($r_item['url_n66tj125']) && !empty($r_item['url_n66tj125']['url'])? esc_url($r_item['url_n66tj125']['url']) : '';
$url_n66tj125_nofollow = !empty($r_item['url_n66tj125']) && !empty($r_item['url_n66tj125']['nofollow'])? 'nofollow' : '';

                                    $repeater_dpoo4g25_3u25 .= '<a class="fluid wkit-text elementor-repeater-item-' .esc_attr($r_item['_id']) . '" href="'.$url_n66tj125_url.'" target="'.$url_n66tj125_is_external.'" rel="'.$url_n66tj125_nofollow.'" data-repeater_dpoo4g25="{repeater_dpoo4g25}">
          ' . sanitize_text_field($r_item['text_za2ebf25']) . '
        </a>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_yfj7y525" data-wdkitunique="yfj7y525">';
            $output .= '<div class="wkit-shimmer-container '.$select_pjjxqi25.'">
    <div class="wkit-shimmer-content" data-speed="'.$number_95u10525.'" data-spread="'.$number_u2ru5025.'" data-angle="'.$number_2m2ukr25.'">
        '.$repeater_dpoo4g25_3u25.'
    </div>   
</div>
';
        $output .= '</div>';
        
        echo $output;
    }
}