<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\Resource;

use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\CaptureOrderRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\CaptureOrderResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\Order;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersAcknowledgeRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersAcknowledgeResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersAdvanceTestOrderResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCancelLineItemRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCancelLineItemResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCancelRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCancelResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCancelTestOrderByCustomerRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCancelTestOrderByCustomerResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCreateTestOrderRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCreateTestOrderResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCreateTestReturnRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersCreateTestReturnResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersGetByMerchantOrderIdResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersGetTestOrderTemplateResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersInStoreRefundLineItemRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersInStoreRefundLineItemResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersListResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersRefundItemRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersRefundItemResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersRefundOrderRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersRefundOrderResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersRejectReturnLineItemRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersRejectReturnLineItemResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersReturnRefundLineItemRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersReturnRefundLineItemResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersSetLineItemMetadataRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersSetLineItemMetadataResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersShipLineItemsRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersShipLineItemsResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersUpdateLineItemShippingDetailsRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersUpdateLineItemShippingDetailsResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersUpdateMerchantOrderIdRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersUpdateMerchantOrderIdResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersUpdateShipmentRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrdersUpdateShipmentResponse;

/**
 * The "orders" collection of methods.
 * Typical usage is:
 *  <code>
 *   $contentService = new Google\Service\ShoppingContent(...);
 *   $orders = $contentService->orders;
 *  </code>
 */
class Orders extends \Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\Resource
{
  /**
   * Marks an order as acknowledged. (orders.acknowledge)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersAcknowledgeRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersAcknowledgeResponse
   * @throws \Google\Service\Exception
   */
  public function acknowledge($merchantId, $orderId, OrdersAcknowledgeRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('acknowledge', [$params], OrdersAcknowledgeResponse::class);
  }
  /**
   * Sandbox only. Moves a test order from state "`inProgress`" to state
   * "`pendingShipment`". (orders.advancetestorder)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the test order to modify.
   * @param array $optParams Optional parameters.
   * @return OrdersAdvanceTestOrderResponse
   * @throws \Google\Service\Exception
   */
  public function advancetestorder($merchantId, $orderId, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId];
    $params = array_merge($params, $optParams);
    return $this->call('advancetestorder', [$params], OrdersAdvanceTestOrderResponse::class);
  }
  /**
   * Cancels all line items in an order, making a full refund. (orders.cancel)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order to cancel.
   * @param OrdersCancelRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersCancelResponse
   * @throws \Google\Service\Exception
   */
  public function cancel($merchantId, $orderId, OrdersCancelRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('cancel', [$params], OrdersCancelResponse::class);
  }
  /**
   * Cancels a line item, making a full refund. (orders.cancellineitem)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersCancelLineItemRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersCancelLineItemResponse
   * @throws \Google\Service\Exception
   */
  public function cancellineitem($merchantId, $orderId, OrdersCancelLineItemRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('cancellineitem', [$params], OrdersCancelLineItemResponse::class);
  }
  /**
   * Sandbox only. Cancels a test order for customer-initiated cancellation.
   * (orders.canceltestorderbycustomer)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the test order to cancel.
   * @param OrdersCancelTestOrderByCustomerRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersCancelTestOrderByCustomerResponse
   * @throws \Google\Service\Exception
   */
  public function canceltestorderbycustomer($merchantId, $orderId, OrdersCancelTestOrderByCustomerRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('canceltestorderbycustomer', [$params], OrdersCancelTestOrderByCustomerResponse::class);
  }
  /**
   * Capture funds from the customer for the current order total. This method
   * should be called after the merchant verifies that they are able and ready to
   * start shipping the order. This method blocks until a response is received
   * from the payment processsor. If this method succeeds, the merchant is
   * guaranteed to receive funds for the order after shipment. If the request
   * fails, it can be retried or the order may be cancelled. This method cannot be
   * called after the entire order is already shipped. A rejected error code is
   * returned when the payment service provider has declined the charge. This
   * indicates a problem between the PSP and either the merchant's or customer's
   * account. Sometimes this error will be resolved by the customer. We recommend
   * retrying these errors once per day or cancelling the order with reason
   * `failedToCaptureFunds` if the items cannot be held. (orders.captureOrder)
   *
   * @param string $merchantId Required. The ID of the account that manages the
   * order. This cannot be a multi-client account.
   * @param string $orderId Required. The ID of the Order.
   * @param CaptureOrderRequest $postBody
   * @param array $optParams Optional parameters.
   * @return CaptureOrderResponse
   * @throws \Google\Service\Exception
   */
  public function captureOrder($merchantId, $orderId, CaptureOrderRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('captureOrder', [$params], CaptureOrderResponse::class);
  }
  /**
   * Sandbox only. Creates a test order. (orders.createtestorder)
   *
   * @param string $merchantId The ID of the account that should manage the order.
   * This cannot be a multi-client account.
   * @param OrdersCreateTestOrderRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersCreateTestOrderResponse
   * @throws \Google\Service\Exception
   */
  public function createtestorder($merchantId, OrdersCreateTestOrderRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('createtestorder', [$params], OrdersCreateTestOrderResponse::class);
  }
  /**
   * Sandbox only. Creates a test return. (orders.createtestreturn)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersCreateTestReturnRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersCreateTestReturnResponse
   * @throws \Google\Service\Exception
   */
  public function createtestreturn($merchantId, $orderId, OrdersCreateTestReturnRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('createtestreturn', [$params], OrdersCreateTestReturnResponse::class);
  }
  /**
   * Retrieves an order from your Merchant Center account. (orders.get)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param array $optParams Optional parameters.
   * @return Order
   * @throws \Google\Service\Exception
   */
  public function get($merchantId, $orderId, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], Order::class);
  }
  /**
   * Retrieves an order using merchant order ID. (orders.getbymerchantorderid)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $merchantOrderId The merchant order ID to be looked for.
   * @param array $optParams Optional parameters.
   * @return OrdersGetByMerchantOrderIdResponse
   * @throws \Google\Service\Exception
   */
  public function getbymerchantorderid($merchantId, $merchantOrderId, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'merchantOrderId' => $merchantOrderId];
    $params = array_merge($params, $optParams);
    return $this->call('getbymerchantorderid', [$params], OrdersGetByMerchantOrderIdResponse::class);
  }
  /**
   * Sandbox only. Retrieves an order template that can be used to quickly create
   * a new order in sandbox. (orders.gettestordertemplate)
   *
   * @param string $merchantId The ID of the account that should manage the order.
   * This cannot be a multi-client account.
   * @param string $templateName The name of the template to retrieve.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string country The country of the template to retrieve. Defaults
   * to "`US`".
   * @return OrdersGetTestOrderTemplateResponse
   * @throws \Google\Service\Exception
   */
  public function gettestordertemplate($merchantId, $templateName, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'templateName' => $templateName];
    $params = array_merge($params, $optParams);
    return $this->call('gettestordertemplate', [$params], OrdersGetTestOrderTemplateResponse::class);
  }
  /**
   * Deprecated. Notifies that item return and refund was handled directly by
   * merchant outside of Google payments processing (for example, cash refund done
   * in store). Note: We recommend calling the returnrefundlineitem method to
   * refund in-store returns. We will issue the refund directly to the customer.
   * This helps to prevent possible differences arising between merchant and
   * Google transaction records. We also recommend having the point of sale system
   * communicate with Google to ensure that customers do not receive a double
   * refund by first refunding through Google then through an in-store return.
   * (orders.instorerefundlineitem)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersInStoreRefundLineItemRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersInStoreRefundLineItemResponse
   * @throws \Google\Service\Exception
   */
  public function instorerefundlineitem($merchantId, $orderId, OrdersInStoreRefundLineItemRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('instorerefundlineitem', [$params], OrdersInStoreRefundLineItemResponse::class);
  }
  /**
   * Lists the orders in your Merchant Center account. (orders.listOrders)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param array $optParams Optional parameters.
   *
   * @opt_param bool acknowledged Obtains orders that match the acknowledgement
   * status. When set to true, obtains orders that have been acknowledged. When
   * false, obtains orders that have not been acknowledged. We recommend using
   * this filter set to `false`, in conjunction with the `acknowledge` call, such
   * that only un-acknowledged orders are returned.
   * @opt_param string maxResults The maximum number of orders to return in the
   * response, used for paging. The default value is 25 orders per page, and the
   * maximum allowed value is 250 orders per page.
   * @opt_param string orderBy Order results by placement date in descending or
   * ascending order. Acceptable values are: - placedDateAsc - placedDateDesc
   * @opt_param string pageToken The token returned by the previous request.
   * @opt_param string placedDateEnd Obtains orders placed before this date
   * (exclusively), in ISO 8601 format.
   * @opt_param string placedDateStart Obtains orders placed after this date
   * (inclusively), in ISO 8601 format.
   * @opt_param string statuses Obtains orders that match any of the specified
   * statuses. Note that `active` is a shortcut for `pendingShipment` and
   * `partiallyShipped`, and `completed` is a shortcut for `shipped`,
   * `partiallyDelivered`, `delivered`, `partiallyReturned`, `returned`, and
   * `canceled`.
   * @return OrdersListResponse
   * @throws \Google\Service\Exception
   */
  public function listOrders($merchantId, $optParams = [])
  {
    $params = ['merchantId' => $merchantId];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], OrdersListResponse::class);
  }
  /**
   * Issues a partial or total refund for items and shipment. (orders.refunditem)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order to refund.
   * @param OrdersRefundItemRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersRefundItemResponse
   * @throws \Google\Service\Exception
   */
  public function refunditem($merchantId, $orderId, OrdersRefundItemRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('refunditem', [$params], OrdersRefundItemResponse::class);
  }
  /**
   * Issues a partial or total refund for an order. (orders.refundorder)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order to refund.
   * @param OrdersRefundOrderRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersRefundOrderResponse
   * @throws \Google\Service\Exception
   */
  public function refundorder($merchantId, $orderId, OrdersRefundOrderRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('refundorder', [$params], OrdersRefundOrderResponse::class);
  }
  /**
   * Rejects return on an line item. (orders.rejectreturnlineitem)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersRejectReturnLineItemRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersRejectReturnLineItemResponse
   * @throws \Google\Service\Exception
   */
  public function rejectreturnlineitem($merchantId, $orderId, OrdersRejectReturnLineItemRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('rejectreturnlineitem', [$params], OrdersRejectReturnLineItemResponse::class);
  }
  /**
   * Returns and refunds a line item. Note that this method can only be called on
   * fully shipped orders. The Orderreturns API is the preferred way to handle
   * returns after you receive a return from a customer. You can use
   * Orderreturns.list or Orderreturns.get to search for the return, and then use
   * Orderreturns.processreturn to issue the refund. If the return cannot be
   * found, then we recommend using this API to issue a refund.
   * (orders.returnrefundlineitem)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersReturnRefundLineItemRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersReturnRefundLineItemResponse
   * @throws \Google\Service\Exception
   */
  public function returnrefundlineitem($merchantId, $orderId, OrdersReturnRefundLineItemRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('returnrefundlineitem', [$params], OrdersReturnRefundLineItemResponse::class);
  }
  /**
   * Sets (or overrides if it already exists) merchant provided annotations in the
   * form of key-value pairs. A common use case would be to supply us with
   * additional structured information about a line item that cannot be provided
   * through other methods. Submitted key-value pairs can be retrieved as part of
   * the orders resource. (orders.setlineitemmetadata)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersSetLineItemMetadataRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersSetLineItemMetadataResponse
   * @throws \Google\Service\Exception
   */
  public function setlineitemmetadata($merchantId, $orderId, OrdersSetLineItemMetadataRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('setlineitemmetadata', [$params], OrdersSetLineItemMetadataResponse::class);
  }
  /**
   * Marks line item(s) as shipped. (orders.shiplineitems)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersShipLineItemsRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersShipLineItemsResponse
   * @throws \Google\Service\Exception
   */
  public function shiplineitems($merchantId, $orderId, OrdersShipLineItemsRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('shiplineitems', [$params], OrdersShipLineItemsResponse::class);
  }
  /**
   * Updates ship by and delivery by dates for a line item.
   * (orders.updatelineitemshippingdetails)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersUpdateLineItemShippingDetailsRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersUpdateLineItemShippingDetailsResponse
   * @throws \Google\Service\Exception
   */
  public function updatelineitemshippingdetails($merchantId, $orderId, OrdersUpdateLineItemShippingDetailsRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('updatelineitemshippingdetails', [$params], OrdersUpdateLineItemShippingDetailsResponse::class);
  }
  /**
   * Updates the merchant order ID for a given order.
   * (orders.updatemerchantorderid)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersUpdateMerchantOrderIdRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersUpdateMerchantOrderIdResponse
   * @throws \Google\Service\Exception
   */
  public function updatemerchantorderid($merchantId, $orderId, OrdersUpdateMerchantOrderIdRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('updatemerchantorderid', [$params], OrdersUpdateMerchantOrderIdResponse::class);
  }
  /**
   * Updates a shipment's status, carrier, and/or tracking ID.
   * (orders.updateshipment)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $orderId The ID of the order.
   * @param OrdersUpdateShipmentRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrdersUpdateShipmentResponse
   * @throws \Google\Service\Exception
   */
  public function updateshipment($merchantId, $orderId, OrdersUpdateShipmentRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'orderId' => $orderId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('updateshipment', [$params], OrdersUpdateShipmentResponse::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Orders::class, 'Google_Service_ShoppingContent_Resource_Orders');
