<?php
/*
 * Widget Name: Click to Media
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Click_to_Media_adnz4f24
 */
class Wdkit_Click_to_Media_adnz4f24 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-adnz4f24';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Click to Media', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-image-rollover';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Media Showcase','Interactive Media','Image Effects','Video Display','Click to Media');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        wp_enqueue_script( 'wd_ex_script_fffhjq25', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js', array(), '1.2.17.745486', true );


        wp_enqueue_script( 'wkit_child_script_fp6krt25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Click-to-Media_adnz4f24/Click_to_Media_adnz4f24.js', array(), '1.2.17.768753', true );

        return [ 'wkit_child_script_fp6krt25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_5hhmk825', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Click-to-Media_adnz4f24/Click_to_Media_adnz4f24.css', false, '1.2.17.204667', 'all' );

        return [ 'wkit_css_1_5hhmk825' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_jwby0b25 = new \Elementor\Repeater();

                $repeater_jwby0b25->add_control('select_f9bq4e24',
                array(
            
            'label' => esc_html__( 'Select Type', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'image',
            
            'options' => array( 'image'  => esc_html__( 'Image', 'wdesignkit' ),'video'  => esc_html__( 'Video', 'wdesignkit' ),'text'  => esc_html__( 'Text', 'wdesignkit' ),'url'  => esc_html__( 'Video URL', 'wdesignkit' ), ),
        )
            );
$repeater_jwby0b25->add_control('media_9n9zll24',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array("image"),
           
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_f9bq4e24', 'operator' => '==', 'value' => 'image'),
],
                ),
        )
            );
$repeater_jwby0b25->add_control('text_qvfw2f25',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Wdesignkit', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_f9bq4e24', 'operator' => '==', 'value' => 'text'),
],
                ),
        )
            );
$repeater_jwby0b25->add_control('color_mwf66o25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_f9bq4e24', 'operator' => '==', 'value' => 'text'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-container' => 'color: {{VALUE}}',),
        )
            );
$repeater_jwby0b25->add_control('url_j3vli925',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '',
                'is_external' => false,
                'nofollow' => false,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_f9bq4e24', 'operator' => '==', 'value' => 'url'),
],
                ),
        )
            );
$repeater_jwby0b25->add_control('rawhtml_natmds25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Enter embed Video URL.
</div>', 'wdesignkit' ),
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_f9bq4e24', 'operator' => '==', 'value' => 'url'),
],
                ),
        )
            );
$repeater_jwby0b25->add_control('media_ehqx9d24',
                array(
            
            'label' => esc_html__( 'Select Video', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/elementor/assets/images/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array("video"),
           
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_f9bq4e24', 'operator' => '==', 'value' => 'video'),
],
                ),
        )
            );

                
                $this->add_control('repeater_t2jmha24',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Media', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_jwby0b25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-mb8alt25'),
'select_f9bq4e24' => 'image',
'media_9n9zll24' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_qvfw2f25' => esc_html__('Wdesignkit', 'wdesignkit'), 
'color_mwf66o25' => '', 
'url_j3vli925' => '', 
'rawhtml_natmds25' => '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Enter embed Video URL.
</div>', 
'media_ehqx9d24' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/elementor/assets/images/placeholder.png', 
),
),
                
                     
                
        )
                );
$this->add_control('rawhtml_r0kwxt25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Refresh page to see latest media when apply new images & videos.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_03g7fx25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/click-to-media/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $rawhtml_r0kwxt25 = !empty($settings['rawhtml_r0kwxt25']) ? $this->wdk_senitize_js($settings['rawhtml_r0kwxt25']) : '';
$rawhtml_03g7fx25 = !empty($settings['rawhtml_03g7fx25']) ? $this->wdk_senitize_js($settings['rawhtml_03g7fx25']) : '';

        $repeater_t2jmha24_kk25 = '';
                            if ( $settings['repeater_t2jmha24'] ) {
                                foreach ( $settings['repeater_t2jmha24'] as $key => $r_item ) {
                                    $media_9n9zll24 = !empty($r_item['media_9n9zll24']['url']) ? $this->wdk_senitize_js($r_item['media_9n9zll24']['url']) : '';
$url_j3vli925_is_external = !empty($r_item['url_j3vli925']) && !empty($r_item['url_j3vli925']['is_external']) ? '_blank' : '';
$url_j3vli925_url = !empty($r_item['url_j3vli925']) && !empty($r_item['url_j3vli925']['url'])? $this->wdk_senitize_js($r_item['url_j3vli925']['url']) : '';
$url_j3vli925_nofollow = !empty($r_item['url_j3vli925']) && !empty($r_item['url_j3vli925']['nofollow'])? 'nofollow' : '';
$media_ehqx9d24 = !empty($r_item['media_ehqx9d24']['url']) ? $this->wdk_senitize_js($r_item['media_ehqx9d24']['url']) : '';

                                    $repeater_t2jmha24_kk25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' type-' . $this->wdk_senitize_js($r_item['select_f9bq4e24']) . ' media-item" data-repeater_t2jmha24="{repeater_t2jmha24}">
        <span class="image-url">'.$media_9n9zll24.'</span>
        <span class="video-url">'.$media_ehqx9d24.'</span>
         <span class="text" data-typo="{{typography_nk405j25}}" data-color="' . $r_item['color_mwf66o25'] . '">' . $this->wdk_senitize_js($r_item['text_qvfw2f25']) . '</span>
         <span class="external-url">'.$url_j3vli925_url.'</span>
    </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_adnz4f24" data-wdkitunique="adnz4f24">';
            $output .= '<div class="wkit-click-to-media">
    '.$repeater_t2jmha24_kk25.'
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}