<?php
/*
 * Widget Name: Gradient Stroke Text
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Gradient_Stroke_Text_1e0eyb23
 */
class Wdkit_Gradient_Stroke_Text_1e0eyb23 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-1e0eyb23';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Gradient Stroke Text', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-animated-headline';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Gradient','Animated','Stroke');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_dwyakg25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Gradient-Stroke-Text_1e0eyb23/Gradient_Stroke_Text_1e0eyb23.css', false, '1.2.17.322309', 'all' );

        return [ 'wkit_css_1_dwyakg25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_q6ba9v23',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'The Plus Addons for Elementor', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_kg2gpc23',
                array(
            
            'label' => esc_html__( 'Type', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'normal',
            
            'options' => array( 'normal'  => esc_html__( 'Normal', 'wdesignkit' ),'animated'  => esc_html__( 'Animated', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_4o5d2h23',
                array(
            
            'label' => esc_html__( 'Gradient', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'fill',
            
            'options' => array( 'fill'  => esc_html__( 'Fill', 'wdesignkit' ),'stroke'  => esc_html__( 'Stroke', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_bhx0d425',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/gradient-stroke-text/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('choose_3tehqu23',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .grad-stroke-text-inner' => 'text-align: {{VALUE}}',),
        )
            );
$this->add_responsive_control('slider_jkxnvz23',
                array(
            
            'label' => esc_html__( 'Stroke Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .grad-stroke-text' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_9gk5vp23',
                
                
                
                'selector' => '{{WRAPPER}} .grad-stroke-text',
			)
            );
$this->start_controls_tabs('normalhover_jmpyhm23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_jmpyhm23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_lfzu8j23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["gradient"],
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'normal'),
],
                ),
            'selector' => '{{WRAPPER}} .grad-stroke-text',
        )
            );
$this->add_control('color_tfmvtp23',
                array(
            
            'label' => esc_html__( 'Fill Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_4o5d2h23', 'operator' => '==', 'value' => 'stroke'),
],
                ),
            'selectors' => array('{{WRAPPER}} .grad-as-stroke .grad-stroke-text' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_24l5lb23',
                array(
            
            'label' => esc_html__( 'Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_4o5d2h23', 'operator' => '==', 'value' => 'fill'),
],
                ),
            'selectors' => array('{{WRAPPER}} .grad-as-fill .grad-stroke-text' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                    
        Group_Control_Text_Shadow::get_type(),
            array(
				'name' => 'textshadow_q8gik824',
                'label' => esc_html__( 'Text Shadow', 'wdesignkit' ),
                
                
                
				'selector' => '{{WRAPPER}} .grad-stroke-text',
			)
                );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_jmpyhm23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_wogx9y23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["gradient"],
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'normal'),
],
                ),
            'selector' => '{{WRAPPER}} .grad-stroke-text:hover',
        )
            );
$this->add_control('color_0m1wt023',
                array(
            
            'label' => esc_html__( 'Fill Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_4o5d2h23', 'operator' => '==', 'value' => 'stroke'),
],
                ),
            'selectors' => array('{{WRAPPER}} .grad-as-stroke .grad-stroke-text:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_lgxnxq23',
                array(
            
            'label' => esc_html__( 'Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_4o5d2h23', 'operator' => '==', 'value' => 'fill'),
],
                ),
            'selectors' => array('{{WRAPPER}} .grad-as-fill .grad-stroke-text:hover' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                    
        Group_Control_Text_Shadow::get_type(),
            array(
				'name' => 'textshadow_74zolz24',
                'label' => esc_html__( 'Text Shadow', 'wdesignkit' ),
                
                
                
				'selector' => '{{WRAPPER}} .grad-stroke-text:hover',
			)
                );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Animated Colors_style_secdddtion',
            [
                'label' => esc_html__( 'Animated Colors', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'],
],
                ),
            ]
        );
$this->start_controls_tabs('normalhover_o0h47125',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_o0h47125_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_90ky9123',
                array(
            
            'label' => esc_html__( 'Color 1', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text' => '--anicolor1: {{VALUE}}',),
        )
            );
$this->add_control('color_cohr5p23',
                array(
            
            'label' => esc_html__( 'Color 2', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text' => '--anicolor2: {{VALUE}}',),
        )
            );
$this->add_control('color_2rr6me23',
                array(
            
            'label' => esc_html__( 'Color 3', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text' => '--anicolor3: {{VALUE}}',),
        )
            );
$this->add_control('color_774bux23',
                array(
            
            'label' => esc_html__( 'Color 4', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text' => '--anicolor4: {{VALUE}}',),
        )
            );
$this->add_control('color_nbwwtw23',
                array(
            
            'label' => esc_html__( 'Color 5', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text' => '--anicolor5: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_o0h47125_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_x7tag823',
                array(
            
            'label' => esc_html__( 'Color 1', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text:hover' => '--anicolor1: {{VALUE}}',),
        )
            );
$this->add_control('color_xygt9b23',
                array(
            
            'label' => esc_html__( 'Color 2', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text:hover' => '--anicolor2: {{VALUE}}',),
        )
            );
$this->add_control('color_7aaz9623',
                array(
            
            'label' => esc_html__( 'Color 3', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text:hover' => '--anicolor3: {{VALUE}}',),
        )
            );
$this->add_control('color_m791k923',
                array(
            
            'label' => esc_html__( 'Color 4', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text:hover' => '--anicolor4: {{VALUE}}',),
        )
            );
$this->add_control('color_btontx23',
                array(
            
            'label' => esc_html__( 'Color 5', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_kg2gpc23', 'operator' => '==', 'value' => 'animated'),
],
                ),
            'selectors' => array('{{WRAPPER}} .text-gradient-animated .grad-stroke-text:hover' => '--anicolor5: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $text_q6ba9v23 = !empty($settings['text_q6ba9v23']) ? $this->wdk_senitize_js($settings['text_q6ba9v23']) : '';
$select_kg2gpc23 = !empty($settings['select_kg2gpc23']) ? $this->wdk_senitize_js($settings['select_kg2gpc23']) : '';
$select_4o5d2h23 = !empty($settings['select_4o5d2h23']) ? $this->wdk_senitize_js($settings['select_4o5d2h23']) : '';
$rawhtml_bhx0d425 = !empty($settings['rawhtml_bhx0d425']) ? $this->wdk_senitize_js($settings['rawhtml_bhx0d425']) : '';

        

        $output = '';
        $output .= '<div class="wkit-wb-Widget_1e0eyb23" data-wdkitunique="1e0eyb23">';
            $output .= '<div class="wkit-grad-stroke-text text-gradient-'.$select_kg2gpc23.' grad-as-'.$select_4o5d2h23.'">
    <div class="grad-stroke-text-inner">
        <span class="grad-stroke-text">'.$text_q6ba9v23.'</span>
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}