<?php
/*
 * Widget Name: Post Meta
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Post_Meta_apvpbn25
 */
class Wdkit_Post_Meta_apvpbn25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-apvpbn25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Post Meta', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-editor-link';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('WDesignKit');
    }

    

    

    

    

    

    

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        
        

        $output = '';
        $output .= '<div class="wkit-wb-Widget_apvpbn25" data-wdkitunique="apvpbn25">';
            $output .= '';
        $output .= '</div>';
        
        echo $output;
    }
}