(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                const rippleItem = $scope[0].querySelector("#wkit-rippleEffect");
function getResponsiveAttr(attrBase) {
  const width = window.innerWidth;
  if (width <= 767) {
    return rippleItem.getAttribute(`data-mobile${attrBase}`) || null;
  } else if (width <= 1024) {
    return rippleItem.getAttribute(`data-tab${attrBase}`) || null;
  } else {
    return rippleItem.getAttribute(`data-desk${attrBase}`) || null;
  }
}

function createRipple({
  container,
  mainCircleSize = 210,
  mainCircleOpacity = 0.24,
  numCircles = 8,
  rippleDuration = 2,
  rippleColor = "rgba(0, 0, 0, 0.25)",
  rippleBackground,
  maskGradient = "linear-gradient(circle at center, white, transparent)",
  topSet = "50%",
  leftSet = "50%",
  borderWidth = "1px",
  borderColor = "#fff",
  color2 = "",
  gapBetweenCircles = 70
}) {
  if (!container) return;

  let rippleWrapper = container.querySelector(".wkit-ripple-container");

  if (!rippleWrapper) {
    rippleWrapper = document.createElement("div");
    rippleWrapper.classList.add("wkit-ripple-container");

    Object.assign(rippleWrapper.style, {
      position: "absolute",
      inset: "0",
      pointerEvents: "none",
      maskImage: maskGradient,
      WebkitMaskImage: maskGradient,
      overflow: "hidden",
    });

    const rippleCrop = document.createElement("div");
    rippleCrop.classList.add("wkit-ripple-crop");

    Object.assign(rippleCrop.style, {
      padding: "100%",
      position: "absolute",
      top: topSet || "50%",
      left: leftSet || "50%",
      transform: "translate(-50%, -50%)",
      height: "100%",
      width: "100%",
      overflow: "hidden",
    });

    rippleWrapper.appendChild(rippleCrop);
    container.appendChild(rippleWrapper);
  } else {
    const rippleCrop = rippleWrapper.querySelector(".wkit-ripple-crop");
    if (rippleCrop) rippleCrop.innerHTML = "";
  }

  const rippleCropEl = rippleWrapper.querySelector(".wkit-ripple-crop");

  for (let i = 0; i < numCircles; i++) {
    const ripple = document.createElement("div");
    ripple.classList.add("ripple-circle");

    const isLast = i === numCircles - 1;
    const spreadValueRaw = rippleItem.getAttribute("data-boxshadow");

    let shadowColor;
    if (rippleBackground && color2 && color2 !== "transparent") {
      shadowColor = color2;
    } else {
      shadowColor = rippleColor;
    }

    const spreadValue = !isNaN(parseFloat(spreadValueRaw))
      ? `${parseFloat(spreadValueRaw)}px`
      : "70px";
    const Blurvalue = `${parseFloat(spreadValue) * 0.5}px`;
    const shadowValue = isLast
      ? `0 0 ${Blurvalue} ${spreadValue} ${shadowColor}`
      : "none";

    Object.assign(ripple.style, {
      position: "absolute",
      top: "50%",
      left: "50%",
      transform: "translate(-50%, -50%) scale(1)",
      borderRadius: "50%",
      width: `${mainCircleSize + i * gapBetweenCircles}px`,
      height: `${mainCircleSize + i * gapBetweenCircles}px`,
      opacity: Math.max(0, mainCircleOpacity - i * 0.03),
      animation: `rippleAnimation ${rippleDuration}s ease infinite`,
      animationDelay: `${i * 0.06}s`,

      backgroundColor: rippleColor,
      backgroundImage: rippleBackground || "none",
      borderStyle: "solid",
      borderWidth: borderWidth,
      borderColor: borderColor,
      boxShadow: shadowValue,
    });

    rippleCropEl.appendChild(ripple); 
  }
}

function applyRippleEffect() {
    if (!rippleItem) return;
  const targetId = rippleItem.getAttribute("data-id");
  const applyTo = rippleItem.getAttribute("data-apply");
  let targetElement = rippleItem.closest(".e-con");

  const sectionEl = rippleItem.closest(".elementor-section");
  if (applyTo === "section" && sectionEl) {
    targetElement = sectionEl;
  }
  if (applyTo === "custom" && targetId) {
    const customEl =
      document.getElementById(targetId) ||
      document.querySelector(`[data-id="${targetId}"]`);
    if (customEl) {
      targetElement = customEl;
    }
  }
if (!targetElement) return;
  const existingWrapper = targetElement.querySelector(".wkit-ripple-container");
  if (existingWrapper) existingWrapper.remove();

  const mainCircleSize = parseInt(getResponsiveAttr("mainsize"), 10) || 210;
  const numCircles = parseInt(getResponsiveAttr("count"), 10) || 8;
  const topSetVal = parseFloat(getResponsiveAttr("topset"));
  const leftSetVal = parseFloat(getResponsiveAttr("leftset"));
  const gapBetweenCircles =
  parseFloat(rippleItem.getAttribute("data-gap")) || 70;
  const topSet = !isNaN(topSetVal) ? `${topSetVal}%` : "50%";
  const leftSet = !isNaN(leftSetVal) ? `${leftSetVal}%` : "50%";
  const mainCircleOpacity =
    parseFloat(rippleItem.getAttribute("data-opacity")) || 0.24;
  const borderWidthValue = parseFloat(rippleItem.getAttribute("data-border"));
  const borderWidth = !isNaN(borderWidthValue)
    ? `${borderWidthValue}px`
    : "1px";
  const borderColor = rippleItem.getAttribute("data-bdrcolor") || "transparent"; 
  const rippleDuration =
    parseFloat(rippleItem.getAttribute("data-duration")) || 2;
  const rippleColor =
    rippleItem.getAttribute("data-color") || "rgba(0, 0, 0, 0.25)";
  const color1 = rippleItem.getAttribute("data-background1") || "transparent";
  const color2 = rippleItem.getAttribute("data-background2") || "transparent";
  const maskGradient = "linear-gradient(circle at center, yellow, transparent)";
  const isGradientValid = color1 !== "" || color2 !== "";
  const gradient = isGradientValid
    ? `radial-gradient(circle, ${color1}, ${color2})`
    : null;

  createRipple({
    container: targetElement,
    mainCircleSize,
    mainCircleOpacity,
    numCircles,
    rippleDuration,
    rippleColor,
    rippleBackground: gradient,
    maskGradient,
    topSet,
    leftSet,
    borderWidth,
    borderColor,
    color2,
    gapBetweenCircles
  });
}
applyRippleEffect();
let resizeTimeout;
window.addEventListener("resize", () => {
  clearTimeout(resizeTimeout);
  resizeTimeout = setTimeout(() => {
    applyRippleEffect();
  }, 250);
});
  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-5b0mis25.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);