<?php
/*
 * Widget Name: Ripple Background
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Ripple_Background_5b0mis25
 */
class Wdkit_Ripple_Background_5b0mis25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-5b0mis25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Ripple Background', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-barcode';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('ripple background','animated background','section effects');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_ky1jyd25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Ripple-Background_5b0mis25/Ripple_Background_5b0mis25.js', array(), '1.2.17.560493', true );

        return [ 'wkit_child_script_ky1jyd25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_yx72vz25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Ripple-Background_5b0mis25/Ripple_Background_5b0mis25.css', false, '1.2.17.329425', 'all' );

        return [ 'wkit_css_1_yx72vz25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_bt3pet25',
                array(
            
            'label' => esc_html__( 'Apply effect to', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'container',
            
            'options' => array( 'container'  => esc_html__( 'Container', 'wdesignkit' ),'section'  => esc_html__( 'Section', 'wdesignkit' ),'custom'  => esc_html__( 'Custom ID', 'wdesignkit' ), ),
        )
            );
$this->add_control('text_qr1sgr25',
                array(
            
            'label' => esc_html__( 'Custom CSS ID', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_bt3pet25', 'operator' => '==', 'value' => 'custom'),
],
                ),
        )
            );
$this->add_control('rawhtml_am12mu25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Enter custom css ID without #, . etc. symbol.
</div>', 'wdesignkit' ),
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_bt3pet25', 'operator' => '==', 'value' => 'custom'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Circle Size_tab_content',
            [
                'label' => esc_html__( 'Circle Size', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('number_tqadpo25',
                array(
            
            'label' => esc_html__( 'Size (Desktop)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 500,
            'step' => 10,
            'default' => 210,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_g0aqin25',
                array(
            
            'label' => esc_html__( 'Size (Tablet)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 500,
            'step' => 10,
            'default' => 100,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_08af0f25',
                array(
            
            'label' => esc_html__( 'Size (Mobile)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 500,
            'step' => 10,
            'default' => 100,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('rawhtml_uiome125',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Set circle size for different screen size.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Circles Quantity_tab_content',
            [
                'label' => esc_html__( 'Circles Quantity', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('number_1rljnz25',
                array(
            
            'label' => esc_html__( 'Quantity (Desktop)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 15,
            'step' => 1,
            'default' => 8,
            
            
            
            
            'separator' => 'before',
            
            
            
            
        )
            );
$this->add_control('number_gt663625',
                array(
            
            'label' => esc_html__( 'Quantity (Tablet)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 15,
            'step' => 1,
            'default' => 5,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_ve1wyn25',
                array(
            
            'label' => esc_html__( 'Quantity (Mobile)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 15,
            'step' => 1,
            'default' => 5,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('rawhtml_6ihvwi25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Set number of circles for different screen size.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Circle Style_tab_content',
            [
                'label' => esc_html__( 'Circle Style', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('color_yz4ayw25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_ibaahm25', 'operator' => '!=', 'value' => 'yes'),
],
                ),
            
        )
            );
$this->add_control('switcher_ibaahm25',
                array(
            
            'label' => esc_html__( 'Gradient Color', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('color_mdmcxo25',
                array(
            
            'label' => esc_html__( 'Color 1', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_ibaahm25', 'operator' => '==', 'value' => 'yes'),
],
                ),
            
        )
            );
$this->add_control('color_lbirtd25',
                array(
            
            'label' => esc_html__( 'Color 2', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_ibaahm25', 'operator' => '==', 'value' => 'yes'),
],
                ),
            
        )
            );
$this->add_control('number_d3bel825',
                array(
            
            'label' => esc_html__( 'Border Width', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 0.1,
            'default' => 0,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('color_xp972i25',
                array(
            
            'label' => esc_html__( 'Border Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            
        )
            );
$this->add_control('number_6uzu8g25',
                array(
            
            'label' => esc_html__( 'Shadow Spread', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 500,
            'step' => 1,
            'default' => 70,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_6y5e8525',
                array(
            
            'label' => esc_html__( 'Circles Gap', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 70,
            
            
            
            
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Offset_tab_content',
            [
                'label' => esc_html__( 'Offset', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('number_rhj0c225',
                array(
            
            'label' => esc_html__( 'Top Offset (Desktop)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => -100,
            'max' => 100,
            'step' => 1,
            'default' => 50,
            
            
            
            
            'separator' => 'before',
            
            
            
            
        )
            );
$this->add_control('number_vc7s1d25',
                array(
            
            'label' => esc_html__( 'Top Offset (Tablet)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => -100,
            'max' => 100,
            'step' => 1,
            'default' => 50,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_becy3i25',
                array(
            
            'label' => esc_html__( 'Top Offset (Mobile)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => -100,
            'max' => 100,
            'step' => 1,
            'default' => 50,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_jg2qzw25',
                array(
            
            'label' => esc_html__( 'Left Offset (Desktop)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => -100,
            'max' => 100,
            'step' => 1,
            'default' => 50,
            
            
            
            
            'separator' => 'before',
            
            
            
            
        )
            );
$this->add_control('number_64tvbk25',
                array(
            
            'label' => esc_html__( 'Left Offset (Tablet)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => -100,
            'max' => 100,
            'step' => 1,
            'default' => 50,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_ijqen125',
                array(
            
            'label' => esc_html__( 'Left Offset (Mobile)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => -100,
            'max' => 100,
            'step' => 1,
            'default' => 50,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('rawhtml_zebe9e25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Set position for different screen size.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Circle Animation_tab_content',
            [
                'label' => esc_html__( 'Circle Animation', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('number_d19cpq25',
                array(
            
            'label' => esc_html__( 'Opacity', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1,
            'step' => 0.03,
            'default' => 0.24,
            
            
            
            
            'separator' => 'before',
            
            
            
            
        )
            );
$this->add_control('number_sdc7fu25',
                array(
            
            'label' => esc_html__( 'Duration', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 2,
            
            
            
            
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_0zuhkk25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/ripple-background/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_bt3pet25 = !empty($settings['select_bt3pet25']) ? $settings['select_bt3pet25'] : '';
$text_qr1sgr25 = !empty($settings['text_qr1sgr25']) ? $this->wdk_senitize_js($settings['text_qr1sgr25']) : '';
$rawhtml_am12mu25 = !empty($settings['rawhtml_am12mu25']) ? $this->wdk_senitize_js($settings['rawhtml_am12mu25']) : '';
$number_tqadpo25 = isset($settings['number_tqadpo25']) ? $settings['number_tqadpo25'] : '';
$number_g0aqin25 = isset($settings['number_g0aqin25']) ? $settings['number_g0aqin25'] : '';
$number_08af0f25 = isset($settings['number_08af0f25']) ? $settings['number_08af0f25'] : '';
$rawhtml_uiome125 = !empty($settings['rawhtml_uiome125']) ? $this->wdk_senitize_js($settings['rawhtml_uiome125']) : '';
$number_1rljnz25 = isset($settings['number_1rljnz25']) ? $settings['number_1rljnz25'] : '';
$number_gt663625 = isset($settings['number_gt663625']) ? $settings['number_gt663625'] : '';
$number_ve1wyn25 = isset($settings['number_ve1wyn25']) ? $settings['number_ve1wyn25'] : '';
$rawhtml_6ihvwi25 = !empty($settings['rawhtml_6ihvwi25']) ? $this->wdk_senitize_js($settings['rawhtml_6ihvwi25']) : '';
$color_yz4ayw25 = !empty($settings['color_yz4ayw25']) ? $settings['color_yz4ayw25'] : '';
$switcher_ibaahm25 = !empty($settings['switcher_ibaahm25']) ? $settings['switcher_ibaahm25'] : '';
$color_mdmcxo25 = !empty($settings['color_mdmcxo25']) ? $settings['color_mdmcxo25'] : '';
$color_lbirtd25 = !empty($settings['color_lbirtd25']) ? $settings['color_lbirtd25'] : '';
$number_d3bel825 = isset($settings['number_d3bel825']) ? $settings['number_d3bel825'] : '';
$color_xp972i25 = !empty($settings['color_xp972i25']) ? $settings['color_xp972i25'] : '';
$number_6uzu8g25 = isset($settings['number_6uzu8g25']) ? $settings['number_6uzu8g25'] : '';
$number_6y5e8525 = isset($settings['number_6y5e8525']) ? $this->wdk_senitize_js($settings['number_6y5e8525']) : '';
$number_rhj0c225 = isset($settings['number_rhj0c225']) ? $settings['number_rhj0c225'] : '';
$number_vc7s1d25 = isset($settings['number_vc7s1d25']) ? $settings['number_vc7s1d25'] : '';
$number_becy3i25 = isset($settings['number_becy3i25']) ? $settings['number_becy3i25'] : '';
$number_jg2qzw25 = isset($settings['number_jg2qzw25']) ? $settings['number_jg2qzw25'] : '';
$number_64tvbk25 = isset($settings['number_64tvbk25']) ? $settings['number_64tvbk25'] : '';
$number_ijqen125 = isset($settings['number_ijqen125']) ? $settings['number_ijqen125'] : '';
$rawhtml_zebe9e25 = !empty($settings['rawhtml_zebe9e25']) ? $this->wdk_senitize_js($settings['rawhtml_zebe9e25']) : '';
$number_d19cpq25 = isset($settings['number_d19cpq25']) ? $settings['number_d19cpq25'] : '';
$number_sdc7fu25 = isset($settings['number_sdc7fu25']) ? $settings['number_sdc7fu25'] : '';
$rawhtml_0zuhkk25 = !empty($settings['rawhtml_0zuhkk25']) ? $this->wdk_senitize_js($settings['rawhtml_0zuhkk25']) : '';

        

        $output = '';
        $output .= '<div class="wkit-wb-Widget_5b0mis25" data-wdkitunique="5b0mis25">';
            $output .= '<div id="wkit-rippleEffect" data-id="'.$text_qr1sgr25.'" data-apply="'.$select_bt3pet25.'" data-deskmainsize="'.$number_tqadpo25.'" data-tabmainsize="'.$number_g0aqin25.'" data-mobilemainsize="'.$number_08af0f25.'" data-opacity="'.$number_d19cpq25.'" data-deskcount="'.$number_1rljnz25.'" data-tabcount="'.$number_gt663625.'" data-mobilecount="'.$number_ve1wyn25.'" data-gap="'.$number_6y5e8525.'" data-border="'.$number_d3bel825.'" data-bdrcolor="'.$color_xp972i25.'" data-duration="'.$number_sdc7fu25.'" data-color="'.$color_yz4ayw25.'" data-boxshadow="'.$number_6uzu8g25.'" data-background1="'.$color_mdmcxo25.'" data-background2="'.$color_lbirtd25.'" data-desktopset="'.$number_rhj0c225.'" data-tabtopset="'.$number_vc7s1d25.'" data-mobiletopset="'.$number_becy3i25.'" data-deskleftset="'.$number_jg2qzw25.'" data-tableftset="'.$number_64tvbk25.'" data-mobileleftset="'.$number_ijqen125.'">
</div>



';
        $output .= '</div>';
        
        echo $output;
    }
}