<?php
/*
 * Widget Name: Tag Cloud
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Tag_Cloud_jrzbqz25
 */
class Wdkit_Tag_Cloud_jrzbqz25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-jrzbqz25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Tag Cloud', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-tags';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Tag Widget','Keyword Cloud','Elementor Tags','Blog Navigation','Visual Tags','SEO Tools','WordPress Tag Cloud');
    }

    
        /**
        * Get dynamic listing data as per query.
        *
        * @since 1.0.38
        */
        private function set_options($type){
            $ctp = [];

            if(class_exists('Wdkit_Dynamic_Listing_Files')){
                $wdkit_widget = new Wdkit_Dynamic_Listing_Files();
                
                if('post_list' == $type){
                    if ( method_exists($wdkit_widget, 'Get_post_list')) {
                        $ctp = $wdkit_widget->Get_post_list();
                    }
                } else if ('order_by' == $type){    
                    if (method_exists($wdkit_widget, 'Get_orderBy_List')) {
                        $ctp = $wdkit_widget->Get_orderBy_List();
                    }
                }
            }

            $cpt_array = array();

            foreach ($ctp as $key => $value) {
                $cpt_array[$value['name']] = $value['label'];
            }

            return $cpt_array;
        }
    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    
        
        /**
         * Get all posts from wordpress.
         *
         * @since 1.0.36
         */
        private function get_taxonomy_list( $taxo_type, $post_type, $per_page ) {
            
            $terms = [];

            $taxoomy_list = !empty( get_object_taxonomies( $post_type ) ) ? get_object_taxonomies( $post_type ) : [];
            if ( !in_array($taxo_type, $taxoomy_list) ) {
                return [];
            }
            
            // Query arguments
            $terms = get_terms( array(
                'taxonomy' => $taxo_type,
                'hide_empty' => false,
                'number' => $per_page,
            ) );

            foreach ($terms as $key => $value) {
                $term_link = get_term_link( $value );
                $term_image_id = get_term_meta( $value->term_id );
                
                if ( !empty($term_link) ) {
                    $terms[$key]->front_link = $term_link;
                } else {
                    $terms[$key]->front_link = '';
                }
                
                if ( !empty($term_image_id['thumbnail_id'][0]) ) {
                    $img_id = $term_image_id['thumbnail_id'][0];
                    $thumbnail_img = wp_get_attachment_url($img_id);
                    $terms[$key]->thumbnail = $thumbnail_img;
                } else {
                    $terms[$key]->thumbnail = '';
                }
            }

            $terms = json_decode(json_encode($terms), true);

            return $terms;
        }

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        wp_enqueue_script( 'wd_ex_script_zjknzi25', 'https://cdn.jsdelivr.net/npm/wordcloud@1.2.2/src/wordcloud2.min.js', array(), '1.2.17.816530', true );


        wp_enqueue_script( 'wkit_child_script_x58jmn25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Tag-Cloud_jrzbqz25/Tag_Cloud_jrzbqz25.js', array(), '1.2.17.430861', true );

        return [ 'wkit_child_script_x58jmn25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_x32wa425', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Tag-Cloud_jrzbqz25/Tag_Cloud_jrzbqz25.css', false, '1.2.17.175554', 'all' );

        return [ 'wkit_css_1_x32wa425' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_127um725',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'style-1',
            
            'options' => array( 'style-1'  => esc_html__( 'Style 1', 'wdesignkit' ),'style-2'  => esc_html__( 'Style 2', 'wdesignkit' ),'style-3'  => esc_html__( 'Style 3', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_6rvtw725',
                array(
            
            'label' => esc_html__( 'Content Type', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'post',
            
            'options' => array( 'post'  => esc_html__( 'Post', 'wdesignkit' ),'repeater'  => esc_html__( 'Repeater', 'wdesignkit' ), ),
        )
            );

        $this->add_control('taxonomy_2fgvsd25',
            array(
                'label' => esc_html__( 'Taxonomy', 'wdesignkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => get_taxonomies(),
                'default' => 'category',
                
                
                
                
                
                
            )
        );

        
        $this->add_control('post_type_2fgvsd25',
                array(
            
            'label' => esc_html__( 'Post Type', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'select type',
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_6rvtw725', 'operator' => '==', 'value' => 'post'),
],
                ),
            'options' => $this->set_options("post_list"),
        )
            );
$this->add_control('max_post_2fgvsd25',
                array(
            
            'label' => esc_html__( 'Max Post', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 10,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_6rvtw725', 'operator' => '==', 'value' => 'post'),
],
                ),
            
        )
            );
$this->add_control('rawhtml_miysp725',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: The Taxonomy option will work only when you select "Post" as the Content Type.
</div>', 'wdesignkit' ),
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_6rvtw725', 'operator' => '==', 'value' => 'repeater'),
],
                ),
        )
            );
$repeater_2h10bl25 = new \Elementor\Repeater();

                $repeater_2h10bl25->add_control('select_2wcrpg25',
                array(
            
            'label' => esc_html__( 'Icon', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'none',
            
            'options' => array( 'none'  => esc_html__( 'None', 'wdesignkit' ),'icon'  => esc_html__( 'Icon', 'wdesignkit' ),'image'  => esc_html__( 'Image', 'wdesignkit' ), ),
        )
            );
$repeater_2h10bl25->add_control('iconscontrol_s2tk4e25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-tag',
                'library' => 'fa-solid',
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_2wcrpg25', 'operator' => '==', 'value' => 'icon'),
],
                ),
        )
            );
$repeater_2h10bl25->add_control('media_ebqwas25',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array(),
           
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_2wcrpg25', 'operator' => '==', 'value' => 'image'),
],
                ),
        )
            );
$repeater_2h10bl25->add_control('rawhtml_0q2v8y25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: In Style 3, icons and images are not displayed.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('text_pdn9p925',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Digital', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_2h10bl25->add_control('url_7xacyr25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('heading_3ks17525',
                array(
            
            'label' => esc_html__( 'Style 1 & Style 2 Options', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_2h10bl25->add_control('number_jw09k725',
                array(
            
            'label' => esc_html__( 'Desktop Font Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => "",
            
            
            
            
            
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('number_q3jjyh25',
                array(
            
            'label' => esc_html__( 'Tablet Font Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => "",
            
            
            
            
            
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('number_o2fjzi25',
                array(
            
            'label' => esc_html__( 'Mobile Font Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => "",
            
            
            
            
            
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('color_v5l0eh25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}',),
        )
            );
$repeater_2h10bl25->add_control('color_tph2u825',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_2wcrpg25', 'operator' => '==', 'value' => 'icon'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$repeater_2h10bl25->add_control('color_1qlxvr25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_2wcrpg25', 'operator' => '==', 'value' => 'icon'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .tp-title-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$repeater_2h10bl25->add_control('color_ro8ewr25',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}}' => 'background-color: {{VALUE}}',),
        )
            );
$repeater_2h10bl25->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_2gzrb225',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
        )
            );
$repeater_2h10bl25->add_control('heading_8uvalc25',
                array(
            
            'label' => esc_html__( 'Style 3 Option', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$repeater_2h10bl25->add_control('number_yv3po925',
                array(
            
            'label' => esc_html__( 'Desktop Font Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 200,
            'step' => 1,
            'default' => 30,
            
            
            
            
            
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('number_owckpz25',
                array(
            
            'label' => esc_html__( 'Tablet Font Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 200,
            'step' => 1,
            'default' => 20,
            
            
            
            
            
            
            
            
            
        )
            );
$repeater_2h10bl25->add_control('number_bcd7d925',
                array(
            
            'label' => esc_html__( 'Mobile Font Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 200,
            'step' => 1,
            'default' => 12,
            
            
            
            
            
            
            
            
            
        )
            );

                
                $this->add_control('repeater_oud5jv25',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Tags', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_2h10bl25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-t02ezp25'),
'select_2wcrpg25' => 'none',
'iconscontrol_s2tk4e25' => 'fas fa-tag', 
'media_ebqwas25' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'rawhtml_0q2v8y25' => '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: In Style 3, icons and images are not displayed.
</div>', 
'text_pdn9p925' => esc_html__('Digital', 'wdesignkit'), 
'url_7xacyr25' => '#', 
'heading_3ks17525' => esc_html__('', 'wdesignkit'), 
'number_jw09k725' => esc_html__('', 'wdesignkit'), 
'number_q3jjyh25' => esc_html__('', 'wdesignkit'), 
'number_o2fjzi25' => esc_html__('', 'wdesignkit'), 
'color_v5l0eh25' => '', 
'color_tph2u825' => '', 
'color_1qlxvr25' => '', 
'color_ro8ewr25' => '', 
'border_2gzrb225' => '', 
'heading_8uvalc25' => esc_html__('', 'wdesignkit'), 
'number_yv3po925' => esc_html__('30', 'wdesignkit'), 
'number_owckpz25' => esc_html__('20', 'wdesignkit'), 
'number_bcd7d925' => esc_html__('12', 'wdesignkit'), 
),
),
                
                     
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_6rvtw725', 'operator' => '==', 'value' => 'repeater'),
],
                ),
        )
                );
$this->end_controls_section();$this->start_controls_section('Column_tab_content',
            [
                'label' => esc_html__( 'Column', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'],
],
                ),
            ]
        );
$this->add_control('select_g9ka1n25',
                array(
            
            'label' => esc_html__( 'Desktop Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'column-6',
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'options' => array( 'column-6'  => esc_html__( 'Column 6', 'wdesignkit' ),'column-5'  => esc_html__( 'Column 5', 'wdesignkit' ),'column-4'  => esc_html__( 'Column 4', 'wdesignkit' ),'column-3'  => esc_html__( 'Column 3', 'wdesignkit' ),'column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'column-1'  => esc_html__( 'Column 1', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_s9ljbr25',
                array(
            
            'label' => esc_html__( 'Tablet Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'tablet-column-3',
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'options' => array( 'tablet-column-3'  => esc_html__( 'Column 3', 'wdesignkit' ),'tablet-column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'tablet-column-1'  => esc_html__( 'Column 1', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_ujak8p25',
                array(
            
            'label' => esc_html__( 'Mobile Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'mobile-column-2',
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'options' => array( 'mobile-column-3'  => esc_html__( 'Column 3', 'wdesignkit' ),'mobile-column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'mobile-column-1'  => esc_html__( 'Column 1', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Canvas Size_tab_content',
            [
                'label' => esc_html__( 'Canvas Size', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'],
],
                ),
            ]
        );
$this->add_control('number_xy24fa25',
                array(
            
            'label' => esc_html__( 'Desktop Canvas Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1500,
            'step' => 1,
            'default' => 500,
            
            
            
            
            'separator' => 'before',
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('number_jt2cng25',
                array(
            
            'label' => esc_html__( 'Tablet Canvas Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1000,
            'step' => 1,
            'default' => 400,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('number_81ovur25',
                array(
            
            'label' => esc_html__( 'Mobile Canvas Size', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1000,
            'step' => 1,
            'default' => 300,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Special Options_tab_content',
            [
                'label' => esc_html__( 'Special Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'],
],
                ),
            ]
        );
$this->add_control('number_nfkc5325',
                array(
            
            'label' => esc_html__( 'Desktop Gap', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 10,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('number_arogwl25',
                array(
            
            'label' => esc_html__( 'Tablet Gap', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 7,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('number_bg6uha25',
                array(
            
            'label' => esc_html__( 'Mobile Gap', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 5,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('number_8nsi7u25',
                array(
            
            'label' => esc_html__( 'Rotate Ratio', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1,
            'step' => 0.1,
            'default' => 0.5,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('number_zqf58a25',
                array(
            
            'label' => esc_html__( 'Rotate Steps', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 10,
            'step' => 1,
            'default' => 4,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('rawhtml_bwcqst25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note : Some Style-3 responsive options may not work correctly in the Elementor editor. Please check the live page for accurate responsiveness.
</div>', 'wdesignkit' ),
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_responsive_control('slider_oirofu25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            'separator' => 'before',
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-cloud .wdk-tag-repeater, {{WRAPPER}} .wkit-tag-cloud .wdk-tag-post' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_w1yj0725',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->add_control('select_xhl10p25',
                array(
            
            'label' => esc_html__( 'Color Scheme', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'random-light',
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            'options' => array( 'random-light'  => esc_html__( 'Random Light', 'wdesignkit' ),'random-dark'  => esc_html__( 'Random Dark', 'wdesignkit' ),'custom'  => esc_html__( 'Custom', 'wdesignkit' ), ),
        )
            );
$this->add_control('color_c9ndjl25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'and',
                    'terms' => [array('name' => 'select_xhl10p25', 'operator' => '==', 'value' => 'custom'),
array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_uzo65b25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/tag-cloud/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_vgw9iy25',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_rcamrd25',
                
                
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
                'selector' => '{{WRAPPER}} .wkit-tag-item',
			)
            );
$this->start_controls_tabs('normalhover_onl1qg25',
                array(
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
        )
            );
            $this->start_controls_tab(

                        'normalhover_onl1qg25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_dhaw6d25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_8n30vq25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selector' => '{{WRAPPER}} .wkit-tag-item',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_br8kp425',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selector' => '{{WRAPPER}} .wkit-tag-item',
        )
            );
$this->add_responsive_control('dimension_ccta1h25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_dj8qw825',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selector' => '{{WRAPPER}} .wkit-tag-item', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_onl1qg25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_cr2jbk25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_30tvpt25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selector' => '{{WRAPPER}} .wkit-tag-item:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_9rg9j925',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selector' => '{{WRAPPER}} .wkit-tag-item:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_w4df1k25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selector' => '{{WRAPPER}} .wkit-tag-item:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_s8ob3q25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note : There are no settings here for style 3.
</div>', 'wdesignkit' ),
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-3'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Icon_style_secdddtion',
            [
                'label' => esc_html__( 'Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'],
],
                ),
            ]
        );
$this->add_responsive_control('slider_v5k7jj25',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","em", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'em' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_1ffy2325',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","em", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'em' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-icon  svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_hhmym025',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_hhmym025_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_hy5bmu25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item .wkit-tag-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_284u4z25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item .wkit-tag-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_12923825',
                array(
            
            'label' => esc_html__( 'Arrow Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .style-2 .wkit-tag-item::before' => 'border-right-color: {{VALUE}}',),
        )
            );
$this->add_control('color_lewzfo25',
                array(
            
            'label' => esc_html__( 'Dot Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .style-2 .wkit-tag-item::after' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_hhmym025_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_gh6ewu25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item:hover .wkit-tag-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_p070e325',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item:hover .wkit-tag-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_cqzn2m25',
                array(
            
            'label' => esc_html__( 'Arrow Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item:hover::before' => 'border-right-color: {{VALUE}}',),
        )
            );
$this->add_control('color_j5ynso25',
                array(
            
            'label' => esc_html__( 'Dot Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-item:hover::after' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Image_style_secdddtion',
            [
                'label' => esc_html__( 'Image', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'],
],
                ),
            ]
        );
$this->add_responsive_control('slider_gmha2025',
                array(
            
            'label' => esc_html__( 'Image Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","em", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'em' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_127um725', 'operator' => '!=', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-tag-img' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_127um725 = !empty($settings['select_127um725']) ? $this->wdk_senitize_js($settings['select_127um725']) : '';
$select_6rvtw725 = !empty($settings['select_6rvtw725']) ? $this->wdk_senitize_js($settings['select_6rvtw725']) : '';
$rawhtml_miysp725 = !empty($settings['rawhtml_miysp725']) ? $this->wdk_senitize_js($settings['rawhtml_miysp725']) : '';
$select_g9ka1n25 = !empty($settings['select_g9ka1n25']) ? $settings['select_g9ka1n25'] : '';
$select_s9ljbr25 = !empty($settings['select_s9ljbr25']) ? $settings['select_s9ljbr25'] : '';
$select_ujak8p25 = !empty($settings['select_ujak8p25']) ? $settings['select_ujak8p25'] : '';
$number_xy24fa25 = isset($settings['number_xy24fa25']) ? $settings['number_xy24fa25'] : '';
$number_jt2cng25 = isset($settings['number_jt2cng25']) ? $settings['number_jt2cng25'] : '';
$number_81ovur25 = isset($settings['number_81ovur25']) ? $settings['number_81ovur25'] : '';
$number_nfkc5325 = isset($settings['number_nfkc5325']) ? $settings['number_nfkc5325'] : '';
$number_arogwl25 = isset($settings['number_arogwl25']) ? $settings['number_arogwl25'] : '';
$number_bg6uha25 = isset($settings['number_bg6uha25']) ? $settings['number_bg6uha25'] : '';
$number_8nsi7u25 = isset($settings['number_8nsi7u25']) ? $settings['number_8nsi7u25'] : '';
$number_zqf58a25 = isset($settings['number_zqf58a25']) ? $settings['number_zqf58a25'] : '';
$rawhtml_bwcqst25 = !empty($settings['rawhtml_bwcqst25']) ? $this->wdk_senitize_js($settings['rawhtml_bwcqst25']) : '';
$slider_oirofu25 = !empty($settings['slider_oirofu25']) ? $settings['slider_oirofu25'] : '';
$color_w1yj0725 = !empty($settings['color_w1yj0725']) ? $settings['color_w1yj0725'] : '';
$select_xhl10p25 = !empty($settings['select_xhl10p25']) ? $settings['select_xhl10p25'] : '';
$color_c9ndjl25 = !empty($settings['color_c9ndjl25']) ? $settings['color_c9ndjl25'] : '';
$rawhtml_uzo65b25 = !empty($settings['rawhtml_uzo65b25']) ? $this->wdk_senitize_js($settings['rawhtml_uzo65b25']) : '';
$taxonomy_2fgvsd25_4d25 = '';
                                if(!empty($settings['taxonomy_2fgvsd25'])){

                                    $taxo_type = $settings['taxonomy_2fgvsd25'];
                                    $post_type = !empty($settings['post_type_2fgvsd25']) ? $settings['post_type_2fgvsd25'] : 'post';
                                    $per_page = !empty($settings['max_post_2fgvsd25']) ? $settings['max_post_2fgvsd25'] : '10';
                                    $taxonomy_2fgvsd25_4d25_array = !empty($this->get_taxonomy_list($taxo_type, $post_type, $per_page)) ? $this->get_taxonomy_list($taxo_type, $post_type, $per_page) : [];

                                    if ( !empty($taxonomy_2fgvsd25_4d25_array) ) {
                                        foreach ( $taxonomy_2fgvsd25_4d25_array as $t_item ) {
                                            $taxonomy_2fgvsd25_4d25 .= '<a class="{loop-class-taxonomy} wkit-tag-item" href="'.$t_item['front_link'].'" data-taxonomy_2fgvsd25="{taxonomy_2fgvsd25}">
            '.$t_item['name'].'
        </a>';
                                        }
                                    } else {
                                        $taxonomy_2fgvsd25_4d25 .= '<h6 style="color: red;text-align: center;display: block;">No Result Found</h6>';
                                    }
                                }
        $repeater_oud5jv25_vp25 = '';
                            if ( $settings['repeater_oud5jv25'] ) {
                                foreach ( $settings['repeater_oud5jv25'] as $key => $r_item ) {
                                    $iconscontrol_s2tk4e25 = "";
                        if(!empty($r_item['iconscontrol_s2tk4e25']) && !empty($r_item['iconscontrol_s2tk4e25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_s2tk4e25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_s2tk4e25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$media_ebqwas25 = !empty($r_item['media_ebqwas25']['url']) ? $r_item['media_ebqwas25']['url'] : '';
$url_7xacyr25_is_external = !empty($r_item['url_7xacyr25']) && !empty($r_item['url_7xacyr25']['is_external']) ? '_blank' : '';
$url_7xacyr25_url = !empty($r_item['url_7xacyr25']) && !empty($r_item['url_7xacyr25']['url'])? $this->wdk_senitize_js($r_item['url_7xacyr25']['url']) : '';
$url_7xacyr25_nofollow = !empty($r_item['url_7xacyr25']) && !empty($r_item['url_7xacyr25']['nofollow'])? 'nofollow' : '';
$number_jw09k725 = isset($r_item['number_jw09k725']) ? $this->wdk_senitize_js($r_item['number_jw09k725']) : '';
$number_q3jjyh25 = isset($r_item['number_q3jjyh25']) ? $this->wdk_senitize_js($r_item['number_q3jjyh25']) : '';
$number_o2fjzi25 = isset($r_item['number_o2fjzi25']) ? $this->wdk_senitize_js($r_item['number_o2fjzi25']) : '';
$number_yv3po925 = isset($r_item['number_yv3po925']) ? $r_item['number_yv3po925'] : '';
$number_owckpz25 = isset($r_item['number_owckpz25']) ? $r_item['number_owckpz25'] : '';
$number_bcd7d925 = isset($r_item['number_bcd7d925']) ? $r_item['number_bcd7d925'] : '';

                                    $repeater_oud5jv25_vp25 .= '<a href="'.$url_7xacyr25_url.'" target="'.$url_7xacyr25_is_external.'" rel="'.$url_7xacyr25_nofollow.'" data-fontsize="'.$number_jw09k725.'" data-tfontsize="'.$number_q3jjyh25.'" data-mfontsize="'.$number_o2fjzi25.'" class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-tag-item ' . $r_item['select_2wcrpg25'] . ' icon-type-' . $r_item['select_2wcrpg25'] . '" data-weight="'.$number_yv3po925.'" data-tweight="'.$number_owckpz25.'" data-mweight="'.$number_bcd7d925.'" data-repeater_oud5jv25="{repeater_oud5jv25}">
            <span class="wkit-tag-icon">'.$iconscontrol_s2tk4e25.'</span>
            <img class="wkit-tag-img" src="'.$media_ebqwas25.'" alt="Tag Cloud">
            ' . $this->wdk_senitize_js($r_item['text_pdn9p925']) . '
           
        </a>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_jrzbqz25" data-wdkitunique="jrzbqz25">';
            $output .= '<div class="wkit-tag-cloud '.$select_6rvtw725.' '.$select_127um725.'" data-color="'.$select_xhl10p25.'" data-gap="'.$number_nfkc5325.'" data-tgap="'.$number_arogwl25.'" data-mgap="'.$number_bg6uha25.'" data-rratio="'.$number_8nsi7u25.'" data-rsteps="'.$number_zqf58a25.'" data-bg="'.$color_w1yj0725.'" data-ccolor="'.$color_c9ndjl25.'">
    <div class="wdk-common-tag wdk-tag-repeater '.$select_g9ka1n25.' '.$select_s9ljbr25.' '.$select_ujak8p25.'" style="--dsize: '.$number_xy24fa25.'px; --tsize: '.$number_jt2cng25.'px; --msize: '.$number_81ovur25.'px">
        '.$repeater_oud5jv25_vp25.'
    </div>
    <div class="wdk-common-tag wdk-tag-post '.$select_g9ka1n25.' '.$select_s9ljbr25.' '.$select_ujak8p25.'" style="--dsize: '.$number_xy24fa25.'px; --tsize: '.$number_jt2cng25.'px; --msize: '.$number_81ovur25.'px">
        '.$taxonomy_2fgvsd25_4d25.'
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}