<?php
/*
 * Widget Name: Team with Side Panel
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Team_with_Side_Panel_a1lq1r25
 */
class Wdkit_Team_with_Side_Panel_a1lq1r25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-a1lq1r25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Team with Side Panel', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-user-circle-o';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Team with Side Panel','team showcase','side panel','team widget','member profile','hover effect','elementor addon','About Us Section');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_9w5nt025', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Team-with-Side-Panel_a1lq1r25/Team_with_Side_Panel_a1lq1r25.js', array(), '1.2.17.646312', true );

        return [ 'wkit_child_script_9w5nt025' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_gapl6e25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Team-with-Side-Panel_a1lq1r25/Team_with_Side_Panel_a1lq1r25.css', false, '1.2.17.287680', 'all' );

        return [ 'wkit_css_1_gapl6e25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_ufmbp525 = new \Elementor\Repeater();

                $repeater_ufmbp525->add_control('media_m15gm525',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array(),
           'dynamic' => array(
                'active' => true,
            ),
            
            
        )
            );
$repeater_ufmbp525->add_control('text_k97ctl25',
                array(
            
            'label' => esc_html__( 'Name', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'James Kinay', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ufmbp525->add_control('text_nyzx7525',
                array(
            
            'label' => esc_html__( 'Designation', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Sales Manager', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ufmbp525->add_control('textarea_u91pvf25',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            'label' => esc_html__( 'Description', 'wdesignkit' ),
            
            
            'label_block' => true,
            
            'rows' => '2',
            
            'default' => esc_html__( 'Aenean rhoncus ligula ac fermentum facilisis. Donec sit amet accumsan eros, eget sollicitudin orci. In elementum mollis magna, sed facilisis velit suscipit sollicitudin. Cras a faucibus velit. Ut sit amet elit eget neque congue auctor ut quis tellus. Donec orci massa, hendrerit ut mollis id, pellentesque in mi. Nam sollicitudin mi eget maximus hendrerit. Aenean iaculis hendrerit enim. Etiam pretium eget elit vitae cursus.
Nunc malesuada finibus dui, posuere sodales erat sollicitudin non. Mauris auctor felis vel metus consequat, nec eleifend metus placerat. Vivamus venenatis dui at auctor tempus. Phasellus non diam a sem aliquet iaculis. Nunc ut euismod metus. Duis lobortis quis purus sed vulputate. In et ullamcorper urna.', 'wdesignkit' ),
            
            
            
        )
            );
$repeater_ufmbp525->add_control('text_dymg2u25',
                array(
            
            'label' => esc_html__( 'Tel', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '+9112929929', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_ufmbp525->add_control('text_weefrh25',
                array(
            
            'label' => esc_html__( 'Email', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'brayden@example.com', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_ufmbp525->add_control('iconscontrol_iednqq25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fab fa-facebook-f',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_ufmbp525->add_control('url_xbe8ka25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$repeater_ufmbp525->add_control('iconscontrol_3fsaqz25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fab fa-google-plus-g',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_ufmbp525->add_control('url_eq0yfj25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$repeater_ufmbp525->add_control('iconscontrol_pxqvie25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fab fa-x-twitter',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_ufmbp525->add_control('url_8eg5uj25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );

                
                $this->add_control('repeater_kmwp2i25',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Items', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_ufmbp525->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-v5ialr25'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('Aenean rhoncus ligula ac fermentum facilisis. Donec sit amet accumsan eros, eget sollicitudin orci. In elementum mollis magna, sed facilisis velit suscipit sollicitudin. Cras a faucibus velit. Ut sit amet elit eget neque congue auctor ut quis tellus. Donec orci massa, hendrerit ut mollis id, pellentesque in mi. Nam sollicitudin mi eget maximus hendrerit. Aenean iaculis hendrerit enim. Etiam pretium eget elit vitae cursus.
Nunc malesuada finibus dui, posuere sodales erat sollicitudin non. Mauris auctor felis vel metus consequat, nec eleifend metus placerat. Vivamus venenatis dui at auctor tempus. Phasellus non diam a sem aliquet iaculis. Nunc ut euismod metus. Duis lobortis quis purus sed vulputate. In et ullamcorper urna.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_iednqq25' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_3fsaqz25' => 'fab fa-google-plus-g', 
'url_eq0yfj25' => '#', 
'iconscontrol_pxqvie25' => 'fab fa-x-twitter', 
'url_8eg5uj25' => '#', 
),
array('_id'=>uniqid('Wkit-yehdba25'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('Aenean rhoncus ligula ac fermentum facilisis. Donec sit amet accumsan eros, eget sollicitudin orci. In elementum mollis magna, sed facilisis velit suscipit sollicitudin. Cras a faucibus velit. Ut sit amet elit eget neque congue auctor ut quis tellus. Donec orci massa, hendrerit ut mollis id, pellentesque in mi. Nam sollicitudin mi eget maximus hendrerit. Aenean iaculis hendrerit enim. Etiam pretium eget elit vitae cursus.
Nunc malesuada finibus dui, posuere sodales erat sollicitudin non. Mauris auctor felis vel metus consequat, nec eleifend metus placerat. Vivamus venenatis dui at auctor tempus. Phasellus non diam a sem aliquet iaculis. Nunc ut euismod metus. Duis lobortis quis purus sed vulputate. In et ullamcorper urna.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_iednqq25' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_3fsaqz25' => 'fab fa-google-plus-g', 
'url_eq0yfj25' => '#', 
'iconscontrol_pxqvie25' => 'fab fa-x-twitter', 
'url_8eg5uj25' => '#', 
),
array('_id'=>uniqid('Wkit-b6a4b025'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('Aenean rhoncus ligula ac fermentum facilisis. Donec sit amet accumsan eros, eget sollicitudin orci. In elementum mollis magna, sed facilisis velit suscipit sollicitudin. Cras a faucibus velit. Ut sit amet elit eget neque congue auctor ut quis tellus. Donec orci massa, hendrerit ut mollis id, pellentesque in mi. Nam sollicitudin mi eget maximus hendrerit. Aenean iaculis hendrerit enim. Etiam pretium eget elit vitae cursus.
Nunc malesuada finibus dui, posuere sodales erat sollicitudin non. Mauris auctor felis vel metus consequat, nec eleifend metus placerat. Vivamus venenatis dui at auctor tempus. Phasellus non diam a sem aliquet iaculis. Nunc ut euismod metus. Duis lobortis quis purus sed vulputate. In et ullamcorper urna.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_iednqq25' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_3fsaqz25' => 'fab fa-google-plus-g', 
'url_eq0yfj25' => '#', 
'iconscontrol_pxqvie25' => 'fab fa-x-twitter', 
'url_8eg5uj25' => '#', 
),
array('_id'=>uniqid('Wkit-pbnjlp25'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('Aenean rhoncus ligula ac fermentum facilisis. Donec sit amet accumsan eros, eget sollicitudin orci. In elementum mollis magna, sed facilisis velit suscipit sollicitudin. Cras a faucibus velit. Ut sit amet elit eget neque congue auctor ut quis tellus. Donec orci massa, hendrerit ut mollis id, pellentesque in mi. Nam sollicitudin mi eget maximus hendrerit. Aenean iaculis hendrerit enim. Etiam pretium eget elit vitae cursus.
Nunc malesuada finibus dui, posuere sodales erat sollicitudin non. Mauris auctor felis vel metus consequat, nec eleifend metus placerat. Vivamus venenatis dui at auctor tempus. Phasellus non diam a sem aliquet iaculis. Nunc ut euismod metus. Duis lobortis quis purus sed vulputate. In et ullamcorper urna.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_iednqq25' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_3fsaqz25' => 'fab fa-google-plus-g', 
'url_eq0yfj25' => '#', 
'iconscontrol_pxqvie25' => 'fab fa-x-twitter', 
'url_8eg5uj25' => '#', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Extra option_tab_content',
            [
                'label' => esc_html__( 'Extra option', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_responsive_control('choose_c6ygrt25',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper-style3 .wkit-personal-info' => 'text-align: {{VALUE}}',),
        )
            );
$this->add_control('select_qbonbv25',
                array(
            
            'label' => esc_html__( 'Desktop Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'column-4',
            
            'options' => array( 'column-1'  => esc_html__( 'Column 1', 'wdesignkit' ),'column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'column-3'  => esc_html__( 'Column 3', 'wdesignkit' ),'column-4'  => esc_html__( 'Column 4', 'wdesignkit' ),'column-5'  => esc_html__( 'Column 5', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_k87nof25',
                array(
            
            'label' => esc_html__( 'Tablet Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'tablet-column-3',
            
            'options' => array( 'tablet-column-1'  => esc_html__( 'Column 1', 'wdesignkit' ),'tablet-column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'tablet-column-3'  => esc_html__( 'Column 3', 'wdesignkit' ), ),
        )
            );
$this->add_responsive_control('slider_m1zjhv25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper-style3' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('heading_egvc9r25',
                array(
            
            'label' => esc_html__( 'Name', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_8i4fi425',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-item .wkit-team-name',
			)
            );
$this->add_control('color_gpny9w25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item .wkit-team-name' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_2uyfbh25',
                array(
            
            'label' => esc_html__( 'Designation', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_s33ynd25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-item .wkit-desgition',
			)
            );
$this->add_control('color_qsyd3325',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item .wkit-desgition' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_rty2d425',
                array(
            
            'label' => esc_html__( 'Box', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_qz2u8t25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-wrapper-style3 figcaption',
        )
            );
$this->add_control('color_z7f25m25',
                array(
            
            'label' => esc_html__( 'Border Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item::before' => 'border-color: {{VALUE}}',),
        )
            );
$this->add_responsive_control('dimension_7tocqk25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Sider Bar_style_secdddtion',
            [
                'label' => esc_html__( 'Sider Bar', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_qjv1f225',
                array(
            
            'label' => esc_html__( 'Sidebar Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-sidebar' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('dimension_vlams025',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-img-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_nh8m5025',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-sidebar',
        )
            );
$this->add_responsive_control('slider_zzr7hp25',
                array(
            
            'label' => esc_html__( 'Top Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-side-team-name' => 'padding-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('heading_r3o4zz25',
                array(
            
            'label' => esc_html__( 'Name', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_a4b48a25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-side-team-name',
			)
            );
$this->add_control('color_o45pix25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-side-team-name' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_3xw6j925',
                array(
            
            'label' => esc_html__( 'Designation', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_hsn80m25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-side-desgition',
			)
            );
$this->add_control('color_phez1325',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-side-desgition' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_xx3c0n25',
                array(
            
            'label' => esc_html__( 'Description', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_qs6cqb25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-model p.wkit-content-group',
			)
            );
$this->add_control('color_w3r8qh25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-model p.wkit-content-group' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_wezyk525',
                array(
            
            'label' => esc_html__( 'Tel', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_l97asv25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-wrapper-style3 .wkit-tel',
			)
            );
$this->add_control('color_qpfq4a25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper-style3 .wkit-tel' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_dwwe1a25',
                array(
            
            'label' => esc_html__( 'Email', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_rr39b825',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-wrapper-style3 .wkit-mail',
			)
            );
$this->add_control('color_7oaamy25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper-style3 .wkit-mail' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_fdn3ub25',
                array(
            
            'label' => esc_html__( 'Social Icons', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_responsive_control('slider_uou1y725',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_tanhnl25',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_33yg1w25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_33yg1w25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_xiqxcy25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_qinlsg25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_czhl9p25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_uczhj025',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon',
        )
            );
$this->add_responsive_control('dimension_fxyhai25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_c8c78825',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_33yg1w25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_iowilt25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_m3c65n25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon:hover svg' => 'fill: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_fi8aq825',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_mzyqil25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon:hover',
        )
            );
$this->add_responsive_control('dimension_adsgol25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_3keluz25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $choose_c6ygrt25 = !empty($settings['choose_c6ygrt25']) ? $settings['choose_c6ygrt25'] : '';
$select_qbonbv25 = !empty($settings['select_qbonbv25']) ? $settings['select_qbonbv25'] : '';
$select_k87nof25 = !empty($settings['select_k87nof25']) ? $settings['select_k87nof25'] : '';
$slider_m1zjhv25 = !empty($settings['slider_m1zjhv25']) ? $settings['slider_m1zjhv25'] : '';

        $repeater_kmwp2i25_bt25 = '';
                            if ( $settings['repeater_kmwp2i25'] ) {
                                foreach ( $settings['repeater_kmwp2i25'] as $key => $r_item ) {
                                    $media_m15gm525 = !empty($r_item['media_m15gm525']['url']) ? $this->wdk_senitize_js($r_item['media_m15gm525']['url']) : '';
$iconscontrol_iednqq25 = "";
                        if(!empty($r_item['iconscontrol_iednqq25']) && !empty($r_item['iconscontrol_iednqq25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_iednqq25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_iednqq25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_xbe8ka25_is_external = !empty($r_item['url_xbe8ka25']) && !empty($r_item['url_xbe8ka25']['is_external']) ? '_blank' : '';
$url_xbe8ka25_url = !empty($r_item['url_xbe8ka25']) && !empty($r_item['url_xbe8ka25']['url'])? $this->wdk_senitize_js($r_item['url_xbe8ka25']['url']) : '';
$url_xbe8ka25_nofollow = !empty($r_item['url_xbe8ka25']) && !empty($r_item['url_xbe8ka25']['nofollow'])? 'nofollow' : '';
$iconscontrol_3fsaqz25 = "";
                        if(!empty($r_item['iconscontrol_3fsaqz25']) && !empty($r_item['iconscontrol_3fsaqz25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_3fsaqz25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_3fsaqz25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_eq0yfj25_is_external = !empty($r_item['url_eq0yfj25']) && !empty($r_item['url_eq0yfj25']['is_external']) ? '_blank' : '';
$url_eq0yfj25_url = !empty($r_item['url_eq0yfj25']) && !empty($r_item['url_eq0yfj25']['url'])? $this->wdk_senitize_js($r_item['url_eq0yfj25']['url']) : '';
$url_eq0yfj25_nofollow = !empty($r_item['url_eq0yfj25']) && !empty($r_item['url_eq0yfj25']['nofollow'])? 'nofollow' : '';
$iconscontrol_pxqvie25 = "";
                        if(!empty($r_item['iconscontrol_pxqvie25']) && !empty($r_item['iconscontrol_pxqvie25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_pxqvie25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_pxqvie25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_8eg5uj25_is_external = !empty($r_item['url_8eg5uj25']) && !empty($r_item['url_8eg5uj25']['is_external']) ? '_blank' : '';
$url_8eg5uj25_url = !empty($r_item['url_8eg5uj25']) && !empty($r_item['url_8eg5uj25']['url'])? $this->wdk_senitize_js($r_item['url_8eg5uj25']['url']) : '';
$url_8eg5uj25_nofollow = !empty($r_item['url_8eg5uj25']) && !empty($r_item['url_8eg5uj25']['nofollow'])? 'nofollow' : '';

                                    $repeater_kmwp2i25_bt25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-team-item-inner " data-repeater_kmwp2i25="{repeater_kmwp2i25}" data-multiple="{repeater_kmwp2i25}">
      <div class=" wkit-team-item">
          <figure>
              <img src="'.$media_m15gm525.'">
              <figcaption>
                  <div class="wkit-personal-info">
                       <h3 class="wkit-team-name">' . $this->wdk_senitize_js($r_item['text_k97ctl25']) . '</h3>
                       <h4 class="wkit-desgition">' . $this->wdk_senitize_js($r_item['text_nyzx7525']) . '</h4>
                  </div>
             </figcaption>
             
         </figure>
         <div class="wkit-fb-icon none-icon">'.$iconscontrol_iednqq25.'</div>
           <div class="wkit-g-icon none-icon">'.$iconscontrol_3fsaqz25.'</div>
             <div class="wkit-t-icon none-icon">'.$iconscontrol_pxqvie25.'</div>
    </div>
         <div class="wkit-team-popup-content" data-name="' . $this->wdk_senitize_js($r_item['text_k97ctl25']) . '" data-degination="' . $this->wdk_senitize_js($r_item['text_nyzx7525']) . '" data-img="'.$media_m15gm525.'" data-details="' . $this->wdk_senitize_js($r_item['textarea_u91pvf25']) . '" data-tel="' . $this->wdk_senitize_js($r_item['text_dymg2u25']) . '" data-mail="' . $this->wdk_senitize_js($r_item['text_weefrh25']) . '" data-fb="'.$url_xbe8ka25_url.'" data-target-fb="'.$url_xbe8ka25_is_external.'" data-fb-rel="'.$url_xbe8ka25_nofollow.'" data-gp="'.$url_eq0yfj25_url.'" data-gp-target="'.$url_eq0yfj25_is_external.'" data-gp-rel="'.$url_eq0yfj25_nofollow.'" data-twitter="'.$url_8eg5uj25_url.'" data-t-target="'.$url_8eg5uj25_is_external.'" data-t-rel="'.$url_8eg5uj25_nofollow.'" style="display:none">
    </div>
   </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_a1lq1r25" data-wdkitunique="a1lq1r25">';
            $output .= '<div class="wkit-team-wrapper-style3 wdk-extra-mobile '.$select_qbonbv25.' '.$select_k87nof25.'">
    
    '.$repeater_kmwp2i25_bt25.'
    
   <div class="wkit-team-meber-style-2">
        <div class="wkit-overlay"></div>
       <div class="wkit-sidebar">
           <div>  <i class="wkit-close"><svg class="wkit-close-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path></svg></i></div>
           <div class="wkit-team-model">
              
           </div>
    </div>
   
</div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}