<?php
/*
 * Widget Name: Text 3D Effect
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Text_3D_Effect_cl640323
 */
class Wdkit_Text_3D_Effect_cl640323 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-cl640323';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Text 3D Effect', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-wordart';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Text','3D','Third Dimension');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_r910jk25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Text-3D-Effect_cl640323/Text_3D_Effect_cl640323.js', array(), '1.2.17.866741', true );

        return [ 'wkit_child_script_r910jk25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_x7xnpr25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Text-3D-Effect_cl640323/Text_3D_Effect_cl640323.css', false, '1.2.17.987075', 'all' );

        return [ 'wkit_css_1_x7xnpr25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_l92fen23',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( ' The Plus Addons for Elementor', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('switcher_g098ts23',
                array(
            
            'label' => esc_html__( 'Animation ', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('number_42n98423',
                array(
            
            'label' => esc_html__( 'Duration (in second)', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 10,
            'step' => 1,
            'default' => 3,
            
            
            
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_g098ts23', 'operator' => '==', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} undefined' => 'undefined: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_jb25wl25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/text-3d-effect/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Text_style_secdddtion',
            [
                'label' => esc_html__( 'Text', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('choose_nvemg123',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-text-3d-effect' => 'text-align: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_l2r7c323',
                
                
                
                'selector' => '{{WRAPPER}} .w-later-span',
			)
            );
$this->start_controls_tabs('normalhover_ykc1n423',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_ykc1n423_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_eflma823',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .w-later-span' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                    
        Group_Control_Text_Shadow::get_type(),
            array(
				'name' => 'textshadow_wiuxx023',
                'label' => esc_html__( 'Text Shadow', 'wdesignkit' ),
                
                
                
				'selector' => '{{WRAPPER}} .w-later-span',
			)
                );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_ykc1n423_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_krvpi223',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-3d-stage:hover .w-later-span' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                    
        Group_Control_Text_Shadow::get_type(),
            array(
				'name' => 'textshadow_po7j0u23',
                'label' => esc_html__( 'Text Shadow', 'wdesignkit' ),
                
                
                
				'selector' => '{{WRAPPER}} .wkit-3d-stage:hover .w-later-span',
			)
                );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Shadow_style_secdddtion',
            [
                'label' => esc_html__( 'Shadow', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_4zwpyc23',
                array(
            
            'label' => esc_html__( 'Stroke Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .w-3d-layer:nth-child(n+11) span' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_qkex5n25',
                array(
            
            'label' => esc_html__( 'Stroke Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .w-3d-layer:nth-child(n+12) span' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_rj4dsp23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_rj4dsp23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_7bou7i23',
                array(
            
            'label' => esc_html__( 'Stroke Color 1', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .w-3d-layer:nth-child(n+11) span' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->add_control('color_xzwt8b23',
                array(
            
            'label' => esc_html__( 'Stroke Color 2', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .w-3d-layer:nth-child(n+12) span' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_rj4dsp23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_5zpfhk23',
                array(
            
            'label' => esc_html__( 'Stroke Color 1', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-3d-stage:hover .w-3d-layer:nth-child(n+11) span' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->add_control('color_w1vo3623',
                array(
            
            'label' => esc_html__( 'Stroke Color 2', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-3d-stage:hover .w-3d-layer:nth-child(n+12) span' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Rotate_style_secdddtion',
            [
                'label' => esc_html__( 'Rotate', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'switcher_g098ts23', 'operator' => '!=', 'value' => 'yes'],
],
                ),
            ]
        );
$this->start_controls_tabs('normalhover_d5vlln23',
                array(
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_g098ts23', 'operator' => '!=', 'value' => 'yes'),
],
                ),
        )
            );
            $this->start_controls_tab(

                        'normalhover_d5vlln23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_responsive_control('slider_d3gpc223',
                array(
            
            'label' => esc_html__( 'X', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "deg", ),
            
            
            'range' => array('deg' => array(
						'min' => -360,
						'max' => 360,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .w-3d-layer' => '--wkitTextRotateX: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_kw0d5e23',
                array(
            
            'label' => esc_html__( 'Y', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "deg", ),
            
            
            'range' => array('deg' => array(
						'min' => -360,
						'max' => 360,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .w-3d-layer' => '--wkitTextRotateY: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_d5vlln23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_responsive_control('slider_ytfzfy23',
                array(
            
            'label' => esc_html__( 'X', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "deg", ),
            
            
            'range' => array('deg' => array(
						'min' => -360,
						'max' => 360,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-3d-stage:hover .w-3d-layer' => '--wkitTextRotateX: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_ey3pkf23',
                array(
            
            'label' => esc_html__( 'Y', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "deg", ),
            
            
            'range' => array('deg' => array(
						'min' => -360,
						'max' => 360,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'deg',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-3d-stage:hover .w-3d-layer' => '--wkitTextRotateY: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $text_l92fen23 = !empty($settings['text_l92fen23']) ? $this->wdk_senitize_js($settings['text_l92fen23']) : '';
$switcher_g098ts23 = !empty($settings['switcher_g098ts23']) ? $settings['switcher_g098ts23'] : '';
$number_42n98423 = isset($settings['number_42n98423']) ? $this->wdk_senitize_js($settings['number_42n98423']) : '';
$rawhtml_jb25wl25 = !empty($settings['rawhtml_jb25wl25']) ? $this->wdk_senitize_js($settings['rawhtml_jb25wl25']) : '';

        

        $output = '';
        $output .= '<div class="wkit-wb-Widget_cl640323" data-wdkitunique="cl640323">';
            $output .= '<div class="wkit-text-3d-effect">
    <div class="wkit-3d-stage continuous-animation-'.$switcher_g098ts23.'" data-duration="'.$number_42n98423.'">
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
      <div class="w-3d-layer"><span class="w-later-span">'.$text_l92fen23.'</span></div>
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}