(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let shimmerContainer = $scope[0].querySelector(".wkit-shimmer-container");
let shimmerContent = shimmerContainer.querySelector(".wkit-shimmer-content");
let angle, spread;

const config = {
  multiplier: parseFloat(shimmerContent.dataset.speed),
  spread: parseInt(shimmerContent.dataset.spread),
  angle: parseInt(shimmerContent.dataset.angle),
};

function update() {
  document.documentElement.style.setProperty("--bg-spread", config.spread);
  document.documentElement.style.setProperty("--bg-angle", config.angle);
  document.documentElement.style.setProperty("--multiplier", config.multiplier);
}

update();
function syncLines() {
  shimmerContainer.querySelectorAll(".wkit-text").forEach((child) => {
    const textLength = child.textContent.length;
    const speed = config.multiplier;
    const duration = textLength * speed;

    child.style.setProperty("--placeholder-length", textLength);
    child.style.setProperty("--duration", `${duration}s`);
    child.style.animationDelay = `${Math.random() * 2}s`;
    child.style.animationDuration = `${duration}s`;
  });
}

shimmerContainer.addEventListener("input", syncLines);
syncLines();    
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-yfj7y525.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);