<?php
/*
 * Widget Name: Toggle Pricing Features Table
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Toggle_Pricing_Features_Table_nvkmly24
 */
class Wdkit_Toggle_Pricing_Features_Table_nvkmly24 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-nvkmly24';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Toggle Pricing Features Table', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return ' eicon-menu-toggle';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Pricing Plans','Toggle Pricing','Monthly Yearly Switch','Lifetime Options','Comparison Tables','Switcher for Elementor');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_m7055425', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Toggle-Pricing-Features-Table_nvkmly24/Toggle_Pricing_Features_Table_nvkmly24.js', array(), '1.2.17.493724', true );

        return [ 'wkit_child_script_m7055425' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_rx43o725', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Toggle-Pricing-Features-Table_nvkmly24/Toggle_Pricing_Features_Table_nvkmly24.css', false, '1.2.17.557801', 'all' );

        return [ 'wkit_css_1_rx43o725' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_boug2r24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Agency Bundle', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('text_1bp7kv24',
                array(
            
            'label' => esc_html__( 'Subtitle', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Unlimited Options', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('text_uh84r124',
                array(
            
            'label' => esc_html__( 'Price Sign', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '$', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Discount Offer_tab_content',
            [
                'label' => esc_html__( 'Discount Offer', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_9wik2y24',
                array(
            
            'label' => esc_html__( 'Discount Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Discounted From', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('switcher_mpikjn24',
                array(
            
            'label' => esc_html__( 'Discount Offer', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('text_kq28k224',
                array(
            
            'label' => esc_html__( 'Offer Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Save 30%', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_mpikjn24', 'operator' => '==', 'value' => 'yes'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Button_tab_content',
            [
                'label' => esc_html__( 'Button', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_76q13a24',
                array(
            
            'label' => esc_html__( 'Button Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Buy Now', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('textarea_eujqit24',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            'label' => esc_html__( 'Button Description', 'wdesignkit' ),
            
            
            'label_block' => true,
            
            'rows' => '5',
            
            'default' => esc_html__( '60 Days Money Back Guarantee', 'wdesignkit' ),
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Toggle Off_tab_content',
            [
                'label' => esc_html__( 'Toggle Off', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_z5u8g624',
                array(
            
            'label' => esc_html__( 'Toggle Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'YEARLY', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('number_86mn2w24',
                array(
            
            'label' => esc_html__( 'Discount Pricing', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 10000,
            'step' => 1,
            'default' => 200,
            
            
            
            
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
            
        )
            );
$this->add_control('number_coeahe24',
                array(
            
            'label' => esc_html__( ' Normal Pricing', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 10000,
            'step' => 1,
            'default' => 296,
            
            
            
            
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
            
        )
            );
$this->add_control('url_hj9zsu24',
                array(
            
            'label' => esc_html__( 'Button Link', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Toggle On_tab_content',
            [
                'label' => esc_html__( 'Toggle On', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_31hj3y24',
                array(
            
            'label' => esc_html__( 'Toggle Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'LIFETIME', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('number_er3dpp24',
                array(
            
            'label' => esc_html__( 'Discount Pricing', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => "",
            'max' => 10000,
            'step' => 1,
            'default' => 396,
            
            
            
            
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} undefined' => 'undefined: {{VALUE}}',),
        )
            );
$this->add_control('number_0osa4i24',
                array(
            
            'label' => esc_html__( ' Normal Pricing', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => "",
            'max' => 10000,
            'step' => 1,
            'default' => 400,
            
            
            
            
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} undefined' => 'undefined: {{VALUE}}',),
        )
            );
$this->add_control('url_rior1w24',
                array(
            
            'label' => esc_html__( 'Button Link', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Product List_tab_content',
            [
                'label' => esc_html__( 'Product List', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_pfh81024',
                array(
            
            'label' => esc_html__( 'Products Heading ', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Includes all our Products', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ezywlp25 = new \Elementor\Repeater();

                $repeater_ezywlp25->add_control('iconscontrol_4xnfbv24',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            'classes' => 'tp-title-icon',
            'default' => array(
                'value' => 'fas fa-check',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_ezywlp25->add_control('text_w1s8kh24',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'WdesignKit', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ezywlp25->add_control('url_6xn1gy24',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ezywlp25->add_control('iconscontrol_u3ix6z24',
                array(
            
            'label' => esc_html__( 'Tooltip Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            'classes' => 'tp-title-icon',
            'default' => array(
                'value' => 'far fa-question-circle',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_ezywlp25->add_control('text_ojvphv24',
                array(
            
            'label' => esc_html__( 'Tooltip Toggle On', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Lifetime ', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ezywlp25->add_control('text_u7ljor24',
                array(
            
            'label' => esc_html__( 'Tooltip Toggle Off', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Yearly', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );

                
                $this->add_control('repeater_nv4dx324',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'List', 'wdesignkit' ),
                
                
                
                
                
				'fields' => $repeater_ezywlp25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-o4xhjc25'),
'iconscontrol_4xnfbv24' => 'fas fa-check', 
'text_w1s8kh24' => esc_html__('WdesignKit', 'wdesignkit'), 
'url_6xn1gy24' => '#', 
'iconscontrol_u3ix6z24' => 'far fa-question-circle', 
'text_ojvphv24' => esc_html__('Lifetime ', 'wdesignkit'), 
'text_u7ljor24' => esc_html__('Yearly', 'wdesignkit'), 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Connection_tab_content',
            [
                'label' => esc_html__( 'Connection', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_p2prr724',
                array(
            
            'label' => esc_html__( 'Connection ID', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('rawhtml_qdeiwv25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Please Type Connection iD Of Advance Pricing With Toggle.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help?_tab_content',
            [
                'label' => esc_html__( 'Need Help?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_c13h1k25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://store.posimyth.com/helpdesk/"

      target="_blank"

      rel="noopener noreferrer"

    >

      Raise a Ticket

    </a>

  </div>



  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://learn.wdesignkit.com/docs/toggle-pricing-features-table/"

      target="_blank"

      rel="noopener noreferrer"

    >

      Read Documentation

    </a>

  </div>

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://roadmap.wdesignkit.com/boards/feature-requests"

      target="_blank"

      rel="noopener noreferrer"

    >

      Suggest Feature

    </a>

  </div>

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://roadmap.wdesignkit.com/roadmap"

      target="_blank"

      rel="noopener noreferrer"

    >

      Plugin Roadmap

    </a>

  </div>

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://www.facebook.com/wdesignkit"

      target="_blank"

      rel="noopener noreferrer"

    >

      Join Facebook Community

    </a>

  </div>

  <div class="need-help" id="elementor-panel__editor__help">

    <a

      id="elementor-panel__editor__help__link"

      href="https://wordpress.org/support/plugin/wdesignkit/"

      target="_blank"

      style="

        margin: auto;

        color: #fff;

        background: #8072fc;

        padding: 10px 20px;

        border-radius: 5px;

        font-weight: 400;

        font-size: 13px;

        letter-spacing: 0.4px;

        border: 1px solid #8072fc;

        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);

        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);

        -webkit-transition: all 0.3s ease-in;

        -o-transition: all 0.3s ease-in;

        transition: all 0.3s ease-in;

      "

      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>

    </a>

  </div>

</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Background_style_secdddtion',
            [
                'label' => esc_html__( 'Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_oc1tab24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-toggle-pricing-main' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_qsgttt24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-toggle-pricing-main',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_opg9ty24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-toggle-pricing-main',
        )
            );
$this->add_responsive_control('dimension_ou7dlz24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-toggle-pricing-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_elnd1v24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-toggle-pricing-main', 
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Title_style_secdddtion',
            [
                'label' => esc_html__( 'Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_5mxqot24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-top-data-title',
			)
            );
$this->add_control('color_k1l9wu24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-top-data-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Subtitle_style_secdddtion',
            [
                'label' => esc_html__( 'Subtitle', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_v8zjze24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-top-data-subtitle',
			)
            );
$this->add_control('color_th2g3h24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-top-data-subtitle' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Discount Text_style_secdddtion',
            [
                'label' => esc_html__( 'Discount Text', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_2qwuly24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-detail',
			)
            );
$this->add_control('color_ze8sco24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-detail' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Pricing Sign_style_secdddtion',
            [
                'label' => esc_html__( 'Pricing Sign', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_p82mnu24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-dollar',
			)
            );
$this->add_control('color_0wpy0p24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-dollar' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Pricing Number_style_secdddtion',
            [
                'label' => esc_html__( 'Pricing Number', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_825ned24',
                
                
                
                'selector' => '{{WRAPPER}} .toggle-pricing-middle-left .pricing-number',
			)
            );
$this->add_control('color_pvoc2124',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-middle-left' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Pricing Discount_style_secdddtion',
            [
                'label' => esc_html__( 'Pricing Discount', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_t68qn724',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-discount',
			)
            );
$this->add_control('color_nbioan24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-discount' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Discount Pricing Sign_style_secdddtion',
            [
                'label' => esc_html__( 'Discount Pricing Sign', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_yi2rr224',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-dollar-2',
			)
            );
$this->add_control('color_i3qj8724',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-dollar-2' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Offer Box_style_secdddtion',
            [
                'label' => esc_html__( 'Offer Box', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'switcher_mpikjn24', 'operator' => '==', 'value' => 'yes'],
],
                ),
            ]
        );
$this->add_responsive_control('dimension_zkd74s24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_4x3dgr24',
                
                
                
                'selector' => '{{WRAPPER}} .toggle-pricing-offer',
			)
            );
$this->add_control('color_zuv56624',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_i96yol24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-offer',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_jb3t3x24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-offer',
        )
            );
$this->add_responsive_control('dimension_713efs24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-offer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_09xdin24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-offer', 
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Toggle_style_secdddtion',
            [
                'label' => esc_html__( 'Toggle', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_ahshhq24',
                
                
                
                'selector' => '{{WRAPPER}} .toggle-products-top-start, {{WRAPPER}} .toggle-products-top-end',
			)
            );
$this->add_control('heading_bo6gxx24',
                array(
            
            'label' => esc_html__( 'Normal', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('color_jt5gzw24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-products-top-start, {{WRAPPER}} .toggle-products-top-end' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_xrcdqr24',
                array(
            
            'label' => esc_html__( 'Circle Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-products-slider:before' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_jeygaa24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-products-slider',
        )
            );
$this->add_control('heading_lfwa2524',
                array(
            
            'label' => esc_html__( 'Active', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('color_1yz5eh24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-products-top-start.active, {{WRAPPER}} .toggle-products-top-end.active' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_eopn2s24',
                array(
            
            'label' => esc_html__( 'Circle Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} input:checked + .toggle-products-slider:before' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_6lfex924',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} input:checked + .toggle-products-slider',
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Product Heading _style_secdddtion',
            [
                'label' => esc_html__( 'Product Heading ', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_5ezmns24',
                
                
                
                'selector' => '{{WRAPPER}} .toggle-products-middle-text',
			)
            );
$this->add_control('color_ohzcc424',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-products-middle-text' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'List _style_secdddtion',
            [
                'label' => esc_html__( 'List ', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_r7h9ly24',
                
                
                
                'selector' => '{{WRAPPER}} .toggle-products-end-item .products-link',
			)
            );
$this->start_controls_tabs('normalhover_xvrkgq24',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_xvrkgq24_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_61udae24',
                array(
            
            'label' => esc_html__( 'Link Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .products-link' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_xvrkgq24_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_g6nk0i24',
                array(
            
            'label' => esc_html__( 'Link Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .products-link:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_jkvi4m24',
                array(
            
            'label' => esc_html__( 'Line Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-products-end-item .products-link:hover:after' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'List Icon_style_secdddtion',
            [
                'label' => esc_html__( 'List Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_62k43124',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 50,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .tp-title-icon i' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_fktcm024',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 50,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_dhvygf24',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}}  .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_i3vfrq24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .tp-title-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'ToolTip _style_secdddtion',
            [
                'label' => esc_html__( 'ToolTip ', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_4ktm3r24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .toggle-products-item-span .toggle-tooltip-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('slider_t4h0g024',
                array(
            
            'label' => esc_html__( 'Left Offset', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => -100,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .toggle-products-item-span .toggle-tooltip-text' => 'left: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_jcipeh24',
                array(
            
            'label' => esc_html__( 'Top Offset', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => -100,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .toggle-products-item-span .toggle-tooltip-text' => 'top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_7bnd2m24',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-products-item-span .toggle-tooltip-text' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_9234g524',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-products-item-span .toggle-tooltip-text',
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'ToolTip Shape_style_secdddtion',
            [
                'label' => esc_html__( 'ToolTip Shape', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_am5idf24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-products-item-span .toggle-tooltip-text:before',
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Button_style_secdddtion',
            [
                'label' => esc_html__( 'Button', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_6peo3h24',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'separator' => 'before',
            
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-button-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->start_controls_tabs('normalhover_adcmfy24',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_adcmfy24_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_ups8h324',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-button-link',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_qdisk424',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-button-link',
        )
            );
$this->add_responsive_control('dimension_onrl8a24',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-button-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_06ta2n24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-button-link', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_adcmfy24_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_aegjnn24',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-button-link:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_uy47rt24',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-button-link:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_tkomee24',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .toggle-pricing-button-link:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Button Title_style_secdddtion',
            [
                'label' => esc_html__( 'Button Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_h31lcg24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-button-link-title',
			)
            );
$this->start_controls_tabs('normalhover_mnsxoe25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_mnsxoe25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_en145f25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-button-link-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_mnsxoe25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_x5rx0325',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .toggle-pricing-button-link:hover  .pricing-button-link-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Button Description_style_secdddtion',
            [
                'label' => esc_html__( 'Button Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_pmkwnq24',
                
                
                
                'selector' => '{{WRAPPER}} .pricing-button-link-desc',
			)
            );
$this->start_controls_tabs('normalhover_fno9it25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_fno9it25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_c6u1f525',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .pricing-button-link-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_fno9it25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_sov8d325',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}}  .toggle-pricing-button-link:hover .pricing-button-link-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $text_boug2r24 = !empty($settings['text_boug2r24']) ? $this->wdk_senitize_js($settings['text_boug2r24']) : '';
$text_1bp7kv24 = !empty($settings['text_1bp7kv24']) ? $this->wdk_senitize_js($settings['text_1bp7kv24']) : '';
$text_uh84r124 = !empty($settings['text_uh84r124']) ? $this->wdk_senitize_js($settings['text_uh84r124']) : '';
$text_9wik2y24 = !empty($settings['text_9wik2y24']) ? $this->wdk_senitize_js($settings['text_9wik2y24']) : '';
$switcher_mpikjn24 = !empty($settings['switcher_mpikjn24']) ? $settings['switcher_mpikjn24'] : '';
$text_kq28k224 = !empty($settings['text_kq28k224']) ? $this->wdk_senitize_js($settings['text_kq28k224']) : '';
$text_76q13a24 = !empty($settings['text_76q13a24']) ? $this->wdk_senitize_js($settings['text_76q13a24']) : '';
$textarea_eujqit24 = !empty($settings['textarea_eujqit24']) ? $this->wdk_senitize_js($settings['textarea_eujqit24']) : '';
$text_z5u8g624 = !empty($settings['text_z5u8g624']) ? $this->wdk_senitize_js($settings['text_z5u8g624']) : '';
$number_86mn2w24 = isset($settings['number_86mn2w24']) ? $this->wdk_senitize_js($settings['number_86mn2w24']) : '';
$number_coeahe24 = isset($settings['number_coeahe24']) ? $this->wdk_senitize_js($settings['number_coeahe24']) : '';
$url_hj9zsu24_url = !empty($settings['url_hj9zsu24']) && !empty($settings['url_hj9zsu24']['url']) ? $this->wdk_senitize_js($settings['url_hj9zsu24']['url']) : '';
$url_hj9zsu24_is_external = !empty($settings['url_hj9zsu24']) && !empty($settings['url_hj9zsu24']['is_external']) ? '_blank' : '';
$url_hj9zsu24_nofollow = !empty($settings['url_hj9zsu24']) && !empty($settings['url_hj9zsu24']['nofollow']) ? 'nofollow' : '';
$url_hj9zsu24_custmAtr = !empty($settings['url_hj9zsu24']) && !empty($settings['url_hj9zsu24']['custom_attributes']) ? $settings['url_hj9zsu24']['custom_attributes'] : '';
                $url_hj9zsu24_atr = '';
        
                if( !empty( $url_hj9zsu24_custmAtr ) ){
                    $url_hj9zsu24_custmAtr = trim( $url_hj9zsu24_custmAtr, " " );
                    $main_array = explode( ",", $url_hj9zsu24_custmAtr );

                    foreach ( $main_array as $key => $value ) {
                        if( !empty( $value ) ){
                            $ct_array = explode( "|", $value );
                            $url_hj9zsu24_atr .= $ct_array[0] .' = "'. $ct_array[1].'"';
                        }
                    }
                }$text_31hj3y24 = !empty($settings['text_31hj3y24']) ? $this->wdk_senitize_js($settings['text_31hj3y24']) : '';
$number_er3dpp24 = isset($settings['number_er3dpp24']) ? $this->wdk_senitize_js($settings['number_er3dpp24']) : '';
$number_0osa4i24 = isset($settings['number_0osa4i24']) ? $this->wdk_senitize_js($settings['number_0osa4i24']) : '';
$url_rior1w24_url = !empty($settings['url_rior1w24']) && !empty($settings['url_rior1w24']['url']) ? $this->wdk_senitize_js($settings['url_rior1w24']['url']) : '';
$url_rior1w24_is_external = !empty($settings['url_rior1w24']) && !empty($settings['url_rior1w24']['is_external']) ? '_blank' : '';
$url_rior1w24_nofollow = !empty($settings['url_rior1w24']) && !empty($settings['url_rior1w24']['nofollow']) ? 'nofollow' : '';
$url_rior1w24_custmAtr = !empty($settings['url_rior1w24']) && !empty($settings['url_rior1w24']['custom_attributes']) ? $settings['url_rior1w24']['custom_attributes'] : '';
                $url_rior1w24_atr = '';
        
                if( !empty( $url_rior1w24_custmAtr ) ){
                    $url_rior1w24_custmAtr = trim( $url_rior1w24_custmAtr, " " );
                    $main_array = explode( ",", $url_rior1w24_custmAtr );

                    foreach ( $main_array as $key => $value ) {
                        if( !empty( $value ) ){
                            $ct_array = explode( "|", $value );
                            $url_rior1w24_atr .= $ct_array[0] .' = "'. $ct_array[1].'"';
                        }
                    }
                }$text_pfh81024 = !empty($settings['text_pfh81024']) ? $this->wdk_senitize_js($settings['text_pfh81024']) : '';
$text_p2prr724 = !empty($settings['text_p2prr724']) ? $this->wdk_senitize_js($settings['text_p2prr724']) : '';
$rawhtml_qdeiwv25 = !empty($settings['rawhtml_qdeiwv25']) ? $this->wdk_senitize_js($settings['rawhtml_qdeiwv25']) : '';
$rawhtml_c13h1k25 = !empty($settings['rawhtml_c13h1k25']) ? $this->wdk_senitize_js($settings['rawhtml_c13h1k25']) : '';

        $repeater_nv4dx324_8p25 = '';
                            if ( $settings['repeater_nv4dx324'] ) {
                                foreach ( $settings['repeater_nv4dx324'] as $key => $r_item ) {
                                    $iconscontrol_4xnfbv24 = "";
                        if(!empty($r_item['iconscontrol_4xnfbv24']) && !empty($r_item['iconscontrol_4xnfbv24']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_4xnfbv24'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_4xnfbv24 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$url_6xn1gy24_is_external = !empty($r_item['url_6xn1gy24']) && !empty($r_item['url_6xn1gy24']['is_external']) ? '_blank' : '';
$url_6xn1gy24_url = !empty($r_item['url_6xn1gy24']) && !empty($r_item['url_6xn1gy24']['url'])? $this->wdk_senitize_js($r_item['url_6xn1gy24']['url']) : '';
$url_6xn1gy24_nofollow = !empty($r_item['url_6xn1gy24']) && !empty($r_item['url_6xn1gy24']['nofollow'])? 'nofollow' : '';
$iconscontrol_u3ix6z24 = "";
                        if(!empty($r_item['iconscontrol_u3ix6z24']) && !empty($r_item['iconscontrol_u3ix6z24']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_u3ix6z24'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_u3ix6z24 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };

                                    $repeater_nv4dx324_8p25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' toggle-products-end-item" data-repeater_nv4dx324="{repeater_nv4dx324}">
                    '.$iconscontrol_4xnfbv24.'
                    <a href="'.$url_6xn1gy24_url.'" class="products-link" target="'.$url_6xn1gy24_is_external.'" rel="'.$url_6xn1gy24_nofollow.'">
                         <span class="products-end-item-text">' . $this->wdk_senitize_js($r_item['text_w1s8kh24']) . '</span>
                    </a>
                    <span class="toggle-products-item-span">
                        '.$iconscontrol_u3ix6z24.'
                        <span class="toggle-tooltip-text" data-tooltip-on="' . $this->wdk_senitize_js($r_item['text_ojvphv24']) . '" data-tooltip-off="' . $this->wdk_senitize_js($r_item['text_u7ljor24']) . '">' . $this->wdk_senitize_js($r_item['text_u7ljor24']) . '</span>
                    </span>
                </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_nvkmly24" data-wdkitunique="nvkmly24">';
            $output .= '<div class="wkit-toggle-pricing-features-table table-'.$text_p2prr724.'" data-connection-id="'.$text_p2prr724.'">
    <div class="wkit-toggle-pricing-main">
        <div class="wkit-toggle-inner-pricing">
            <div class="toggle-pricing-top">
                <div class="toggle-pricing-top-data">
                   <div class="pricing-top-data-title">'.$text_boug2r24.'</div>  
                   <div class="pricing-top-data-subtitle">'.$text_1bp7kv24.'</div>
                </div>
                <div class="toggle-pricing-offer display-'.$switcher_mpikjn24.'">'.$text_kq28k224.'</div>
            </div>
            <div class="toggle-pricing-middle">
                <div class="toggle-pricing-middle-left">
                        <span class="pricing-dollar">'.$text_uh84r124.'</span>
                        <span class="pricing-number" data-pricing-on="'.$number_er3dpp24.'" data-pricing-off="'.$number_86mn2w24.'">'.$number_86mn2w24.'</span>
                </div>
                <div class="toggle-pricing-middle-right">
                        <div class="pricing-detail">'.$text_9wik2y24.'</div>
                        <span class="pricing-dollar-2">$</span>
                        <span class="pricing-discount" data-discount-on="'.$number_0osa4i24.'" data-discount-off="'.$number_coeahe24.'">'.$number_coeahe24.'</span>
                </div>
            </div>
            <div class="toggle-pricing-button">
                <a href="'.$url_hj9zsu24_url.'" target="'.$url_hj9zsu24_is_external.'" data-on-target="'.$url_rior1w24_is_external.'" data-off-target="'.$url_hj9zsu24_is_external.'" rel="'.$url_hj9zsu24_nofollow.'" class="toggle-pricing-button-link" data-link-on="'.$url_rior1w24_url.'" data-link-off="'.$url_hj9zsu24_url.'">
                    <div class="pricing-button-link-title">'.$text_76q13a24.'</div>
                    <div class="pricing-button-link-desc">'.$textarea_eujqit24.'</div>
                </a>
            </div>
        </div>
        <div class="wkit-toggle-inner-products">
            <div class="toggle-products-top">
                <span class="toggle-products-top-start toggle-text">'.$text_z5u8g624.'</span>
                    <label class="toggle-products-switch">
                      <input type="checkbox" class="toggle-checkbtn">
                      <span class="toggle-products-slider round"></span>
                    </label>
                <span class="toggle-products-top-end toggle-text">'.$text_31hj3y24.'</span>
            </div>
            <div class="toggle-products-middle">
                <span class="toggle-products-middle-text">'.$text_pfh81024.'</span>
            </div>
            <div class="toggle-products-end">
                '.$repeater_nv4dx324_8p25.'
            </div>
        </div>
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}