<?php
/*
 * Widget Name: Dice Game
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Dice_Game_gq297q25
 */
class Wdkit_Dice_Game_gq297q25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-gq297q25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Dice Game', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-frame-expand';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Dice Game','Interactive Widget','Gaming Element','Lucky Draw','Elementor Addon','WordPress Widget','User Engagement');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        wp_enqueue_script( 'wd_ex_script_rnti0h25', 'https://cdnjs.cloudflare.com/ajax/libs/matter-js/0.19.0/matter.min.js', array(), '1.2.17.408681', true );


        wp_enqueue_script( 'wkit_child_script_pk9tiy25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Dice-Game_gq297q25/Dice_Game_gq297q25.js', array(), '1.2.17.210042', true );

        return [ 'wkit_child_script_pk9tiy25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_jml6ua25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Dice-Game_gq297q25/Dice_Game_gq297q25.css', false, '1.2.17.214517', 'all' );

        return [ 'wkit_css_1_jml6ua25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_1kq74e25',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'hz',
            
            'options' => array( 'hz'  => esc_html__( 'Style 1', 'wdesignkit' ),'vl'  => esc_html__( 'Style 2', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_vg9osz25',
                array(
            
            'label' => esc_html__( 'Rolled Value', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Score : ', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->add_control('text_1n8bas25',
                array(
            
            'label' => esc_html__( 'Button Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Roll Dice', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Result Area_tab_content',
            [
                'label' => esc_html__( 'Result Area', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('heading_bazykm25',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_control('number_76o3cx25',
                array(
            
            'label' => esc_html__( 'Desktop', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1000,
            'step' => 1,
            'default' => 600,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_i9fida25',
                array(
            
            'label' => esc_html__( 'Tablet', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 700,
            'step' => 1,
            'default' => 500,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_89pxnm25',
                array(
            
            'label' => esc_html__( 'Mobile', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 500,
            'step' => 1,
            'default' => 300,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('heading_us09tr25',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('number_zz36fx25',
                array(
            
            'label' => esc_html__( 'Desktop', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1000,
            'step' => 1,
            'default' => 600,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_91ns3u25',
                array(
            
            'label' => esc_html__( 'Tablet', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 700,
            'step' => 1,
            'default' => 500,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_azcpac25',
                array(
            
            'label' => esc_html__( 'Mobile', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 500,
            'step' => 1,
            'default' => 300,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('text_kxgamf25',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '#000000', 'wdesignkit' ),
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            'separator' => 'before',
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Dice_tab_content',
            [
                'label' => esc_html__( 'Dice', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('heading_n91ro125',
                array(
            
            'label' => esc_html__( 'Size', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_control('number_rxqio725',
                array(
            
            'label' => esc_html__( 'Desktop', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'default' => 100,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_ey9csp25',
                array(
            
            'label' => esc_html__( 'Tablet', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 70,
            'step' => 1,
            'default' => 70,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('number_riu47y25',
                array(
            
            'label' => esc_html__( 'Mobile', 'wdesignkit' ),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 50,
            'step' => 1,
            'default' => 50,
            
            
            
            
            
            
            
            
            
        )
            );
$this->add_control('text_0lz2b125',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '#ffffff', 'wdesignkit' ),
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            'separator' => 'before',
            
            
            
        )
            );
$this->add_control('text_m0ct5i25',
                array(
            
            'label' => esc_html__( 'Dot Color', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '#000000', 'wdesignkit' ),
            
            
            
            'label_block' => true,
            'input_type' => 'text', 
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('switcher_2j8ll825',
                array(
            
            'label' => esc_html__( 'Slomo Effect', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_responsive_control('choose_4o26v025',
                array(
            
            'label' => esc_html__( 'Button Position', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'row' => array(
                        'title' => esc_html__( 'Row', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'column' => array(
                        'title' => esc_html__( 'Column', 'wdesignkit' ),
                        'icon' => 'eicon-arrow-up',
                    ),
                
                    'row-reverse' => array(
                        'title' => esc_html__( 'Row Revere', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wdk-dice-content' => 'flex-direction: {{VALUE}}',),
        )
            );
$this->add_responsive_control('choose_g3v08125',
                array(
            
            'label' => esc_html__( 'Button Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'flex-start' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'flex-end' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'choose_4o26v025', 'operator' => '==', 'value' => 'column'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wdk-dice-content' => 'align-items: {{VALUE}}',),
        )
            );
$this->add_responsive_control('slider_88rdip25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wdk-dice-content' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_3q7ek325',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/dice-game"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Label_style_secdddtion',
            [
                'label' => esc_html__( 'Label', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_xizh8d25',
                
                
                
                'selector' => '{{WRAPPER}} .dice-result-label',
			)
            );
$this->add_control('color_a7iabr25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .dice-result-label' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Value_style_secdddtion',
            [
                'label' => esc_html__( 'Value', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_cfwxka25',
                
                
                
                'selector' => '{{WRAPPER}} .dice-result-value',
			)
            );
$this->add_control('color_hdx0jf25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .dice-result-value' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Loader_style_secdddtion',
            [
                'label' => esc_html__( 'Loader', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('color_2iohdq25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .dice-loader' => '--dot-color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Button_style_secdddtion',
            [
                'label' => esc_html__( 'Button', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_dcdsdi25',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} #roll-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_o3h8a425',
                
                
                
                'selector' => '{{WRAPPER}} #roll-button',
			)
            );
$this->start_controls_tabs('normalhover_hdnp1x25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_hdnp1x25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_0zoarv25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} #roll-button' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_3vyjv325',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} #roll-button',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_3k8fuj25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} #roll-button',
        )
            );
$this->add_responsive_control('dimension_zqgwgs25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} #roll-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_hvo0zh25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} #roll-button', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_hdnp1x25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_sd8imk25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} #roll-button:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_2fvks725',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} #roll-button:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_vicdch25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} #roll-button:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_e18ynf25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} #roll-button:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_1kq74e25 = !empty($settings['select_1kq74e25']) ? $this->wdk_senitize_js($settings['select_1kq74e25']) : '';
$text_vg9osz25 = !empty($settings['text_vg9osz25']) ? $this->wdk_senitize_js($settings['text_vg9osz25']) : '';
$text_1n8bas25 = !empty($settings['text_1n8bas25']) ? $this->wdk_senitize_js($settings['text_1n8bas25']) : '';
$heading_bazykm25 = !empty($settings['heading_bazykm25']) ? $settings['heading_bazykm25'] : '';
$number_76o3cx25 = isset($settings['number_76o3cx25']) ? $this->wdk_senitize_js($settings['number_76o3cx25']) : '';
$number_i9fida25 = isset($settings['number_i9fida25']) ? $this->wdk_senitize_js($settings['number_i9fida25']) : '';
$number_89pxnm25 = isset($settings['number_89pxnm25']) ? $this->wdk_senitize_js($settings['number_89pxnm25']) : '';
$heading_us09tr25 = !empty($settings['heading_us09tr25']) ? $settings['heading_us09tr25'] : '';
$number_zz36fx25 = isset($settings['number_zz36fx25']) ? $this->wdk_senitize_js($settings['number_zz36fx25']) : '';
$number_91ns3u25 = isset($settings['number_91ns3u25']) ? $this->wdk_senitize_js($settings['number_91ns3u25']) : '';
$number_azcpac25 = isset($settings['number_azcpac25']) ? $this->wdk_senitize_js($settings['number_azcpac25']) : '';
$text_kxgamf25 = !empty($settings['text_kxgamf25']) ? $this->wdk_senitize_js($settings['text_kxgamf25']) : '';
$heading_n91ro125 = !empty($settings['heading_n91ro125']) ? $settings['heading_n91ro125'] : '';
$number_rxqio725 = isset($settings['number_rxqio725']) ? $this->wdk_senitize_js($settings['number_rxqio725']) : '';
$number_ey9csp25 = isset($settings['number_ey9csp25']) ? $this->wdk_senitize_js($settings['number_ey9csp25']) : '';
$number_riu47y25 = isset($settings['number_riu47y25']) ? $this->wdk_senitize_js($settings['number_riu47y25']) : '';
$text_0lz2b125 = !empty($settings['text_0lz2b125']) ? $this->wdk_senitize_js($settings['text_0lz2b125']) : '';
$text_m0ct5i25 = !empty($settings['text_m0ct5i25']) ? $this->wdk_senitize_js($settings['text_m0ct5i25']) : '';
$switcher_2j8ll825 = !empty($settings['switcher_2j8ll825']) ? $settings['switcher_2j8ll825'] : '';
$choose_4o26v025 = !empty($settings['choose_4o26v025']) ? $this->wdk_senitize_js($settings['choose_4o26v025']) : '';
$choose_g3v08125 = !empty($settings['choose_g3v08125']) ? $this->wdk_senitize_js($settings['choose_g3v08125']) : '';
$slider_88rdip25 = !empty($settings['slider_88rdip25']) ? $settings['slider_88rdip25'] : '';
$rawhtml_3q7ek325 = !empty($settings['rawhtml_3q7ek325']) ? $this->wdk_senitize_js($settings['rawhtml_3q7ek325']) : '';

        

        $output = '';
        $output .= '<div class="wkit-wb-Widget_gq297q25" data-wdkitunique="gq297q25">';
            $output .= '<div class="wdk-dice-game content-type-'.$select_1kq74e25.'" data-desktopw="'.$number_76o3cx25.'" data-tabletw="'.$number_i9fida25.'" data-mobilew="'.$number_89pxnm25.'" data-desktoph="'.$number_zz36fx25.'" data-tableth="'.$number_91ns3u25.'" data-mobileh="'.$number_azcpac25.'" data-areacolor="'.$text_kxgamf25.'" data-dicedw="'.$number_rxqio725.'" data-dicetw="'.$number_ey9csp25.'" data-dicemw="'.$number_riu47y25.'" data-dicecolor="'.$text_0lz2b125.'" data-dicedot="'.$text_m0ct5i25.'" data-slomo="'.$switcher_2j8ll825.'">
    <div class="wdk-dice-content">
         <div class="wdk-dice-value">
            <span class="dice-result-label" data-label="'.$text_vg9osz25.'">'.$text_vg9osz25.'</span>
            <span class="dice-loader"></span>
            <span class="dice-result-value"></span>
        </div>
        <a id="roll-button" data-btn="'.$text_1n8bas25.'">'.$text_1n8bas25.'</a>
    </div>
    
    <div class="wdk-dice-canvas">
        <canvas id="canvas"></canvas>
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}