(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                const portfolioSlider = $scope[0].querySelector(".wkit-portfolio-slider-main");
const sliderImages = portfolioSlider.querySelector(".wkit-slider-images");
const counter = portfolioSlider.querySelector(".wkit-counter");
const titles = portfolioSlider.querySelector(".slider-title-wrapper");
const indicators = portfolioSlider.querySelectorAll(".wkit-ptf-slider-indicators p");
const prevSlides = portfolioSlider.querySelectorAll(".wkit-ptf-slider-preview .wkit-preview");
const slidePreview = portfolioSlider.querySelector(".wkit-ptf-slider-preview");
const counterTotal = portfolioSlider.querySelector(".counter-total");

let arrowRotate = (portfolioSlider.getAttribute('data-arrowrotate')) ? true : false;

let getCount = counter.querySelectorAll('.wdk-count-indi');
getCount.forEach((cnt, index)=>{
    cnt.textContent = Number(index) + 1;
})

gsap.registerPlugin(CustomEase);
CustomEase.create(
    "hop",
    "M0,0 C0.071,0.505 0.192,0.726 0.318,0.852 0.45,0.984 0.504,1 1,1"
);

const imageUrls = Array.from(prevSlides).map((item) => item.getAttribute("data-src"));
let currentImg = 1;
const totalSlides = imageUrls.length;
let indicatorRotation = 0;

function animateSlide(direction) {
    const currentSlide = sliderImages.querySelectorAll(".wkit-slider-img")[sliderImages.children.length - 1];
    const slideImg = document.createElement("div");
    slideImg.classList.add("wkit-slider-img");

    const slideImgElem = document.createElement("img");
    slideImgElem.src = imageUrls[currentImg - 1];
    slideImgElem.alt = "Portfolio Image";

    const enterFromX = direction === "left" ? -500 : 500;
    const exitToX = direction === "left" ? 500 : -500;

    gsap.set(slideImgElem, { x: enterFromX });
    slideImg.appendChild(slideImgElem);
    sliderImages.appendChild(slideImg);

    gsap.to(currentSlide.querySelector("img"), { x: exitToX, duration: 1.2, ease: "hop" });
    gsap.to(slideImgElem, { x: 0, duration: 1.2, ease: "hop" });

    gsap.fromTo(
        slideImg,
        {
            clipPath:
                direction === "left"
                    ? "polygon(0% 0%, 0% 0%, 0% 100%, 0% 100%)"
                    : "polygon(100% 0%, 100% 0%, 100% 100%, 100% 100%)",
        },
        {
            clipPath: "polygon(0% 0%, 100% 0%, 100% 100%, 0% 100%)",
            duration: 1.2,
            ease: "hop",
        }
    );

    cleanupSlides();
    if(arrowRotate){
        indicatorRotation += direction === "left" ? -360 : 360;
        gsap.to(indicators, { rotate: indicatorRotation, duration: 1, ease: "hop" });
    }
}

function updateCounterAndTitle() {
    let titleElement = portfolioSlider.querySelector(".wkit-portfolio-title");
    let counterElement = portfolioSlider.querySelector(".wkit-slider-counter");

    if (!titleElement || !counterElement) {
        console.error("One or more elements not found: .wkit-portfolio-title or .wkit-slider-counter");
        return;
    }

    let titleHeight = titleElement.getBoundingClientRect().height || 60;
    let counterHeight = counterElement.getBoundingClientRect().height || 20;

    gsap.to(counter, {
        y: -counterHeight * (currentImg - 1),
        duration: 1,
        ease: "hop",
    });

    gsap.to(titles, {
        y: -titleHeight * (currentImg - 1),
        duration: 1,
        ease: "hop",
    });

    counterTotal.textContent = totalSlides;
}

function updateActivePreview() {
    prevSlides.forEach((prev, index) => prev.classList.toggle("active", index + 1 === currentImg));

    const activePreview = portfolioSlider.querySelector(".wkit-preview.active");
    if (activePreview) {
        const container = portfolioSlider.querySelector(".wkit-ptf-slider-preview");
        const containerWidth = container.clientWidth;
        const scrollAmount = activePreview.offsetLeft - containerWidth / 2 + activePreview.clientWidth / 2;

        gsap.to(container, { scrollLeft: scrollAmount, duration: 0.8, ease: "power2.out" });
    }
}

function cleanupSlides() {
    const imgElements = sliderImages.querySelectorAll(".wkit-slider-img");
    if (imgElements.length > totalSlides) {
        imgElements[0].remove();
    }
}

portfolioSlider.addEventListener("click", (event) => {
    const sliderWidth = portfolioSlider.querySelector(".wkit-portfolio-slider-wrapper").clientWidth;
    const clickPosition = event.clientX;

    if (slidePreview.contains(event.target)) {
        const clickedPrev = event.target.closest(".wkit-preview");
        if (clickedPrev) {
            const clickedIndex = Array.from(prevSlides).indexOf(clickedPrev) + 1;
            if (clickedIndex !== currentImg) {
                const previousImg = currentImg;
                currentImg = clickedIndex;
                animateSlide(clickedIndex > previousImg ? "right" : "left");
                updateActivePreview();
                updateCounterAndTitle();
            }
        }
        return;
    }

    if (clickPosition < sliderWidth / 2 && currentImg > 1) {
        currentImg--;
        animateSlide("left");
    } else if (clickPosition > sliderWidth / 2 && currentImg < totalSlides) {
        currentImg++;
        animateSlide("right");
    }

    updateActivePreview();
    updateCounterAndTitle();
});

function initializeSlider() {
    const firstImgElem = sliderImages.querySelector(".wkit-slider-img img");
    if (firstImgElem) {
        firstImgElem.src = imageUrls[0];
    }
}

initializeSlider();
updateCounterAndTitle();
updateActivePreview();
  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-acgwnt25.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);