(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let ab = $scope[0]?.querySelector(".wkit-tag-cloud");
if (!ab) return;

const isStyle3 = ab.classList.contains('style-3');
const isRepeater = ab.classList.contains('repeater');
const mainE = $scope[0].querySelector(isRepeater ? '.wdk-tag-repeater' : '.wdk-tag-post');
if (!mainE) return;

// Remove extra tag-posts
let postE = $scope[0].querySelectorAll('.wdk-tag-post');
if (postE && postE.length > 1) {
    postE.forEach((p, i) => { if (i > 0) p.remove(); });
}

let items = mainE.querySelectorAll('.wkit-tag-item');
if (!items || items.length === 0) return;

const screenW = screen.width;
const getFontSize = (el) => {
    if (screenW >= 1024) return el.getAttribute('data-fontsize');       
    if (screenW >= 768) return el.getAttribute('data-tfontsize');   
    return el.getAttribute('data-mfontsize');                           
};

// STYLE-1 & STYLE-2
if (!isStyle3) {
    items.forEach(item => {
        const fsize = getFontSize(item);
        if (fsize) item.style.fontSize = fsize + 'px';
    });
    return; 
}

// STYLE-3: WordCloud mode
mainE.innerHTML = '';

let offWidth = mainE.offsetWidth;
let sizeWeight = (offWidth > 1000) ? 100 : (offWidth > 700 ? 70 : 30);

const rratio = Number(ab.getAttribute('data-rratio') || 0.5);
const rsteps = Number(ab.getAttribute('data-rsteps') || 4);
const ccolor = ab.getAttribute('data-ccolor') || '#000';
const color = (ab.getAttribute('data-color') === 'custom') ? ccolor : (ab.getAttribute('data-color') || 'random-light');
const bg = ab.getAttribute('data-bg') || '#fff';

let ggap = 0;
if (screenW >= 1024) {
    ggap = Number(ab.getAttribute('data-gap') || 10);
} else if (screenW >= 768) {
    ggap = Number(ab.getAttribute('data-tgap') || 7);
} else {
    ggap = Number(ab.getAttribute('data-mgap') || 5);
}

const words = Array.from(items).map(item => {
    const text = item.textContent.trim();
    const fsize = getFontSize(item);

    let sweight;
    if (screenW >= 1024) {
        sweight = item.getAttribute('data-weight');
    } else if (screenW >= 768) {
        sweight = item.getAttribute('data-tweight');
    } else {
        sweight = item.getAttribute('data-mweight');
    }

    const size = parseInt(fsize) || parseInt(sweight) || Math.floor(Math.random() * (sizeWeight - 10 + 1)) + 10;
    const link = item.href;
    return [text, size, link, fsize];
});

WordCloud.minFontSize = "10px";

WordCloud([mainE], {
    list: words,
    backgroundColor: bg,
    gridSize: ggap,
    rotateRatio: rratio,
    color: color,
    rotationSteps: rsteps,
    classes: ' wkit-tag-item',
    click: (item) => {
        if (!elementorFrontend.isEditMode()) {
            window.open(item[2], "_blank");
        }
    }
});

// After WordCloud injects elements — apply font sizes
const applyFontSizes = () => {
    const updatedItems = mainE.querySelectorAll('.wkit-tag-item');
    updatedItems.forEach((item, i) => {
        const fsize = words[i]?.[3];
        if (fsize) item.style.fontSize = `${fsize}px`;
    });
};

const addActiveClass = () => {
    const items = mainE.querySelectorAll('.wkit-tag-item');
    items.forEach((item, i) => {
        setTimeout(() => item.classList.add('active'), 700 * i);
    });
};

const observer = new MutationObserver(mutations => {
    const added = mutations.some(m => m.addedNodes.length);
    if (added) {
        observer.disconnect();
        applyFontSizes();
        addActiveClass();
    }
});
observer.observe(mainE, { childList: true });
setTimeout(() => {
    applyFontSizes();
    addActiveClass();
}, 1500);
  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-jrzbqz25.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);