(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let TeamMain = $scope[0].querySelector(".wkit-team-wrapper-style2");
let ListTeam = TeamMain.querySelectorAll(".wkit-team-item-inner");
let style2Main = TeamMain.querySelector(".wkit-team-meber-style-2");
let Style2popup = TeamMain.querySelector(".wkit-team-model");
let nextButton = TeamMain.querySelector(".wkit-next-btn");
let prevButton = TeamMain.querySelector(".wkit-prev-btn");
let closeout = TeamMain.querySelector(".wkit-team-inner-overlay");

if (ListTeam.length <= 1) {
    prevButton.style.display = "none";
    nextButton.style.display = "none";
} else {
    prevButton.style.display = "block";
    nextButton.style.display = "block";
}

let currentIndex = 0;

style2Main.style.display = 'flex';

function showModalData(index) {
    let team = ListTeam[index];
    let selectedPopup = team.querySelector(".wkit-team-popup-content");
    let fbicon = team.querySelector(".wkit-fb-icon");
    let gpicon = team.querySelector(".wkit-gp-icon");
    let twicon = team.querySelector(".wkit-tw-icon");

    if (!selectedPopup) return;
    let fb = (fbicon.innerHTML && selectedPopup.getAttribute("data-fb")) ? `<a href="${selectedPopup.getAttribute("data-fb")}" target="${selectedPopup.getAttribute("data-fbex")}" rel="${selectedPopup.getAttribute("data-fbrel")}" class="wkit-team-social-icon" target="_blank">${fbicon.innerHTML}</a>` : '';
    let google = (gpicon.innerHTML && selectedPopup.getAttribute("data-gp")) ? `<a href="${selectedPopup.getAttribute("data-gp")}" target="${selectedPopup.getAttribute("data-gpex")}" rel="${selectedPopup.getAttribute("data-gprel")}" class="wkit-team-social-icon" target="_blank">${gpicon.innerHTML}</a>` : '';
    let twitter = (twicon.innerHTML && selectedPopup.getAttribute("data-twitter")) ? `<a href="${selectedPopup.getAttribute("data-twitter")}" target="${selectedPopup.getAttribute("data-twitterex")}" rel="${selectedPopup.getAttribute("data-twitterrel")}" class="wkit-team-social-icon" target="_blank">${twicon.innerHTML}</a>` : '';
    // Set modal content
    Style2popup.innerHTML = `
        <div><i class="wkit-close"><svg class="wkit-close-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg></i></div>
        <div class="wkit-img-wrap">
            <img src="${selectedPopup.getAttribute("data-img")}" />
        </div>
        <div class="wkit-contet-group">
            <div class="wkit-contact-details">
                <h3 class="wkit-desgition">${selectedPopup.getAttribute("data-degination")}</h3>
                <h4 class="wkit-team-name">${selectedPopup.getAttribute("data-name")}</h4>
                <p class="wkit-team-details">${selectedPopup.getAttribute("data-details")}</p>
            </div>
            <div class="wkit-social-icons">
                <p class="wkit-team wkit-tel" data-tel="${selectedPopup.getAttribute("data-tel")}"><span>Tel:</span> 
                <a class="wkit-tel" href="tel:${selectedPopup.getAttribute("data-tel")}">
                ${selectedPopup.getAttribute("data-tel")}
                </a></p>
                <p class="wkit-em wkit-mail" data-mail="${selectedPopup.getAttribute("data-mail")}"><span>Email:</span> 
                <a class="wkit-mail" href="mailto:${selectedPopup.getAttribute("data-mail")}">
                ${selectedPopup.getAttribute("data-mail")}
                </a></p>
                <div class="wkit-social-group">
                    ${fb}
                    ${google}
                    ${twitter}
                </div>
            </div>
        </div>
    `;

    // Make modal visible
    style2Main.style.visibility = "visible";
    style2Main.style.opacity = "1";
    Style2popup.classList.add("show");

    // Attach close event AFTER the modal is created
    let closeButton = Style2popup.querySelector(".wkit-close");
    if (closeButton) {
        closeButton.addEventListener("click", closeModal);
    }
}

function closeModal() {
    style2Main.style.visibility = "hidden";
    style2Main.style.opacity = "0";
    Style2popup.classList.remove("show");
}

// Add click event to team items
ListTeam.forEach((team, index) => {
    team.addEventListener("click", (e) => {
        e.stopPropagation();
        currentIndex = index;
        showModalData(currentIndex);
    });
});

// Handle Next Button Click
nextButton.addEventListener("click", () => {
    currentIndex = (currentIndex + 1) % ListTeam.length;
    showModalData(currentIndex);
});

// Handle Prev Button Click
prevButton.addEventListener("click", () => {
    currentIndex = (currentIndex - 1 + ListTeam.length) % ListTeam.length;
    showModalData(currentIndex);
});

// Handle Close Button for overlay
closeout.addEventListener("click", closeModal);

document.addEventListener('keydown', function(event) {
  if (event.key === "Escape" && Style2popup.classList.contains("show")) {
    closeModal();
  }
});
  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-8yadn925.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);