(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                  let TeamMain = $scope[0].querySelector(".wkit-team-wrapper-style3");
  let ListTeam = TeamMain.querySelectorAll(".wkit-team-item-inner");
  let Sidebar = $scope[0].querySelector(".wkit-sidebar");
  let Overlay = $scope[0].querySelector(".wkit-overlay");
  let CloseBtn = $scope[0].querySelector(".wkit-close");
  let DetailsContainer = $scope[0].querySelector(".wkit-team-model");
 

  let currentIndex = 0;

  ListTeam.forEach((team, index) => {
    team.addEventListener("click", () => {
      currentIndex = index;
      showSidebar(index);
    });
  });
  
  let fbicon =TeamMain.querySelector(".wkit-fb-icon");
  let gicon =TeamMain.querySelector(".wkit-g-icon");
  let ticon =TeamMain.querySelector(".wkit-t-icon");
    
  function showSidebar(index) {
    let selectedPopup = ListTeam[index].querySelector(".wkit-team-popup-content");
    if (!selectedPopup) return;

    let name = selectedPopup.getAttribute("data-name") || "Unknown";
    let desg = selectedPopup.getAttribute("data-degination") || "N/A";
    let details = selectedPopup.getAttribute("data-details") || "No details available.";
    let tel = selectedPopup.getAttribute("data-tel") || "";
    let mail = selectedPopup.getAttribute("data-mail") || "";
    let Dimg = selectedPopup.getAttribute("data-img") || "default.jpg";
    let fburl = selectedPopup.getAttribute("data-fb");
    let fbtarget = selectedPopup.getAttribute("data-target-fb");
    let fbrel = selectedPopup.getAttribute("data-fb-rel");
    let gpurl = selectedPopup.getAttribute("data-gp");
    let gptarget = selectedPopup.getAttribute("data-gp-target");
    let gprel = selectedPopup.getAttribute("data-gp-rel");
    let twitterurl = selectedPopup.getAttribute("data-twitter");
    let twittertarget = selectedPopup.getAttribute("data-t-target");
    let twitterrel = selectedPopup.getAttribute("data-t-rel");
    
    let fb = (fburl && fbicon.innerHTML) ? `<span><a href="${fburl}" class="wkit-team-social-icon" target="${fbtarget}" rel="${fbrel}">${fbicon.innerHTML}</a></span>` : '';
    let google = (gpurl && gicon.innerHTML) ? `<span><a href="${gpurl}" class="wkit-team-social-icon" target="${gptarget}" rel="${gprel}">${gicon.innerHTML}</a></span>` : '';
    let twitter = (twitterurl && ticon.innerHTML) ? `<span><a href="${twitterurl}" class="wkit-team-social-icon" target="${twittertarget}" rel="${twitterrel}">${ticon.innerHTML}</a></span>` : '';
    
    DetailsContainer.innerHTML = `
      <div class="wkit-img-wrap"><img src="${Dimg}"/></div>
      <h4 class="wkit-side-team-name">${name}</h4>
      <h3 class="wkit-side-desgition">${desg}</h3>
      <p class="wkit-content-group">${details}</p>
      <p class="wkit-team wkit-tel" data-tel="${tel}"><span>Tel:</span><a href="tel:${tel}" class="wkit-tel">${tel}</a></p>
      <p class="wkit-em wkit-mail" data-mail="${mail}"><span>Email:</span><a href="mailto:${mail}" class="wkit-mail">${mail}</a></p>
       <div class="wkit-social-group">
            ${fb}
            ${google}
            ${twitter}
        </div>
    `;

    Sidebar.classList.add("open");
    Overlay.classList.add("active");
  }




  CloseBtn.addEventListener("click", () => {
    Sidebar.classList.remove("open");
    Overlay.classList.remove("active");
  });

  Overlay.addEventListener("click", () => {
    Sidebar.classList.remove("open");
    Overlay.classList.remove("active");
  });
  
  
  document.addEventListener('keydown', function(event) {
      if(event.key === "Escape" && Sidebar.classList.contains("open") && Overlay.classList.contains("active")) {
        Sidebar.classList.remove("open");
        Overlay.classList.remove("active");
      }
  });  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-a1lq1r25.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);