(function ($) {
        "use strict";
            var WidgetScrollSequenceHandler = function($scope, $) { 
                let is_editable = elementorFrontend?.isEditMode();
                let magnet = $scope[0].querySelector('.wkit-megnetic-button');

let magnetInner = magnet.querySelector('.wkit-megnetic-button-inner');
let strength = 50;
let link = magnet.querySelector('.wkit-btn');
const isTablet = window.innerWidth >= 768 && window.innerWidth <= 1024;
const isMobile = window.innerWidth <= 767;

link.addEventListener('click', (e) => {
    if (
        (isMobile && !magnetInner.classList.contains('disable-mobile-link')) ||
        (isTablet && !magnetInner.classList.contains('disable-tablet-link'))
    ) 
    e.preventDefault();
    e.stopPropagation();
});
magnetInner.addEventListener('mousemove', magnetMove);
magnetInner.addEventListener('mouseout', function(event) {
    TweenMax.to( event.currentTarget, 1, {x: 0, y: 0, ease: Power4.easeOut})
});

function magnetMove(event) {
  let magnetBtn = event.currentTarget;
  let bounding = magnetBtn.getBoundingClientRect();


  TweenMax.to( magnetBtn, 1, {
    x: ((( event.clientX - bounding.left)/magnetBtn.offsetWidth) - 0.5) * strength,
    y: ((( event.clientY - bounding.top)/magnetBtn.offsetHeight) - 0.5) * strength,
    ease: Power4.easeOut
  })

}  
            };	
        $(window).on('elementor/frontend/init', function () {
          elementorFrontend.hooks.addAction('frontend/element_ready/wb-q9hzur24.default', WidgetScrollSequenceHandler);
        });
    })(jQuery);