<?php
/*
 * Widget Name: Portfolio Slider
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Portfolio_Slider_acgwnt25
 */
class Wdkit_Portfolio_Slider_acgwnt25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-acgwnt25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Portfolio Slider', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-post-slider';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Portfolio','Slider','Carousel','Swiper','Media','Gallery','Image');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        wp_enqueue_script( 'wd_ex_script_rg1gyg25', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js', array(), '1.2.17.242750', true );
wp_enqueue_script( 'wd_ex_script_9jk9y025', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/CustomEase.min.js', array(), '1.2.17.482466', true );


        wp_enqueue_script( 'wkit_child_script_m8co0l25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Portfolio-Slider_acgwnt25/Portfolio_Slider_acgwnt25.js', array(), '1.2.17.791593', true );

        return [ 'wkit_child_script_m8co0l25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_tetiaj25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Portfolio-Slider_acgwnt25/Portfolio_Slider_acgwnt25.css', false, '1.2.17.355667', 'all' );

        return [ 'wkit_css_1_tetiaj25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_fiksmk25',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'style-1',
            
            'options' => array( 'style-1'  => esc_html__( 'Style 1', 'wdesignkit' ),'style-2'  => esc_html__( 'Style 2', 'wdesignkit' ), ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_ypi2bx25 = new \Elementor\Repeater();

                $repeater_ypi2bx25->add_control('text_y8b9d425',
                array(
            
            'label' => esc_html__( 'Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'The revival assemble', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_ypi2bx25->add_control('url_cveyou25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_ypi2bx25->add_control('media_g4gcgo25',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array("image"),
           
            
            
        )
            );

                
                $this->add_control('repeater_wz94k025',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Slides', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_ypi2bx25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-qqarv625'),
'text_y8b9d425' => esc_html__('The revival assemble', 'wdesignkit'), 
'url_cveyou25' => '#', 
'media_g4gcgo25' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
),
array('_id'=>uniqid('Wkit-ghqzqy25'),
'text_y8b9d425' => esc_html__('The revival assemble', 'wdesignkit'), 
'url_cveyou25' => '#', 
'media_g4gcgo25' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
),
array('_id'=>uniqid('Wkit-rt37by25'),
'text_y8b9d425' => esc_html__('The revival assemble', 'wdesignkit'), 
'url_cveyou25' => '#', 
'media_g4gcgo25' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
),
array('_id'=>uniqid('Wkit-8tipfs25'),
'text_y8b9d425' => esc_html__('The revival assemble', 'wdesignkit'), 
'url_cveyou25' => '#', 
'media_g4gcgo25' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
),
array('_id'=>uniqid('Wkit-ldcy2v25'),
'text_y8b9d425' => esc_html__('The revival assemble', 'wdesignkit'), 
'url_cveyou25' => '#', 
'media_g4gcgo25' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Indicators Icon_tab_content',
            [
                'label' => esc_html__( 'Indicators Icon', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('iconscontrol_mobzt225',
                array(
            
            'label' => esc_html__( 'Prev Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-minus',
                'library' => 'fa-solid',
            ),
            
        )
            );
$this->add_control('iconscontrol_obp4mc25',
                array(
            
            'label' => esc_html__( 'Next Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-plus',
                'library' => 'fa-solid',
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('switcher_jc6z7025',
                array(
            
            'label' => esc_html__( 'Icon Rotate Effect', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->add_control('rawhtml_hfb7ng25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note : When enabled, the navigation arrows will rotate slightly upon clicking, adding a subtle visual effect.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help?_tab_content',
            [
                'label' => esc_html__( 'Need Help?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_gfrqoe25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://store.posimyth.com/helpdesk/"

      target="_blank"

      rel="noopener noreferrer"

    >

      Raise a Ticket

    </a>

  </div>



  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://learn.wdesignkit.com/docs/portfolio-slider/"

      target="_blank"

      rel="noopener noreferrer"

    >

      Read Documentation

    </a>

  </div>

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://roadmap.wdesignkit.com/boards/feature-requests"

      target="_blank"

      rel="noopener noreferrer"

    >

      Suggest Feature

    </a>

  </div>

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://roadmap.wdesignkit.com/roadmap"

      target="_blank"

      rel="noopener noreferrer"

    >

      Plugin Roadmap

    </a>

  </div>

  <div class="wdk-help" style="margin-bottom: 15px">

    <a

      class="wdk-docs-link"

      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"

      href="https://www.facebook.com/wdesignkit"

      target="_blank"

      rel="noopener noreferrer"

    >

      Join Facebook Community

    </a>

  </div>

  <div class="need-help" id="elementor-panel__editor__help">

    <a

      id="elementor-panel__editor__help__link"

      href="https://wordpress.org/support/plugin/wdesignkit/"

      target="_blank"

      style="

        margin: auto;

        color: #fff;

        background: #8072fc;

        padding: 10px 20px;

        border-radius: 5px;

        font-weight: 400;

        font-size: 13px;

        letter-spacing: 0.4px;

        border: 1px solid #8072fc;

        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);

        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);

        -webkit-transition: all 0.3s ease-in;

        -o-transition: all 0.3s ease-in;

        transition: all 0.3s ease-in;

      "

      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>

    </a>

  </div>

</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('choose_3uxgzl25',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-title .slider-title-wrapper' => 'text-align: {{VALUE}}',),
        )
            );
$this->add_responsive_control('dimension_j1of9925',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-title .slider-title-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('slider_0u80ag25',
                array(
            
            'label' => esc_html__( 'Top Offset', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 10000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-title' => 'top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_j2sl1g25',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-title' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('rawhtml_w6j92h25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Manage height, font-size & line-height for proper animation.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_r3amqv25',
                
                
                
                'selector' => '{{WRAPPER}} .slider-title-wrapper .title-link',
			)
            );
$this->start_controls_tabs('normalhover_fkvxzy25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_fkvxzy25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_63c94b25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-main .slider-title-wrapper .title-link' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_fkvxzy25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_gjg2th25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-main .slider-title-wrapper .title-link:hover' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Navigation_style_secdddtion',
            [
                'label' => esc_html__( 'Navigation', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_u2im0y25',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-slider-counter' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('rawhtml_9f3vgn25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Manage height, font-size & line-height for proper animation.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_16agra25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-slider-counter p',
			)
            );
$this->start_controls_tabs('normalhover_4ryg4u25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_4ryg4u25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_lsvzfl25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-slider-counter p' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_4ryg4u25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_9ranhy25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-slider-counter p:hover' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('heading_edxr7a25',
                array(
            
            'label' => esc_html__( 'Separator Line', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_responsive_control('slider_pcw0h825',
                array(
            
            'label' => esc_html__( 'Separator Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-main .long-dash' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_mk3kra25',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-main .long-dash' => 'border-color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Indicators_style_secdddtion',
            [
                'label' => esc_html__( 'Indicators', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_wualye25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_coj0hp25',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 200,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators .tp-title-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_hk1yxo25',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 200,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_up9rt425',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_up9rt425_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_hkfdm025',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators .tp-title-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_dchcfe25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_up9rt425_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_wvmb6x25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators .tp-title-icon:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_sgkotx25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-indicators .tp-title-icon:hover svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Preview_style_secdddtion',
            [
                'label' => esc_html__( 'Preview', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_y3xf7025',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 200,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_kli8j625',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_h1jp9b25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview ' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_4auy9f25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_4auy9f25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_rxjpx425',
                array(
            
            'label' => esc_html__( 'Overlay Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview::after' => 'background: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_yvkn7525',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview',
        )
            );
$this->add_responsive_control('dimension_2zj8xl25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_4qiooq25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_4auy9f25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_17sk0125',
                array(
            
            'label' => esc_html__( 'Overlay Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview:hover::after' => 'background: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_33lpir25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_k38s3625',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview:hover', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_4auy9f25_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_ery63g25',
                array(
            
            'label' => esc_html__( 'Overlay Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-preview.active::after' => 'background: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_k5s2kh25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview.active',
        )
            );
$this->add_responsive_control('dimension_frxe7v25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_ihbl5125',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-ptf-slider-preview .wkit-preview.active', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Background_style_secdddtion',
            [
                'label' => esc_html__( 'Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_yb7lir25',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('slider_6n4dyg25',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1200,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-main' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_33fins25',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%","vh", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1200,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'vh' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-main' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_control('color_cu83vn25',
                array(
            
            'label' => esc_html__( 'Overlay Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-wrapper::after' => 'background: {{VALUE}}',),
        )
            );
$this->start_controls_tabs('normalhover_ha83pm25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_ha83pm25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_psd5gs25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-portfolio-slider-wrapper',
        )
            );
$this->add_responsive_control('dimension_h4j9bg25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-portfolio-slider-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_8uvrzd25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-portfolio-slider-wrapper', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_ha83pm25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_rvxxi025',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-portfolio-slider-wrapper:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_gdyh2f25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-portfolio-slider-wrapper:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_fiksmk25 = !empty($settings['select_fiksmk25']) ? $this->wdk_senitize_js($settings['select_fiksmk25']) : '';
$iconscontrol_mobzt225 = "";
                        if(!empty($settings['iconscontrol_mobzt225']) && !empty($settings['iconscontrol_mobzt225']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($settings['iconscontrol_mobzt225'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_mobzt225 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$iconscontrol_obp4mc25 = "";
                        if(!empty($settings['iconscontrol_obp4mc25']) && !empty($settings['iconscontrol_obp4mc25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($settings['iconscontrol_obp4mc25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_obp4mc25 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$switcher_jc6z7025 = !empty($settings['switcher_jc6z7025']) ? $settings['switcher_jc6z7025'] : '';
$rawhtml_hfb7ng25 = !empty($settings['rawhtml_hfb7ng25']) ? $this->wdk_senitize_js($settings['rawhtml_hfb7ng25']) : '';
$rawhtml_gfrqoe25 = !empty($settings['rawhtml_gfrqoe25']) ? $this->wdk_senitize_js($settings['rawhtml_gfrqoe25']) : '';

        $repeater_wz94k025_6725 = '';
                            if ( $settings['repeater_wz94k025'] ) {
                                foreach ( $settings['repeater_wz94k025'] as $key => $r_item ) {
                                    $url_cveyou25_is_external = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['is_external']) ? '_blank' : '';
$url_cveyou25_url = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['url'])? $r_item['url_cveyou25']['url'] : '';
$url_cveyou25_nofollow = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['nofollow'])? 'nofollow' : '';
$media_g4gcgo25 = !empty($r_item['media_g4gcgo25']['url']) ? $this->wdk_senitize_js($r_item['media_g4gcgo25']['url']) : '';

                                    $repeater_wz94k025_6725 .= '<a href="'.$url_cveyou25_url.'" class="title-link elementor-repeater-item-' .esc_attr($r_item['_id']) . '" data-title="' . $this->wdk_senitize_js($r_item['text_y8b9d425']) . '" data-repeater_wz94k025="{repeater_wz94k025}" target="'.$url_cveyou25_is_external.'" rel="'.$url_cveyou25_nofollow.'">' . $this->wdk_senitize_js($r_item['text_y8b9d425']) . '</a>';
                                }
                            }$repeater_wz94k025_zd25 = '';
                            if ( $settings['repeater_wz94k025'] ) {
                                foreach ( $settings['repeater_wz94k025'] as $key => $r_item ) {
                                    $url_cveyou25_is_external = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['is_external']) ? '_blank' : '';
$url_cveyou25_url = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['url'])? $r_item['url_cveyou25']['url'] : '';
$url_cveyou25_nofollow = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['nofollow'])? 'nofollow' : '';
$media_g4gcgo25 = !empty($r_item['media_g4gcgo25']['url']) ? $this->wdk_senitize_js($r_item['media_g4gcgo25']['url']) : '';

                                    $repeater_wz94k025_zd25 .= '<p class="wdk-count-indi elementor-repeater-item-' .esc_attr($r_item['_id']) . '" data-repeater_wz94k025="{repeater_wz94k025}"></p>';
                                }
                            }$repeater_wz94k025_g825 = '';
                            if ( $settings['repeater_wz94k025'] ) {
                                foreach ( $settings['repeater_wz94k025'] as $key => $r_item ) {
                                    $url_cveyou25_is_external = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['is_external']) ? '_blank' : '';
$url_cveyou25_url = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['url'])? $r_item['url_cveyou25']['url'] : '';
$url_cveyou25_nofollow = !empty($r_item['url_cveyou25']) && !empty($r_item['url_cveyou25']['nofollow'])? 'nofollow' : '';
$media_g4gcgo25 = !empty($r_item['media_g4gcgo25']['url']) ? $this->wdk_senitize_js($r_item['media_g4gcgo25']['url']) : '';

                                    $repeater_wz94k025_g825 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-preview active" data-repeater_wz94k025="{repeater_wz94k025}" data-src="'.$media_g4gcgo25.'">
                    <img class="wkit-preview-img" src="'.$media_g4gcgo25.'" alt="Preview Image">
                </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_acgwnt25" data-wdkitunique="acgwnt25">';
            $output .= '<div class="wkit-portfolio-slider-main" data-arrowrotate="'.$switcher_jc6z7025.'">
    <div class="wkit-portfolio-slider-wrapper">
            <div class="wkit-slider-images">
                <div class="wkit-slider-img">
                    <img src="" alt="Portfolio Image">
                </div>
            </div>

            <div class="wkit-portfolio-title">
                <div class="slider-title-wrapper">
                    '.$repeater_wz94k025_6725.'
                </div>
            </div>
            <div class="wkit-port-nav '.$select_fiksmk25.'">
            <div class="wkit-slider-counter">
                <div class="wkit-counter">
                    '.$repeater_wz94k025_zd25.'
                </div>
                <div class="dash-main"><p class="long-dash"></p></div>
                <div><p class="counter-total"></p></div>
            </div>

            <div class="wkit-ptf-slider-preview">
                '.$repeater_wz94k025_g825.'
            </div>
            </div>
                    <div class="wkit-ptf-slider-indicators">
            <p>'.$iconscontrol_mobzt225.'</p>
            <p>'.$iconscontrol_obp4mc25.'</p>
        </div>
        </div>

</div>
   
  ';
        $output .= '</div>';
        
        echo $output;
    }
}