<?php
/*
 * Widget Name: Vertical Level
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Vertical_Level_15la2123
 */
class Wdkit_Vertical_Level_15la2123 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-15la2123';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Vertical Level', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-navigation-vertical';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Vertical Level','Step by Step Guide','Creative Representation','Procedural Information','Website Processes','Visual Clarity','Vertical Steps');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_ec5cdv25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Vertical-Level_15la2123/Vertical_Level_15la2123.js', array(), '1.2.17.800480', true );

        return [ 'wkit_child_script_ec5cdv25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        wp_enqueue_style( 'wd_css_ex_1_ou1oz125', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css', false, '1.2.17.214995', 'all' );
wp_enqueue_style( 'wd_css_ex_1_jdxzm625', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css', false, '1.2.17.995240', 'all' );


        wp_enqueue_style( 'wkit_css_1_ay15aq25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Vertical-Level_15la2123/Vertical_Level_15la2123.css', false, '1.2.17.960162', 'all' );

        return [ 'wkit_css_1_ay15aq25' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Layout_tab_content',
            [
                'label' => esc_html__( 'Layout', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_nhr9qd23',
                array(
            
            'label' => esc_html__( 'Style', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'style-1',
            
            'options' => array( 'style-1'  => esc_html__( 'Dot', 'wdesignkit' ),'style-2'  => esc_html__( 'Number', 'wdesignkit' ),'style-3'  => esc_html__( 'Check Mark', 'wdesignkit' ), ),
        )
            );
$this->add_control('rawhtml_lnmw3p25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: You must enable the ACTIVE field from Repeater when choosing Check Mark to show an active icon.
</div>', 'wdesignkit' ),
            
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-3'),
],
                ),
        )
            );
$this->end_controls_section();$this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_u9v03z25 = new \Elementor\Repeater();

                $repeater_u9v03z25->add_control('select_ej7gme23',
                array(
            
            'label' => esc_html__( 'Select', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'text',
            
            'options' => array( 'text'  => esc_html__( 'Text', 'wdesignkit' ),'icon'  => esc_html__( 'Icon', 'wdesignkit' ),'image'  => esc_html__( 'Image', 'wdesignkit' ), ),
        )
            );
$repeater_u9v03z25->add_control('text_vx4ivy23',
                array(
            
            'label' => esc_html__( 'Title', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Acquire', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'text'),
],
                ),
        )
            );
$repeater_u9v03z25->add_control('iconscontrol_e0tko023',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-home',
                'library' => 'fa-solid',
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'icon'),
],
                ),
        )
            );
$repeater_u9v03z25->add_control('media_8061n023',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array("image","svg"),
           
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'image'),
],
                ),
        )
            );
$repeater_u9v03z25->add_control('wysiwyg_4wbmqg23',
                array(
                
                'label' => esc_html__( 'Description', 'wdesignkit' ),
				'type' => Controls_Manager::WYSIWYG,
                'ai'   => [ 'active' => false ],
                'default' => esc_html__( 'Discover all available features in WDesignKit.', 'wdesignkit' ),
                
                
                
                'label_block' => true,
                
                
                
                
        )
            );
$repeater_u9v03z25->add_control('switcher_lryedf23',
                array(
            
            'label' => esc_html__( 'Active', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$repeater_u9v03z25->add_control('heading_ur4f3t23',
                array(
            
            'label' => esc_html__( 'Normal', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$repeater_u9v03z25->add_control('color_2ynyfv23',
                array(
            
            'label' => esc_html__( 'Title Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'text'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-step-title' => 'color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_lrsetc23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'icon'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-progress-icon' => 'color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_ectcij24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'icon'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-progress-icon .tp-title-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_xp4j5c23',
                array(
            
            'label' => esc_html__( 'Description Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-step-desc' => 'color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('heading_iypfma23',
                array(
            
            'label' => esc_html__( 'Hover', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$repeater_u9v03z25->add_control('color_jhnu2423',
                array(
            
            'label' => esc_html__( 'Title Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'text'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-step-title:hover' => 'color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_c38r5j23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'icon'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-progress-icon:hover' => 'color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_etqjac24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_ej7gme23', 'operator' => '==', 'value' => 'icon'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-progress-icon:hover .tp-title-icon svg' => 'fill: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_a1phqu23',
                array(
            
            'label' => esc_html__( 'Description Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper {{CURRENT_ITEM}} .wkit-vl-step-desc:hover' => 'color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_iyhbs023',
                array(
            
            'label' => esc_html__( 'Dot Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            'separator' => 'before',
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_lryedf23', 'operator' => '!=', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .wkit-vl-pix-levels-dot' => 'background-color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_r50bao23',
                array(
            
            'label' => esc_html__( 'Active Dot Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            'separator' => 'before',
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_lryedf23', 'operator' => '==', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}}.wkit-vl-active-yes .wkit-vl-pix-levels-dot' => 'background-color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_0hfwjr23',
                array(
            
            'label' => esc_html__( 'Inner Dot Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_lryedf23', 'operator' => '!=', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .wkit-vl-pix-levels-dot-inner' => 'background-color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_pobie923',
                array(
            
            'label' => esc_html__( 'Active Inner Dot Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_lryedf23', 'operator' => '==', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}}.wkit-vl-active-yes .wkit-vl-pix-levels-dot-inner' => 'background-color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_fzwbk523',
                array(
            
            'label' => esc_html__( 'Progress Bar Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_lryedf23', 'operator' => '!=', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}} .wkit-bg-gray-2,{{CURRENT_ITEM}} .wkit-vl-bg-gradient-primary' => 'background-color: {{VALUE}}',),
        )
            );
$repeater_u9v03z25->add_control('color_jl0z0m23',
                array(
            
            'label' => esc_html__( 'Active Progress Bar Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'switcher_lryedf23', 'operator' => '==', 'value' => 'yes'),
],
                ),
            'selectors' => array('{{WRAPPER}} {{CURRENT_ITEM}}.wkit-vl-active-yes .wkit-bg-gray-2,{{CURRENT_ITEM}}.wkit-vl-active-yes .wkit-vl-bg-gradient-primary' => 'background-color: {{VALUE}}',),
        )
            );

                
                $this->add_control('repeater_8rn0w223',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Levels', 'wdesignkit' ),
                
                
                
                
                
				'fields' => $repeater_u9v03z25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-a25y3y25'),
'select_ej7gme23' => 'text',
'text_vx4ivy23' => esc_html__('Acquire', 'wdesignkit'), 
'iconscontrol_e0tko023' => 'fas fa-home', 
'media_8061n023' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'wysiwyg_4wbmqg23' => 'Discover all available features in WDesignKit.', 
'switcher_lryedf23' => false,
'heading_ur4f3t23' => esc_html__('', 'wdesignkit'), 
'color_2ynyfv23' => '', 
'color_lrsetc23' => '', 
'color_ectcij24' => '', 
'color_xp4j5c23' => '', 
'heading_iypfma23' => esc_html__('', 'wdesignkit'), 
'color_jhnu2423' => '', 
'color_c38r5j23' => '', 
'color_etqjac24' => '', 
'color_a1phqu23' => '', 
'color_iyhbs023' => '', 
'color_r50bao23' => '', 
'color_0hfwjr23' => '', 
'color_pobie923' => '', 
'color_fzwbk523' => '', 
'color_jl0z0m23' => '', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_xs5hws25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/vertical-level/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Content_style_secdddtion',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->start_controls_tabs('normalhover_qm10we23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_qm10we23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('slider_0ke3lt23',
                array(
            
            'label' => esc_html__( 'Opacity (%)', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "%", ),
            
            
            'range' => array('%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 10,
					),),
            'default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
            
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-vl-step-content.wkit-vl-pix-levels-step' => 'opacity: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qm10we23_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('slider_61xyvz23',
                array(
            
            'label' => esc_html__( 'Opacity (%)', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "%", ),
            
            
            'range' => array('%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 10,
					),),
            'default' => array(
                                    'unit' => '%',
                                    'size' => '',
                                ),
            
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-vl-step-content.wkit-vl-pix-levels-step.wkit-vl-active-yes' => 'opacity: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_wjotla25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: You can apply here different opacity for Normal level & Active level.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Title_style_secdddtion',
            [
                'label' => esc_html__( 'Title', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_5chiij23',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('dimension_ev1anw23',
                array(
            
            'label' => esc_html__( 'Margin', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_o0oh3t23',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-title',
			)
            );
$this->start_controls_tabs('normalhover_82bgd023',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_82bgd023_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_9y0up723',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_82bgd023_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_chjm5523',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-title:hover' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_82bgd023_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_ulpqga23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-active-yes .wkit-vl-step-title' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_rbyreq25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Note: If a property is already applied to the main card, then the property applied here will not take effect.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Description_style_secdddtion',
            [
                'label' => esc_html__( 'Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_vtvtbr23',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('dimension_51azh123',
                array(
            
            'label' => esc_html__( 'Margin', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_s8eoip23',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-desc',
			)
            );
$this->start_controls_tabs('normalhover_nul8mm23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_nul8mm23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_1eyj9i23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_nul8mm23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_ffmmbb23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-desc:hover' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_nul8mm23_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_67p52023',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-active-yes .wkit-vl-step-desc' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_nnoem725',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Note: If a property is already applied to the main card, then the property applied here will not take effect.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Icon_style_secdddtion',
            [
                'label' => esc_html__( 'Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_4f9ksm23',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 200,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content .wkit-vl-progress-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_d7b6ss23',
                array(
            
            'label' => esc_html__( 'SVG Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content .wkit-vl-progress-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_l75g4b23',
                array(
            
            'label' => esc_html__( 'SVG Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 500,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content .wkit-vl-progress-icon svg' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_8rtkwq23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_8rtkwq23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_l9hrrk23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content .wkit-vl-progress-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_kkn96a23',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content .wkit-vl-progress-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_8rtkwq23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_wwnfak23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content:hover .wkit-vl-progress-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_4duwxh23',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content:hover .wkit-vl-progress-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->add_control('rawhtml_exh80a25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Note: If a property is already applied to the main card, then the property applied here will not take effect.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Image_style_secdddtion',
            [
                'label' => esc_html__( 'Image', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_17rycx23',
                array(
            
            'label' => esc_html__( 'Left Offset', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 2000,
						'step' => 3,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content .wkit-vl-progress-img' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_bsl6pe23',
                array(
            
            'label' => esc_html__( 'Image Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content.wkit-vl-image .wkit-vl-progress-img .tp-vl-title-image' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_j9dvec25',
                array(
            
            'label' => esc_html__( 'Image Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content.wkit-vl-image .wkit-vl-progress-img .tp-vl-title-image' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_2mmjo823',
                array(
            
            'label' => esc_html__( 'Image Bottom Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content.wkit-vl-image .wkit-vl-progress-img .tp-vl-title-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Dots_style_secdddtion',
            [
                'label' => esc_html__( 'Dots', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('slider_s463kb23',
                array(
            
            'label' => esc_html__( 'Progress Bar Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 20,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 8,
                                ),
            
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-pix-levels-step .progress' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_sjel8l23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_sjel8l23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('heading_80ntvk23',
                array(
            
            'label' => esc_html__( 'Dots', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_control('color_1q7id323',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-pix-levels-dot' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_control('heading_z2n3ui23',
                array(
            
            'label' => esc_html__( 'Inner Dots', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('color_av4gsa23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-pix-levels-dot-inner' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_control('heading_1hnarx23',
                array(
            
            'label' => esc_html__( 'Progress Bar', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('color_3vcprb23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-bg-gray-2,.wkit-multi-step-vl-wrapper .wkit-vl-bg-gradient-primary' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_sjel8l23_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('heading_d0oggu23',
                array(
            
            'label' => esc_html__( 'Dots', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_control('color_xqa3oq23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-active-yes .wkit-vl-pix-levels-dot' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_control('heading_huci9g23',
                array(
            
            'label' => esc_html__( 'Inner Dots', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('color_tag0qi23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-active-yes .wkit-vl-pix-levels-dot-inner' => 'background-color: {{VALUE}}',),
        )
            );
$this->add_control('heading_4n08bi23',
                array(
            
            'label' => esc_html__( 'Progress Bar', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_control('color_n94v6o23',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-active-yes .wkit-bg-gray-2,{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-active-yes .wkit-vl-bg-gradient-primary' => 'background-color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Number_style_secdddtion',
            [
                'label' => esc_html__( 'Number', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-2'],
],
                ),
            ]
        );
$this->add_responsive_control('slider_j8anjs23',
                array(
            
            'label' => esc_html__( 'Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 40,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-2 .wkit-prg-two:before' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_mclzct24',
                array(
            
            'label' => esc_html__( 'Top Offset', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 40,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-2'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-2 .wkit-prg-two:before' => 'top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_hi79cb23',
                array(
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-2'),
],
                ),
        )
            );
            $this->start_controls_tab(

                        'normalhover_hi79cb23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_p0839w23',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-2 .wkit-prg-two:before' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_hi79cb23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_0fsle923',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-2 .wkit-prg-two:hover:before, .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-2 .wkit-vl-active-yes .wkit-prg-two:hover:before' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_hi79cb23_active_tab',
                            array(
                                'label' => esc_html__( 'Active', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_qgd3pi23',
                array(
            
            'label' => esc_html__( 'Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-2 .wkit-vl-active-yes .wkit-prg-two:before' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Checked Icon_style_secdddtion',
            [
                'label' => esc_html__( 'Checked Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => array(
                    'relation' => 'or',
                    'terms' => [['name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-3'],
],
                ),
            ]
        );
$this->add_responsive_control('slider_zasg0323',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 40,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-3'),
],
                ),
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-3 .wkit-vl-pix-levels-dot-inner.wkit-vl-check-mark:before' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_810qo123',
                array(
            
            'conditions' => array(
                    'relation' => 'or',
                    'terms' => [array('name' => 'select_nhr9qd23', 'operator' => '==', 'value' => 'style-3'),
],
                ),
        )
            );
            $this->start_controls_tab(

                        'normalhover_810qo123_hover_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_yn7qqw23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-3 .wkit-vl-pix-levels-dot-inner.wkit-vl-check-mark:before' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_810qo123_active_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_vkzjwf23',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-inner-style-3 .wkit-vl-pix-levels-dot-inner.wkit-vl-check-mark:hover:before' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Box Background_style_secdddtion',
            [
                'label' => esc_html__( 'Box Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_h90zss23',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-content-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_responsive_control('dimension_z0q74o23',
                array(
            
            'label' => esc_html__( 'Margin', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-content-bg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->start_controls_tabs('normalhover_cgv0nk23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_cgv0nk23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_z81eny23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-step-content',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_asyv9l23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-content-bg',
        )
            );
$this->add_responsive_control('dimension_ql5iwo23',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-content-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_waz3yx23',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper .wkit-vl-content-bg', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_cgv0nk23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_tna86r23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper:hover .wkit-vl-step-content',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_idqltp23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper:hover .wkit-vl-content-bg',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_8vghll23',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-multi-step-vl-wrapper:hover .wkit-vl-content-bg', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_nhr9qd23 = !empty($settings['select_nhr9qd23']) ? $this->wdk_senitize_js($settings['select_nhr9qd23']) : '';
$rawhtml_lnmw3p25 = !empty($settings['rawhtml_lnmw3p25']) ? $this->wdk_senitize_js($settings['rawhtml_lnmw3p25']) : '';
$rawhtml_xs5hws25 = !empty($settings['rawhtml_xs5hws25']) ? $this->wdk_senitize_js($settings['rawhtml_xs5hws25']) : '';

        $repeater_8rn0w223_1r25 = '';
                            if ( $settings['repeater_8rn0w223'] ) {
                                foreach ( $settings['repeater_8rn0w223'] as $key => $r_item ) {
                                    $iconscontrol_e0tko023 = "";
                        if(!empty($r_item['iconscontrol_e0tko023']) && !empty($r_item['iconscontrol_e0tko023']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_e0tko023'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_e0tko023 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$media_8061n023 = !empty($r_item['media_8061n023']['url']) ? $this->wdk_senitize_js($r_item['media_8061n023']['url']) : '';

                                    $repeater_8rn0w223_1r25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-vl-step-content wkit-vl-' . $this->wdk_senitize_js($r_item['select_ej7gme23']) . ' wkit-vl-pix-levels-step wkit-vl-active-' . $r_item['switcher_lryedf23'] . ' col-xs-12 col-md-3" data-repeater_8rn0w223="{repeater_8rn0w223}">
                <h6 class="wkit-vl-step-title text-center" data-ttl="' . $this->wdk_senitize_js($r_item['text_vx4ivy23']) . '">' . $this->wdk_senitize_js($r_item['text_vx4ivy23']) . '</h6>
                <span class="wkit-vl-progress-icon">'.$iconscontrol_e0tko023.'</span>
                <div class="wkit-vl-progress-img">
                     <img src="'.$media_8061n023.'" class="tp-vl-title-image">
                </div>
                <div class="wkit-progress-area text-center">
                    <div class="progress wkit-bg-gray-2">
                        <div class="wkit-prg-one progress-bar wkit-vl-bg-gradient-primary">
                        </div>
                    </div>
                    <div class="wkit-pix-leveles-dot-div">
                        <span class="wkit-prg-two wkit-vl-pix-levels-dot wkit-vl-bg-gradient-primary" data-index="'.$key.'">
                            <span class="wkit-vl-pix-levels-dot-inner wkit-vl-bg-dark-opacity-3"></span>
                        </span>
                    </div>
                </div>
                <span class="wkit-vl-step-desc text-center" data-desc="' . $this->wdk_senitize_js($r_item['wysiwyg_4wbmqg23']) . '">' . $this->wdk_senitize_js($r_item['wysiwyg_4wbmqg23']) . '</span>
            </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_15la2123" data-wdkitunique="15la2123">';
            $output .= '<div class="wkit-multi-step-vl-wrapper text-center">
    <div class="wkit-vl-card wkit-vl-inner-'.$select_nhr9qd23.'">
        <div class="wkit-vl-content-bg row">
            '.$repeater_8rn0w223_1r25.'
        </div>
    </div>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}