<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package    NanoSpace
 * @copyright  Labinator
 *
 * @since 1.0.0
 * @version 1.0.0
 */

get_header();

while ( have_posts() ) {
	the_post();

	/**
	 * Include the Post-Format-specific template for the content.
	 * If you want to override this in a child theme, then include a file
	 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
	 *
	 * Or, you can use the filter hook below to modify which content file to load.
	 */
	get_template_part( 'templates/parts/content/content', apply_filters( 'nanospace_single_content_type', get_post_format() ) );

	// If comments are open or we have at least one comment, load up the comment template.

	if ( comments_open() || get_comments_number() ) {
		comments_template( '', true );
	}
}

get_footer();
