<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    var fields = document.querySelectorAll('#formulaire-pdp input, #formulaire-pdp textarea, #formulaire-pdp select');

    fields.forEach(function(field) {
        // Fonction pour appliquer le fond voulu
        function applyBackground() {
            field.style.backgroundColor = '#FFC0CB'; // rose normal
            field.style.outline = 'none';
            field.style.boxShadow = 'none';
        }

        // Appliquer au chargement
        applyBackground();

        // Focus
        field.addEventListener('focus', applyBackground);

        // Blur
        field.addEventListener('blur', applyBackground);

        // Hover
        field.addEventListener('mouseover', function() {
            field.style.backgroundColor = '#F6E7DE'; // beige hover
        });
        field.addEventListener('mouseout', function() {
            applyBackground(); // revient toujours au rose
        });
    });

    // En cas de JS externe qui réinjecte du bleu, on peut réappliquer périodiquement (optionnel)
    setInterval(function() {
        fields.forEach(applyBackground);
    }, 500);
});
</script>
<!-- end Simple Custom CSS and JS -->
