<?php
/*
 * Widget Name: Swipe Button
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Swipe_Button_mvznkd23
 */
class Wdkit_Swipe_Button_mvznkd23 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-mvznkd23';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Swipe Button', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-button';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Swipe Button','CTA');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_w97eq825', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Swipe-Button_mvznkd23/Swipe_Button_mvznkd23.css', false, '1.2.17.916990', 'all' );

        return [ 'wkit_css_1_w97eq825' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('text_a2tl8t23',
                array(
            
            'label' => esc_html__( 'Button Text', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Learn More', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$this->add_control('url_xhyz9y23',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$this->add_control('iconscontrol_dj5gjt23',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fas fa-chevron-right',
                'library' => 'fa-solid',
            ),
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_gga2vw23',
                array(
            
            'label' => esc_html__( 'Icon Position', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'before',
            
            'options' => array( 'before'  => esc_html__( 'Before', 'wdesignkit' ),'after'  => esc_html__( 'After', 'wdesignkit' ), ),
        )
            );
$this->add_responsive_control('choose_ioive023',
                array(
            
            'label' => esc_html__( 'Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'start' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'end' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn-main' => 'justify-content: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_56zs4d25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/swipe-button/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Button Style_style_secdddtion',
            [
                'label' => esc_html__( 'Button Style', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('dimension_frabre23',
                array(
            
            'label' => esc_html__( 'Padding', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_r0bhug23',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-btn-text',
			)
            );
$this->start_controls_tabs('normalhover_bvoxjo23',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_bvoxjo23_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_bryhtd23',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn-text' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_gfxcm725',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Gradient color should be 50% on both side and angle 90%
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_g840zn23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-swipe-btn',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_fr0u3f23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-swipe-btn',
        )
            );
$this->add_responsive_control('dimension_bp67dx23',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_3wzbi523',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-swipe-btn', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_bvoxjo23_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_fdyk2623',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn:hover .wkit-swipe-btn-text' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('rawhtml_7103dj25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400;
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: Gradient color should be 50% on both side and angle 90%
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_bccjjx23',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-swipe-btn:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_mhzvwb23',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-swipe-btn:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_d3tc3a23',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-swipe-btn:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Icon_style_secdddtion',
            [
                'label' => esc_html__( 'Icon', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_s7a16l23',
                array(
            
            'label' => esc_html__( 'Icon Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn' => 'gap: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_xltx9t23',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_r4o85p25',
                array(
            
            'label' => esc_html__( 'Icon Stroke Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 10,
						'step' => 0.5,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon i' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_y759fy24',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_sl8fba25',
                array(
            
            'label' => esc_html__( 'SVG Stroke Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 10,
						'step' => 0.5,
					),'%' => array(
						'min' => 0,
						'max' => 10,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon svg path' => 'stroke-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_qbwq0l25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_qbwq0l25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_cxxh2623',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_d8uncm25',
                array(
            
            'label' => esc_html__( 'Icon Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon i' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->add_control('color_zrf0yd24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_s9s44725',
                array(
            
            'label' => esc_html__( 'SVG Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon i, {{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_qbwq0l25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_kuiyv223',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn:hover .wkit-swipe-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_jurfac25',
                array(
            
            'label' => esc_html__( 'Icon Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn:hover .wkit-swipe-icon .tp-title-icon i' => '-webkit-text-stroke-color: {{VALUE}}',),
        )
            );
$this->add_control('color_pbceup24',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn:hover .wkit-swipe-icon .tp-title-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_control('color_ulx3n125',
                array(
            
            'label' => esc_html__( 'SVG Stroke Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-swipe-btn .wkit-swipe-icon .tp-title-icon i, {{WRAPPER}} .wkit-swipe-btn:hover .wkit-swipe-icon .tp-title-icon svg path' => 'stroke: {{VALUE}}',),
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $text_a2tl8t23 = !empty($settings['text_a2tl8t23']) ? $this->wdk_senitize_js($settings['text_a2tl8t23']) : '';
$url_xhyz9y23_url = !empty($settings['url_xhyz9y23']) && !empty($settings['url_xhyz9y23']['url']) ? $this->wdk_senitize_js($settings['url_xhyz9y23']['url']) : '';
$url_xhyz9y23_is_external = !empty($settings['url_xhyz9y23']) && !empty($settings['url_xhyz9y23']['is_external']) ? '_blank' : '';
$url_xhyz9y23_nofollow = !empty($settings['url_xhyz9y23']) && !empty($settings['url_xhyz9y23']['nofollow']) ? 'nofollow' : '';
$url_xhyz9y23_custmAtr = !empty($settings['url_xhyz9y23']) && !empty($settings['url_xhyz9y23']['custom_attributes']) ? $settings['url_xhyz9y23']['custom_attributes'] : '';
                $url_xhyz9y23_atr = '';
        
                if( !empty( $url_xhyz9y23_custmAtr ) ){
                    $url_xhyz9y23_custmAtr = trim( $url_xhyz9y23_custmAtr, " " );
                    $main_array = explode( ",", $url_xhyz9y23_custmAtr );

                    foreach ( $main_array as $key => $value ) {
                        if( !empty( $value ) ){
                            $ct_array = explode( "|", $value );
                            $url_xhyz9y23_atr .= $ct_array[0] .' = "'. $ct_array[1].'"';
                        }
                    }
                }$iconscontrol_dj5gjt23 = "";
                        if(!empty($settings['iconscontrol_dj5gjt23']) && !empty($settings['iconscontrol_dj5gjt23']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($settings['iconscontrol_dj5gjt23'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_dj5gjt23 .= '<span class="tp-title-icon">'.$Icon.'</span>';
                        };
$select_gga2vw23 = !empty($settings['select_gga2vw23']) ? $this->wdk_senitize_js($settings['select_gga2vw23']) : '';
$choose_ioive023 = !empty($settings['choose_ioive023']) ? $this->wdk_senitize_js($settings['choose_ioive023']) : '';
$rawhtml_56zs4d25 = !empty($settings['rawhtml_56zs4d25']) ? $this->wdk_senitize_js($settings['rawhtml_56zs4d25']) : '';

        

        $output = '';
        $output .= '<div class="wkit-wb-Widget_mvznkd23" data-wdkitunique="mvznkd23">';
            $output .= '<div class="wkit-swipe-btn-main">
    <a href="'.$url_xhyz9y23_url.'" target="'.$url_xhyz9y23_is_external.'" rel="'.$url_xhyz9y23_nofollow.'">
        <div class="wkit-swipe-btn '.$select_gga2vw23.'">
            <div class="wkit-swipe-btn-text">'.$text_a2tl8t23.'</div>
            <div class="wkit-swipe-icon">'.$iconscontrol_dj5gjt23.' </div>
        </div>
   </a>
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}