<?php
/*
 * Widget Name: Team with Sliding Info
 * Author: POSIMYTH
 * Author URI: https://posimyth.com
 * 
 * @package wdesignkit
 */


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Wdkit_Team_with_Sliding_Info_f5p7zn25
 */
class Wdkit_Team_with_Sliding_Info_f5p7zn25 extends Widget_Base {

    /**
     * Get Widget Name.
     *
     * @since 1.2.17
     */
    public function get_name() {
        return 'wb-f5p7zn25';
    }

    /**
     * Get Widget Title.
     *
     * @since 1.2.17
     */
    public function get_title() {
        return esc_html__('Team with Sliding Info', 'wdesignkit');
    }

    
    /**
     * Get Widget Icon.
     *
     * @since 1.2.17
     */
    public function get_icon() {
        return 'eicon-user-circle-o';
    }

    /**
     * Get Widget categories.
     *
     * @since 1.2.17
     */
    public function get_categories() {
        $GG_Databash = get_option( "wkit_builder" );
        if ( (empty($GG_Databash) || $GG_Databash == false) ) {
            return array('WDesignKit');
        }else{
            if( in_array( 'WDesignKit', $GG_Databash ) ){

                return array('WDesignKit');
            }else{
                return array('WDesignKit');
            }
        }
    }

    /**
     * Get Widget keywords.
     *
     * @since 1.2.17
     */
    public function get_keywords() {
        return array('Team with Sliding Info','Team Showcase','Sliding Info','Elementor Widget','WordPress Plugin','Interactive Design','Business Website Tool','Compact Team Layout');
    }

    

    /**
        * Prevent JS senitizer
        *
        * @since 1.2.4
        * */
        function wdk_senitize_js( $input ) {

            $input = preg_replace( '/&#x[0-9a-fA-F]+;/i', '', $input );

            // Remove complete iframe tags with or without content
            $input = preg_replace( '/<iframe[^>]*>.*?<\/iframe>/is', '', $input );

            // Remove incomplete iframe tags
            $input = preg_replace( '/<iframe[^>]*\/?>/is', '', $input );

            // Remove JavaScript pseudo-protocols (like javascript:)
            $input = preg_replace( '/javascript\s*:/i', '', $input );

            // Remove JavaScript event handlers (like onload, onclick, etc.)
            $input = preg_replace( '/\s*on\w+\s*=\s*(".*?"|\'.*?\'|[^>\s]+)/is', '', $input );

            // Ensure input is not overly stripped by handling invalid tags carefully
            $input = strip_tags( $input );

            return trim( $input );
        }

    

    

    /**
    * Get Widget Scripts
    *
    * @since 1.2.17
    */
    public function get_script_depends() {
        
        /**External js enqueue*/
        

        wp_enqueue_script( 'wkit_child_script_ooqv2p25', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Team-with-Sliding-Info_f5p7zn25/Team_with_Sliding_Info_f5p7zn25.js', array(), '1.2.17.426837', true );

        return [ 'wkit_child_script_ooqv2p25' ];
    }

    /**
    * Get Widget Styles
    *
    * @since 1.2.17
    */
    public function get_style_depends() {
        
        /**External Css enqueue*/
        

        wp_enqueue_style( 'wkit_css_1_js0z4425', wp_upload_dir()['baseurl'].'/wdesignkit/elementor/Team-with-Sliding-Info_f5p7zn25/Team_with_Sliding_Info_f5p7zn25.css', false, '1.2.17.236060', 'all' );

        return [ 'wkit_css_1_js0z4425' ];
    }

    

    /**
     * Register controls.
     *
     * @since 1.2.17
     */
    protected function register_controls() {

            $this->start_controls_section('Content_tab_content',
            [
                'label' => esc_html__( 'Content', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$repeater_vymvsh25 = new \Elementor\Repeater();

                $repeater_vymvsh25->add_control('media_m15gm525',
                array(
            
            'label' => esc_html__( 'Select Image', 'wdesignkit' ),
            'type' => Controls_Manager::MEDIA,
            'ai'   => [ 'active' => false ],
            
            'default' => array(
                'url' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png',
            ),
            
            'label_block' => true,
            
            'media_types' => array(),
           'dynamic' => array(
                'active' => true,
            ),
            
            
        )
            );
$repeater_vymvsh25->add_control('text_k97ctl25',
                array(
            
            'label' => esc_html__( 'Name', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'James Kinay', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_vymvsh25->add_control('text_nyzx7525',
                array(
            
            'label' => esc_html__( 'Designation', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'Sales Manager', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            'dynamic' => array(
                'active' => true,
            ),
            
        )
            );
$repeater_vymvsh25->add_control('textarea_u91pvf25',
                array(
            
            'type' => Controls_Manager::TEXTAREA,
            'ai'   => [ 'active' => false ],
            'label' => esc_html__( 'Description', 'wdesignkit' ),
            
            
            'label_block' => true,
            
            'rows' => '2',
            
            'default' => esc_html__( 'The Interactive Links widget from WDesignKit’s Free Plan lets you create engaging and dynamic hover effects on your WordPress site. When users hover over a link, name, or CTA, the background image changes seamlessly, enhancing the browsing experience.', 'wdesignkit' ),
            
            
            
        )
            );
$repeater_vymvsh25->add_control('text_dymg2u25',
                array(
            
            'label' => esc_html__( 'Tel', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( '+9112929929', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_vymvsh25->add_control('text_weefrh25',
                array(
            
            'label' => esc_html__( 'Email', 'wdesignkit' ),
            'type' => Controls_Manager::TEXT,
            'ai'   => [ 'active' => false ],
            'default' => esc_html__( 'brayden@example.com', 'wdesignkit' ),
            
            
            
            
            'input_type' => 'text', 
            
            
            
            
        )
            );
$repeater_vymvsh25->add_control('iconscontrol_wqep9825',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            
            
            'default' => array(
                'value' => 'fab fa-facebook-f',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_vymvsh25->add_control('url_xbe8ka25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$repeater_vymvsh25->add_control('iconscontrol_az0lbh25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            'separator' => 'before',
            
            'default' => array(
                'value' => 'fab fa-google-plus',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_vymvsh25->add_control('url_eq0yfj25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );
$repeater_vymvsh25->add_control('iconscontrol_9uud6g25',
                array(
            
            'label' => esc_html__( 'Select Icon', 'wdesignkit' ),
            'type' => Controls_Manager::ICONS,
            'fa4compatibility' => 'icon',
            
            
            'label_block' => true,
            'skin' => 'media',
            'exclude_inline_options' => array('none'),
            'separator' => 'before',
            
            'default' => array(
                'value' => 'fab fa-twitter-square',
                'library' => 'fa-solid',
            ),
            
        )
            );
$repeater_vymvsh25->add_control('url_8eg5uj25',
                array(
            
            'label' => esc_html__( 'URL', 'wdesignkit' ),
            'type' => Controls_Manager::URL,
            
            
            'options' => array('url','is_external','nofollow',),
            'default' => array(
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
                'custom_attributes' => '',
            ),
            
            'label_block' => true,
            
            
            
            
        )
            );

                
                $this->add_control('repeater_kmwp2i25',
                    array(
                
				'type' => Controls_Manager::REPEATER,
				'label' => esc_html__( 'Profile', 'wdesignkit' ),
                
                
                'label_block' => true,
                
                
				'fields' => $repeater_vymvsh25->get_controls(),
                'default' => array(array('_id'=>uniqid('Wkit-n9w4v325'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('The Interactive Links widget from WDesignKit’s Free Plan lets you create engaging and dynamic hover effects on your WordPress site. When users hover over a link, name, or CTA, the background image changes seamlessly, enhancing the browsing experience.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_wqep9825' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_az0lbh25' => 'fab fa-google-plus', 
'url_eq0yfj25' => '#', 
'iconscontrol_9uud6g25' => 'fab fa-twitter-square', 
'url_8eg5uj25' => '#', 
),
array('_id'=>uniqid('Wkit-lyp7yk25'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('The Interactive Links widget from WDesignKit’s Free Plan lets you create engaging and dynamic hover effects on your WordPress site. When users hover over a link, name, or CTA, the background image changes seamlessly, enhancing the browsing experience.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_wqep9825' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_az0lbh25' => 'fab fa-google-plus', 
'url_eq0yfj25' => '#', 
'iconscontrol_9uud6g25' => 'fab fa-twitter-square', 
'url_8eg5uj25' => '#', 
),
array('_id'=>uniqid('Wkit-lqgggt25'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('The Interactive Links widget from WDesignKit’s Free Plan lets you create engaging and dynamic hover effects on your WordPress site. When users hover over a link, name, or CTA, the background image changes seamlessly, enhancing the browsing experience.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_wqep9825' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_az0lbh25' => 'fab fa-google-plus', 
'url_eq0yfj25' => '#', 
'iconscontrol_9uud6g25' => 'fab fa-twitter-square', 
'url_8eg5uj25' => '#', 
),
array('_id'=>uniqid('Wkit-rtqy8j25'),
'media_m15gm525' => 'https://etemplates.wdesignkit.com/widgets/wp-content/plugins/wdesignkit/assets/images/jpg/placeholder.png', 
'text_k97ctl25' => esc_html__('James Kinay', 'wdesignkit'), 
'text_nyzx7525' => esc_html__('Sales Manager', 'wdesignkit'), 
'textarea_u91pvf25' => esc_html__('The Interactive Links widget from WDesignKit’s Free Plan lets you create engaging and dynamic hover effects on your WordPress site. When users hover over a link, name, or CTA, the background image changes seamlessly, enhancing the browsing experience.', 'wdesignkit'), 
'text_dymg2u25' => esc_html__('+9112929929', 'wdesignkit'), 
'text_weefrh25' => esc_html__('brayden@example.com', 'wdesignkit'), 
'iconscontrol_wqep9825' => 'fab fa-facebook-f', 
'url_xbe8ka25' => '#', 
'iconscontrol_az0lbh25' => 'fab fa-google-plus', 
'url_eq0yfj25' => '#', 
'iconscontrol_9uud6g25' => 'fab fa-twitter-square', 
'url_8eg5uj25' => '#', 
),
),
                
                     
                
        )
                );
$this->end_controls_section();$this->start_controls_section('Column_tab_content',
            [
                'label' => esc_html__( 'Column', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('select_ei4raf25',
                array(
            
            'label' => esc_html__( 'Desktop Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'desktop-column-4',
            
            'options' => array( 'desktop-column-1'  => esc_html__( 'Column 1', 'wdesignkit' ),'desktop-column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'desktop-column-3'  => esc_html__( 'Column 3', 'wdesignkit' ),'desktop-column-4'  => esc_html__( 'Column 4', 'wdesignkit' ),'desktop-column-5'  => esc_html__( 'Column 5', 'wdesignkit' ), ),
        )
            );
$this->add_control('select_9xpqnx25',
                array(
            
            'label' => esc_html__( 'Tablet Column', 'wdesignkit' ),
            'type' => Controls_Manager::SELECT,
            
            
            
            
            
            'default' => 'tablet-column-2',
            
            'options' => array( 'tablet-column-1'  => esc_html__( 'Column 1', 'wdesignkit' ),'tablet-column-2'  => esc_html__( 'Column 2', 'wdesignkit' ),'tablet-column-3'  => esc_html__( 'Column 3', 'wdesignkit' ), ),
        )
            );
$this->add_responsive_control('slider_nq7cnw25',
                array(
            
            'label' => esc_html__( 'Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item-inner' => 'margin-right: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();$this->start_controls_section('Extra Options_tab_content',
            [
                'label' => esc_html__( 'Extra Options', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_responsive_control('choose_cy532j25',
                array(
            
            'label' => esc_html__( 'Text Alignment', 'wdesignkit' ),
            
            'type' => Controls_Manager::CHOOSE,
            'options' => array(
                    'left' => array(
                        'title' => esc_html__( 'Left', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-left',
                    ),
                
                    'center' => array(
                        'title' => esc_html__( 'Center', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-center',
                    ),
                
                    'right' => array(
                        'title' => esc_html__( 'Right', 'wdesignkit' ),
                        'icon' => 'eicon-text-align-right',
                    ),
                ),
            
            'toggle' => true,
            
            
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper .wkit-personal-info' => 'text-align: {{VALUE}}',),
        )
            );
$this->add_control('switcher_rttsm925',
                array(
            
            'label' => esc_html__( 'Contact Vertical Layout', 'wdesignkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'wdesignkit' ),
            'label_off' => esc_html__( 'No', 'wdesignkit' ),
            
            'return_value' => 'yes',
            'default' => '',
            
            'label_block' => false,
            
            
            
        )
            );
$this->end_controls_section();$this->start_controls_section('Need Help ?_tab_content',
            [
                'label' => esc_html__( 'Need Help ?', 'wdesignkit' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                
            ]
        );
$this->add_control('rawhtml_gguyjc25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-help-main" style="height: 300px">
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://store.posimyth.com/helpdesk/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Raise a Ticket
    </a>
  </div>

  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://learn.wdesignkit.com/docs/team-with-sliding-info/"
      target="_blank"
      rel="noopener noreferrer"
    >
      Read Documentation
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/boards/feature-requests"
      target="_blank"
      rel="noopener noreferrer"
    >
      Suggest Feature
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://roadmap.wdesignkit.com/roadmap"
      target="_blank"
      rel="noopener noreferrer"
    >
      Plugin Roadmap
    </a>
  </div>
  <div class="wdk-help" style="margin-bottom: 15px">
    <a
      class="wdk-docs-link"
      style="color: var(--e-a-color-txt-accent);  text-decoration: none; border-color: transparent"
      href="https://www.facebook.com/wdesignkit"
      target="_blank"
      rel="noopener noreferrer"
    >
      Join Facebook Community
    </a>
  </div>
  <div class="need-help" id="elementor-panel__editor__help">
    <a
      id="elementor-panel__editor__help__link"
      href="https://wordpress.org/support/plugin/wdesignkit/"
      target="_blank"
      style="
        margin: auto;
        color: #fff;
        background: #8072fc;
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: 400;
        font-size: 13px;
        letter-spacing: 0.4px;
        border: 1px solid #8072fc;
        box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-box-shadow: 0 2px 7px 0 rgba(0, 0, 0, 0.3);
        -webkit-transition: all 0.3s ease-in;
        -o-transition: all 0.3s ease-in;
        transition: all 0.3s ease-in;
      "
      >Need Help <i class="eicon-help-o" aria-hidden="true"></i>
    </a>
  </div>
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

            $this->start_controls_section(
            'Name_style_secdddtion',
            [
                'label' => esc_html__( 'Name', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_8i4fi425',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-item .wkit-team-name',
			)
            );
$this->add_control('color_gpny9w25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item .wkit-team-name' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Designation_style_secdddtion',
            [
                'label' => esc_html__( 'Designation', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_s33ynd25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-item .wkit-desgition',
			)
            );
$this->add_control('color_qsyd3325',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item .wkit-desgition' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Image_style_secdddtion',
            [
                'label' => esc_html__( 'Image', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_czqz3c25',
                array(
            
            'label' => esc_html__( 'Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper .wkit-team-item img' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_ivdsi225',
                array(
            
            'label' => esc_html__( 'Height', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper .wkit-team-item img' => 'height: {{SIZE}}{{UNIT}};',)
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Box Background_style_secdddtion',
            [
                'label' => esc_html__( 'Box Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_93rqy525',
                array(
            
            'label' => esc_html__( 'Border Width', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper .wkit-team-item::before' => 'border-width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_ced07j25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-item-inner figcaption',
        )
            );
$this->add_control('color_z7f25m25',
                array(
            
            'label' => esc_html__( 'Border Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item::before' => 'border-color: {{VALUE}}',),
        )
            );
$this->add_responsive_control('dimension_x6jdzc25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-item figure, {{WRAPPER}} .wkit-team-item::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Name_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Name', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_a4b48a25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-popup-content .wkit-team-name',
			)
            );
$this->add_control('color_o45pix25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-popup-content .wkit-team-name' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Designation_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Designation', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_zd9ooy25',
                array(
            
            'label' => esc_html__( 'Top Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-popup-content .wkit-desgition' => 'padding-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_tvxsma25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-team-popup-content .wkit-desgition',
			)
            );
$this->add_control('color_d7py1825',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-popup-content .wkit-desgition' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Description_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Description', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_responsive_control('slider_o6pwlp25',
                array(
            
            'label' => esc_html__( 'Top Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-team-details' => 'padding-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_qs6cqb25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-contet-group .wkit-team-details',
			)
            );
$this->add_control('color_w3r8qh25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-contet-group .wkit-team-details' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Telephone_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Telephone', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('heading_nlw18y25',
                array(
            
            'label' => esc_html__( 'Telephone Heading', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_x9bbp525',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-custom-team-tel',
			)
            );
$this->add_control('color_fucem525',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-custom-team-tel' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_jm7jaj25',
                array(
            
            'label' => esc_html__( 'Telephone Value', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_l97asv25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-contet-group .wkit-tel',
			)
            );
$this->add_control('color_qpfq4a25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-contet-group .wkit-tel' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Email_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Email', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('heading_4lzgsl25',
                array(
            
            'label' => esc_html__( 'Email Heading', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_responsive_control('slider_ybmuig25',
                array(
            
            'label' => esc_html__( 'Top Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => 10,
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-social-icons .wkit-em' => 'padding-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_rr39b825',
                'separator' => 'after',
                
                
                'selector' => '{{WRAPPER}} .wkit-custom-team-mail',
			)
            );
$this->add_control('color_6rk7ci25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-custom-team-mail' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_52f9w925',
                array(
            
            'label' => esc_html__( 'Email Value', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_p96c2b25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-contet-group .wkit-mail',
			)
            );
$this->add_control('color_7oaamy25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-contet-group .wkit-mail' => 'color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Social_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Social', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('heading_3bii6v25',
                array(
            
            'label' => esc_html__( 'Social Heading', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_group_control(
                
            Group_Control_Typography::get_type(),
			array(
				'name' => 'typography_mukppd25',
                
                
                
                'selector' => '{{WRAPPER}} .wkit-social-heading',
			)
            );
$this->add_control('color_psp5wo25',
                array(
            
            'label' => esc_html__( 'Text Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            'separator' => 'after',
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-social-heading' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('heading_omekog25',
                array(
            
            'label' => esc_html__( 'Social Icon', 'wdesignkit' ),
            'type' => Controls_Manager::HEADING,
            
            
            
        )
            );
$this->add_responsive_control('slider_rhixdu25',
                array(
            
            'label' => esc_html__( 'Top Gap', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group' => 'margin-top: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_lnxhkq25',
                array(
            
            'label' => esc_html__( 'Icon Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon i' => 'font-size: {{SIZE}}{{UNIT}};',)
        )
            );
$this->add_responsive_control('slider_0ftsr625',
                array(
            
            'label' => esc_html__( 'SVG Size', 'wdesignkit' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => array( "px","%", ),
            
            
            'range' => array('px' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),'%' => array(
						'min' => 0,
						'max' => 100,
						'step' => 1,
					),),
            'default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            'tablet_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'mobile_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
                'widescreen_default' => array(
                                    'unit' => 'px',
                                    'size' => '',
                                ),
            
            
            'render_type' => 'ui',
           
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon svg' => 'width: {{SIZE}}{{UNIT}};',)
        )
            );
$this->start_controls_tabs('normalhover_33yg1w25',
                array(
            
            
        )
            );
            $this->start_controls_tab(

                        'normalhover_33yg1w25_normal_tab',
                            array(
                                'label' => esc_html__( 'Normal', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_xiqxcy25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_m8snx025',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_czhl9p25',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_uczhj025',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon',
        )
            );
$this->add_responsive_control('dimension_fxyhai25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_c8c78825',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon', 
        )
            );
$this->end_controls_tab();
$this->start_controls_tab(

                        'normalhover_33yg1w25_hover_tab',
                            array(
                                'label' => esc_html__( 'Hover', 'wdesignkit' ),
                            )
                        );
$this->add_control('color_iowilt25',
                array(
            
            'label' => esc_html__( 'Icon Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-social-icon:hover' => 'color: {{VALUE}}',),
        )
            );
$this->add_control('color_3fkzjr25',
                array(
            
            'label' => esc_html__( 'SVG Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-social-group .wkit-team-social-icon:hover svg path' => 'fill: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Background::get_type(),
        array(
            'name' => 'background_fi8aq825',
            'label' => esc_html__( 'Background', 'wdesignkit' ),
            'types' => ["classic","gradient"],
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_mzyqil25',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon:hover',
        )
            );
$this->add_group_control(
                
        Group_Control_Box_Shadow::get_type(),
        array(
            'name' => 'boxshadow_3keluz25',
            'label' => esc_html__( 'Box Shadow', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-social-icon:hover', 
        )
            );
$this->end_controls_tab();


            $this->end_controls_tabs();$this->end_controls_section();$this->start_controls_section(
            'Popup Arrow_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Arrow', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('color_egnrya25',
                array(
            
            'label' => esc_html__( 'Arrow Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .addactive .wkit-team-item::after' => 'border-top-color: {{VALUE}}',),
        )
            );
$this->end_controls_section();$this->start_controls_section(
            'Popup Background_style_secdddtion',
            [
                'label' => esc_html__( 'Popup Background', 'wdesignkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );
$this->add_control('color_r69rk525',
                array(
            
            'label' => esc_html__( 'Background Color', 'wdesignkit' ),
            'type' =>  Controls_Manager::COLOR,
            
                            
            
            
            
            
            'alpha' => true,
            'global' => array(
                'active' => true,
            ),
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper .wkit-contet-group' => 'background: {{VALUE}}',),
        )
            );
$this->add_group_control(
                
        Group_Control_Border::get_type(),
        array(
            'name' => 'border_6e7kc625',
            'label' => esc_html__( 'Border', 'wdesignkit' ),
            
            
            
            'selector' => '{{WRAPPER}} .wkit-team-wrapper .wkit-contet-group',
        )
            );
$this->add_responsive_control('dimension_evrt9a25',
                array(
            
            'label' => esc_html__( 'Border Radius', 'wdesignkit' ),
            'type' => Controls_Manager::DIMENSIONS,
            
            
            'label_block' => true,
            'size_units' => array('px','%',),
            'default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            'tablet_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'mobile_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
                'widescreen_default' => array(
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => 'true',
                ),
            
            
            
            'selectors' => array('{{WRAPPER}} .wkit-team-wrapper .wkit-contet-group' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',),
        )
            );
$this->add_control('rawhtml_wphxye25',
                array(
            
            
            'type' => Controls_Manager::RAW_HTML,
            
            'raw' => wp_kses_post( '<div class="wdk-note" style="color: var(--e-a-color-txt-accent);
    background: #8072fc3b;
    padding: 10px;
    font-weight: 400; 
    border-left: 3px solid #8072FC;
    font-size: 12px;
    line-height: 15px;">
Note: After apply styles, please refresh the page to see proper updates.
</div>', 'wdesignkit' ),
            
            
            
            
            
        )
            );
$this->end_controls_section();

    }

    /**
     * Written in PHP and HTML.
     *
     * @since 1.2.17
     */
    protected function render() { 	

        $settings = $this->get_settings_for_display();
        $select_ei4raf25 = !empty($settings['select_ei4raf25']) ? $settings['select_ei4raf25'] : '';
$select_9xpqnx25 = !empty($settings['select_9xpqnx25']) ? $settings['select_9xpqnx25'] : '';
$slider_nq7cnw25 = !empty($settings['slider_nq7cnw25']) ? $settings['slider_nq7cnw25'] : '';
$choose_cy532j25 = !empty($settings['choose_cy532j25']) ? $settings['choose_cy532j25'] : '';
$switcher_rttsm925 = !empty($settings['switcher_rttsm925']) ? $settings['switcher_rttsm925'] : '';
$rawhtml_gguyjc25 = !empty($settings['rawhtml_gguyjc25']) ? $this->wdk_senitize_js($settings['rawhtml_gguyjc25']) : '';

        $repeater_kmwp2i25_6t25 = '';
                            if ( $settings['repeater_kmwp2i25'] ) {
                                foreach ( $settings['repeater_kmwp2i25'] as $key => $r_item ) {
                                    $media_m15gm525 = !empty($r_item['media_m15gm525']['url']) ? $this->wdk_senitize_js($r_item['media_m15gm525']['url']) : '';
$iconscontrol_wqep9825 = "";
                        if(!empty($r_item['iconscontrol_wqep9825']) && !empty($r_item['iconscontrol_wqep9825']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_wqep9825'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_wqep9825 .= $Icon;
                        };
$url_xbe8ka25_is_external = !empty($r_item['url_xbe8ka25']) && !empty($r_item['url_xbe8ka25']['is_external']) ? '_blank' : '';
$url_xbe8ka25_url = !empty($r_item['url_xbe8ka25']) && !empty($r_item['url_xbe8ka25']['url'])? $this->wdk_senitize_js($r_item['url_xbe8ka25']['url']) : '';
$url_xbe8ka25_nofollow = !empty($r_item['url_xbe8ka25']) && !empty($r_item['url_xbe8ka25']['nofollow'])? 'nofollow' : '';
$iconscontrol_az0lbh25 = "";
                        if(!empty($r_item['iconscontrol_az0lbh25']) && !empty($r_item['iconscontrol_az0lbh25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_az0lbh25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_az0lbh25 .= $Icon;
                        };
$url_eq0yfj25_is_external = !empty($r_item['url_eq0yfj25']) && !empty($r_item['url_eq0yfj25']['is_external']) ? '_blank' : '';
$url_eq0yfj25_url = !empty($r_item['url_eq0yfj25']) && !empty($r_item['url_eq0yfj25']['url'])? $this->wdk_senitize_js($r_item['url_eq0yfj25']['url']) : '';
$url_eq0yfj25_nofollow = !empty($r_item['url_eq0yfj25']) && !empty($r_item['url_eq0yfj25']['nofollow'])? 'nofollow' : '';
$iconscontrol_9uud6g25 = "";
                        if(!empty($r_item['iconscontrol_9uud6g25']) && !empty($r_item['iconscontrol_9uud6g25']['value'])){
                            ob_start();
                                \Elementor\Icons_Manager::render_icon($r_item['iconscontrol_9uud6g25'],['aria-hidden'=>'true']);
                                $Icon = ob_get_contents();
                            ob_end_clean();
                            $iconscontrol_9uud6g25 .= $Icon;
                        };
$url_8eg5uj25_is_external = !empty($r_item['url_8eg5uj25']) && !empty($r_item['url_8eg5uj25']['is_external']) ? '_blank' : '';
$url_8eg5uj25_url = !empty($r_item['url_8eg5uj25']) && !empty($r_item['url_8eg5uj25']['url'])? $this->wdk_senitize_js($r_item['url_8eg5uj25']['url']) : '';
$url_8eg5uj25_nofollow = !empty($r_item['url_8eg5uj25']) && !empty($r_item['url_8eg5uj25']['nofollow'])? 'nofollow' : '';

                                    $repeater_kmwp2i25_6t25 .= '<div class="elementor-repeater-item-' .esc_attr($r_item['_id']) . ' wkit-team-item-inner '.$select_ei4raf25.'  '.$select_9xpqnx25.' " data-repeater_kmwp2i25="{repeater_kmwp2i25}">
      <div class=" wkit-team-item">
          <figure>
              <img src="'.$media_m15gm525.'">
              <figcaption>
                  <div class="wkit-personal-info">
                    <h4 class="wkit-team-name">' . $this->wdk_senitize_js($r_item['text_k97ctl25']) . '</h4>
                    <h3 class="wkit-desgition">' . $this->wdk_senitize_js($r_item['text_nyzx7525']) . '</h3>
                  </div>
             </figcaption>
             <span class="select-fb-icon wkit-icon-none">'.$iconscontrol_wqep9825.'</span>
             <span class="select-gp-icon wkit-icon-none">'.$iconscontrol_az0lbh25.'</span>
             <span class="select-twitter-icon wkit-icon-none">'.$iconscontrol_9uud6g25.'</span>
             <span class="wkit-tel wkit-icon-none" data-tel="' . $this->wdk_senitize_js($r_item['text_dymg2u25']) . '">' . $this->wdk_senitize_js($r_item['text_dymg2u25']) . '</span>
         </figure>
    </div>
         <div class="wkit-team-popup-content" data-position="'.$switcher_rttsm925.'" data-name="' . $this->wdk_senitize_js($r_item['text_k97ctl25']) . '" data-degination="' . $this->wdk_senitize_js($r_item['text_nyzx7525']) . '" data-details="' . $this->wdk_senitize_js($r_item['textarea_u91pvf25']) . '" data-tel="' . $this->wdk_senitize_js($r_item['text_dymg2u25']) . '" data-mail="' . $this->wdk_senitize_js($r_item['text_weefrh25']) . '" data-fb="'.$url_xbe8ka25_url.'" data-fb-target="'.$url_xbe8ka25_is_external.'" data-fb-rel="'.$url_xbe8ka25_nofollow.'" data-gp="'.$url_eq0yfj25_url.'" data-gp-target="'.$url_eq0yfj25_is_external.'" gp-rel="'.$url_eq0yfj25_nofollow.'" data-twitter="'.$url_8eg5uj25_url.'" data-twitter-target="'.$url_8eg5uj25_is_external.'" data-twitter-rel="'.$url_8eg5uj25_nofollow.'" style="display:none">
    </div>
   </div>';
                                }
                            }

        $output = '';
        $output .= '<div class="wkit-wb-Widget_f5p7zn25" data-wdkitunique="f5p7zn25">';
            $output .= '<div class="wkit-team-wrapper ">
    '.$repeater_kmwp2i25_6t25.'
   
</div>';
        $output .= '</div>';
        
        echo $output;
    }
}