<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( ! function_exists( 'nabhi_setup' ) ) {
	add_action( 'after_setup_theme', 'nabhi_setup' );
	// Sets up theme defaults and registers support for various WordPress features.
	function nabhi_setup() {
		
		add_editor_style( 'style.css' );
		
	}
}

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'martanda_background_setup' );
function martanda_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => 'ffffff',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Replace default fonts from parent theme
function martanda_get_font_face_styles() {
	return "
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 100;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 200;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 300;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 400;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 500;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 600;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 700;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 800;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Nunito Sans';
		font-weight: 900;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/NunitoSans.woff2') format('woff2');
	}
	";
}

function martanda_font_family_css() {
	// Get our settings
	$martanda_settings = wp_parse_args(
		get_option( 'martanda_settings', array() ),
		martanda_get_defaults()
	);

	// Initiate our class
	$css = new martanda_css;
	
	$og_defaults = martanda_get_defaults( false );
	
	$bodyclass = 'body';
	if ( is_admin() ) {
		$bodyclass = '.editor-styles-wrapper';
	}
	
	$bodyfont = $martanda_settings[ 'font_body' ];
	if ( $bodyfont == 'inherit' ) { $bodyfont = 'Nunito Sans'; }
	
	$font_site_title = $martanda_settings[ 'font_site_title' ];
	if ( $font_site_title == 'inherit' ) { $font_site_title = 'Nunito Sans'; }
	$font_navigation = $martanda_settings[ 'font_navigation' ];
	if ( $font_navigation == 'inherit' ) { $font_navigation = 'Nunito Sans'; }
	$font_buttons = $martanda_settings[ 'font_buttons' ];
	if ( $font_buttons == 'inherit' ) { $font_buttons = 'Nunito Sans'; }
	$font_heading_1 = $martanda_settings[ 'font_heading_1' ];
	if ( $font_heading_1 == 'inherit' ) { $font_heading_1 = 'Nunito Sans'; }
	$font_heading_2 = $martanda_settings[ 'font_heading_2' ];
	if ( $font_heading_2 == 'inherit' ) { $font_heading_2 = 'Nunito Sans'; }
	$font_heading_3 = $martanda_settings[ 'font_heading_3' ];
	if ( $font_heading_3 == 'inherit' ) { $font_heading_3 = 'Nunito Sans'; }
	$font_heading_4 = $martanda_settings[ 'font_heading_4' ];
	if ( $font_heading_4 == 'inherit' ) { $font_heading_4 = 'Nunito Sans'; }
	$font_heading_5 = $martanda_settings[ 'font_heading_5' ];
	if ( $font_heading_5 == 'inherit' ) { $font_heading_5 = 'Nunito Sans'; }
	$font_heading_6 = $martanda_settings[ 'font_heading_6' ];
	if ( $font_heading_6 == 'inherit' ) { $font_heading_6 = 'Nunito Sans'; }
	$font_footer = $martanda_settings[ 'font_footer' ];
	if ( $font_footer == 'inherit' ) { $font_footer = 'Nunito Sans'; }
	$font_fixed_side = $martanda_settings[ 'font_fixed_side' ];
	if ( $font_fixed_side == 'inherit' ) { $font_fixed_side = 'Nunito Sans'; }
	
	$css->set_selector( $bodyclass );
	$css->add_property( '--martanda--font-body', esc_attr( $bodyfont ) );
	$css->add_property( '--martanda--font-site-title', esc_attr( $font_site_title ) );
	$css->add_property( '--martanda--font-navigation', esc_attr( $font_navigation ) );
	$css->add_property( '--martanda--font-buttons', esc_attr( $font_buttons ) );
	$css->add_property( '--martanda--font-heading-1', esc_attr( $font_heading_1 ) );
	$css->add_property( '--martanda--font-heading-2', esc_attr( $font_heading_2 ) );
	$css->add_property( '--martanda--font-heading-3', esc_attr( $font_heading_3 ) );
	$css->add_property( '--martanda--font-heading-4', esc_attr( $font_heading_4 ) );
	$css->add_property( '--martanda--font-heading-5', esc_attr( $font_heading_5 ) );
	$css->add_property( '--martanda--font-heading-6', esc_attr( $font_heading_6 ) );
	$css->add_property( '--martanda--font-footer', esc_attr( $font_footer ) );
	$css->add_property( '--martanda--font-fixed-side', esc_attr( $font_fixed_side ) );
	
	$css->set_selector( '.editor-styles-wrapper .top-bar-socials button' );
	$css->add_property( 'background-color', 'inherit' );
	
	// Allow us to hook CSS into our output
	do_action( 'martanda_font_family_css', $css );

	return apply_filters( 'martanda_font_family_css_output', $css->css_output() );
}

// Overwrite theme URL
function martanda_theme_uri_link() {
	return 'https://wpkoi.com/nabhi-wpkoi-wordpress-theme/';
}

// Extra cutomizer functions
if ( ! function_exists( 'nabhi_customize_register' ) ) {
	add_action( 'customize_register', 'nabhi_customize_register' );
	function nabhi_customize_register( $wp_customize ) {
				
		// Add Nabhi customizer section
		$wp_customize->add_section(
			'nabhi_layout_effects',
			array(
				'title' => __( 'Nabhi style', 'nabhi' ),
				'priority' => 24,
			)
		);
		
		// Borders
		$wp_customize->add_setting(
			'nabhi_settings[fsc_border]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'nabhi_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'nabhi_settings[fsc_border]',
			array(
				'type' => 'select',
				'label' => __( 'Fixed content border', 'nabhi' ),
				'choices' => array(
					'enable' => __( 'Enable', 'nabhi' ),
					'disable' => __( 'Disable', 'nabhi' )
				),
				'settings' => 'nabhi_settings[fsc_border]',
				'section' => 'nabhi_layout_effects',
				'priority' => 30
			)
		);
		
		$wp_customize->add_setting(
			'nabhi_settings[hfc_border]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'nabhi_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'nabhi_settings[hfc_border]',
			array(
				'type' => 'select',
				'label' => __( 'Other borders', 'nabhi' ),
				'choices' => array(
					'enable' => __( 'Enable', 'nabhi' ),
					'disable' => __( 'Disable', 'nabhi' )
				),
				'settings' => 'nabhi_settings[hfc_border]',
				'section' => 'nabhi_layout_effects',
				'priority' => 30
			)
		);
		
		// Effect colors
		$wp_customize->add_setting(
			'nabhi_settings[nabhi_color_1]', array(
				'default' => '#000000',
				'type' => 'option',
				'sanitize_callback' => 'nabhi_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'nabhi_settings[nabhi_color_1]',
				array(
					'label' => __( 'Border color', 'nabhi' ),
					'section' => 'nabhi_layout_effects',
					'settings' => 'nabhi_settings[nabhi_color_1]',
					'priority' => 35
				)
			)
		);
		
	}
}

//Sanitize choices.
if ( ! function_exists( 'nabhi_sanitize_choices' ) ) {
	function nabhi_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// Sanitize colors. Allow blank value.
if ( ! function_exists( 'nabhi_sanitize_hex_color' ) ) {
	function nabhi_sanitize_hex_color( $color ) {
	    if ( '' === $color ) {
	        return '';
		}

	    // 3 or 6 hex digits, or the empty string.
	    if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
	        return $color;
		}

	    return '';
	}
}

// Nabhi effects css
if ( ! function_exists( 'nabhi_effect_css' ) ) {
	function nabhi_effect_css() {
		// Get Customizer settings
		$nabhi_settings = get_option( 'nabhi_settings' );
		
		$nabhi_color_1	 = isset( $nabhi_settings['nabhi_color_1'] ) ? $nabhi_settings['nabhi_color_1'] : '#000000';
		
		$nabhi_effect_css = 'body {--martanda--nabhi-color-1: ' . esc_attr( $nabhi_color_1 ) . ';}';
		
		return $nabhi_effect_css;
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'nabhi_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'nabhi_remove_parent_dynamic_css' );
	function nabhi_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'martanda_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'nabhi_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'nabhi_enqueue_parent_dynamic_css', 50 );
	function nabhi_enqueue_parent_dynamic_css() {
		$css = martanda_get_font_face_styles() . martanda_font_family_css() . martanda_base_css() . nabhi_effect_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'martanda-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'nabhi_body_classes' ) ) {
	add_filter( 'body_class', 'nabhi_body_classes' );
	function nabhi_body_classes( $classes ) {
		// Get Customizer settings
		$nabhi_settings = get_option( 'nabhi_settings' );
		
		$fsc_border	 = isset( $nabhi_settings['fsc_border'] ) ? $nabhi_settings['fsc_border'] : 'enable';
		$hfc_border	 = isset( $nabhi_settings['hfc_border'] ) ? $nabhi_settings['hfc_border'] : 'enable';
		
		// Borders
		if ( $fsc_border != 'disable' ) {
			$classes[] = 'nabhi-fsc-border';
		}
		
		if ( $hfc_border != 'disable' ) {
			$classes[] = 'nabhi-hfc-border';
		}
		
		return $classes;
	}
}
